/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.RelativeLayout;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.gdpr.CommonUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.crosspro.ui.CPLandscapeActivity;
import com.tradplus.crosspro.ui.CPPortraitActivity;
import com.tradplus.crosspro.ui.InterstitialView;
import java.io.Serializable;

public class CPAdActivity
extends Activity {
    private static final String TAG = CPAdActivity.class.getSimpleName();
    private int mScreenWidth;
    private int mScreenHeight;
    private CPAdResponse cpAdResponse;
    private static final String EXTRA_IS_SHOW_END_CARD = "extra_is_show_end_card";
    private static final String EXTRA_CPADRESPONSE_AD = "extra_adResponse_ad";
    private static final String EXTRA_REQUEST_ID = "extra_request_id";
    private static final String EXTRA_ORIENTATION_AD = "extra_orientation";
    private static final String EXTRA_FULLSCREEN_AD = "extra_full_screen";
    private static final String EXTRA_INTERSTITIAL_AD = "extra_isinterstitial";
    private static final String EXTRA_DIRECTION = "extra_direction";
    private static final String EXTRA_ADSOURCEID_AD = "extra_adsourceid";
    private static String campaignId;
    private static String adId;
    private CPAdResponse mCPAdResponse;
    private int mOrientation;
    private int mfullScreen;
    private String adSourceId;
    private RelativeLayout mRoot;
    private InterstitialView interstitialView;

    public static void start(Context context, CPAdResponse cpAdResponse, int orientation, long timeStamp, String adSourceId, int full_screen, boolean isInterstitial, int direction) {
        Intent intent = new Intent();
        campaignId = cpAdResponse.getCampaign_id();
        adId = cpAdResponse.getAd_id();
        if (orientation == 2) {
            intent.setClass(context, CPLandscapeActivity.class);
        } else {
            intent.setClass(context, CPPortraitActivity.class);
        }
        intent.putExtra(EXTRA_CPADRESPONSE_AD, (Serializable)cpAdResponse);
        intent.putExtra("timeStamp", timeStamp);
        intent.putExtra(EXTRA_ORIENTATION_AD, orientation);
        intent.putExtra(EXTRA_ADSOURCEID_AD, adSourceId);
        intent.putExtra(EXTRA_FULLSCREEN_AD, full_screen);
        intent.putExtra(EXTRA_INTERSTITIAL_AD, isInterstitial);
        intent.putExtra(EXTRA_DIRECTION, direction);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void start(Context context, CPAdResponse cpAdResponse, int orientation, long timeStamp, String adSourceId) {
        CPAdActivity.start(context, cpAdResponse, orientation, timeStamp, adSourceId, 1, false, 0);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.readSaveInstance(savedInstanceState);
        this.setContentView(this.getLayoutIdByAdFormat());
        this.init();
    }

    private void readSaveInstance(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.interstitialView != null) {
            this.interstitialView.setShowEndCard(savedInstanceState.getBoolean(EXTRA_IS_SHOW_END_CARD));
        }
    }

    private int getLayoutIdByAdFormat() {
        return CommonUtil.getResId((Context)this, (String)"cp_activity_ad", (String)"layout");
    }

    private void init() {
        this.getScreenParams();
        this.cpAdResponse = (CPAdResponse)this.getIntent().getSerializableExtra(EXTRA_CPADRESPONSE_AD);
        this.mOrientation = this.getIntent().getIntExtra(EXTRA_ORIENTATION_AD, 0);
        this.mfullScreen = this.getIntent().getIntExtra(EXTRA_FULLSCREEN_AD, 0);
        this.adSourceId = this.getIntent().getStringExtra(EXTRA_ADSOURCEID_AD);
        boolean isInterstitial = this.getIntent().getBooleanExtra(EXTRA_INTERSTITIAL_AD, false);
        long timeStamp = this.getIntent().getLongExtra("timeStamp", 0L);
        int direction = this.getIntent().getIntExtra(EXTRA_DIRECTION, 0);
        this.mRoot = (RelativeLayout)this.findViewById(CommonUtil.getResId((Context)this, (String)"cp_rl_root", (String)"id"));
        this.interstitialView = new InterstitialView((Context)this);
        this.interstitialView.setCpAdResponse(this.cpAdResponse);
        this.interstitialView.setmOrientation(this.mOrientation);
        this.interstitialView.setAdSourceId(this.adSourceId);
        this.interstitialView.setInterstitial(isInterstitial);
        this.interstitialView.setTimeStamp(timeStamp);
        this.interstitialView.setMfullScreen(this.mfullScreen);
        this.interstitialView.setmScreenWidth(this.mScreenWidth);
        this.interstitialView.setDirection(direction);
        this.interstitialView.setmScreenHeight(this.mScreenHeight);
        this.interstitialView.setOnViewFinish(new InterstitialView.OnViewFinish(){

            @Override
            public void onFinish() {
                CPAdActivity.this.finish();
            }
        });
        this.interstitialView.initView();
        this.mRoot.addView((View)this.interstitialView);
    }

    private void getScreenParams() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
        if (this.mScreenWidth > this.mScreenHeight) {
            this.setRequestedOrientation(6);
        } else {
            this.setRequestedOrientation(1);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        LogUtil.ownShow((String)"onSaveInstanceState...");
        if (this.interstitialView != null && this.interstitialView.isShowEndCard()) {
            LogUtil.ownShow((String)"onSaveInstanceState... mIsShowEndCard - true");
            outState.putBoolean(EXTRA_IS_SHOW_END_CARD, true);
        }
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)"CrossPro", (String)"onResume: ");
        try {
            if (this.interstitialView != null && this.interstitialView.getmPlayerView() != null && !this.interstitialView.getmPlayerView().isPlaying()) {
                this.interstitialView.getmPlayerView().start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        super.onPause();
        Log.i((String)"CrossPro", (String)"onResume: ");
        if (this.interstitialView != null && this.interstitialView.getmPlayerView() != null) {
            this.interstitialView.getmPlayerView().pause();
        }
    }

    protected void onDestroy() {
        Log.i((String)"CrossPro", (String)"onDestroy: ");
        if (this.interstitialView != null) {
            if (this.interstitialView.getCpClickController() != null) {
                this.interstitialView.getCpClickController().cancelClick();
            }
            if (this.interstitialView.getVideoPlayFinish() == 0 && this.interstitialView.getVideoPlayCompletion() == 0 && !TextUtils.isEmpty((CharSequence)this.cpAdResponse.getVideo_url())) {
                EventSendMessageUtil.getInstance().sendAdVideoClose((Context)this, campaignId, adId, "1", this.adSourceId);
            } else {
                EventSendMessageUtil.getInstance().sendAdVideoClose((Context)this, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "1", this.adSourceId);
            }
        }
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (4 == keyCode) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

