/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.tradplus.ads.network.util.ImageLoader;
import com.tradplus.ads.network.util.ResourceEntry;

public class NativeImageView
extends ImageView {
    public static final String TAG = NativeImageView.class.getSimpleName();
    String mImageUrl;

    public NativeImageView(Context context) {
        super(context);
    }

    public NativeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NativeImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setImage(String url, int width, int height) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.e((String)TAG, (String)"load: url is empty!");
            return;
        }
        this.mImageUrl = url;
        ImageLoader.getInstance((Context)this.getContext()).load(new ResourceEntry(2, url), width, height, new ImageLoader.ImageLoaderListener(){

            public void onSuccess(String url, Bitmap bitmap) {
                if (TextUtils.equals((CharSequence)NativeImageView.this.mImageUrl, (CharSequence)url)) {
                    NativeImageView.this.setImageBitmap(bitmap);
                }
            }

            public void onFail(String url, String error) {
                Log.e((String)TAG, (String)("load: image load fail:" + error));
            }
        });
    }

    public void setImage(String url) {
        int width = -1;
        int height = -1;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            this.setImage(url, layoutParams.width, layoutParams.height);
        } else {
            this.setImage(url, width, height);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onDraw(Canvas canvas) {
        try {
            super.onDraw(canvas);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

