/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.base.network.util.ImageLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.china.common.ApkDownloadManager;
import com.tradplus.china.common.download.ApkRequest;
import com.tradplus.china.common.resource.ApkResource;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPResourceManager;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.ui.ApkConfirmDialogActivity;

public class CPAdManager {
    private static CPAdManager sIntance;
    private Context mContext;

    private CPAdManager(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static CPAdManager getInstance(Context context) {
        if (sIntance == null) {
            sIntance = new CPAdManager(context);
        }
        return sIntance;
    }

    public void load(String placementId, CPLoader.CPLoaderListener listener, String adSourceId) {
        CPResourceManager.getInstance().load(this.mContext, placementId, this.getCpAdConfig(placementId), listener, adSourceId);
    }

    public void startDownloadApp(final String requestId, final CPAdResponse cpAdResponse, final String url, final String adSourceId) {
        Log.i((String)"servicedownload", (String)"startDownloadApp: ");
        TradPlus.invoker().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (1 == cpAdResponse.getClick_confirm()) {
                    ApkConfirmDialogActivity.start(CPAdManager.this.mContext, requestId, cpAdResponse, url, adSourceId);
                } else {
                    CPAdManager.this.realStartDownloadApp(adSourceId, cpAdResponse, url);
                }
            }
        });
    }

    public void realStartDownloadApp(String requestId, CPAdResponse cpAdResponse, String url) {
        Log.i((String)"servicedownload", (String)"realStartDownloadApp: ");
        if (ApkResource.isApkInstalled((Context)GlobalTradPlus.getInstance().getContext(), (String)cpAdResponse.getAd_pkg_name())) {
            ApkResource.openApp((Context)GlobalTradPlus.getInstance().getContext(), (String)cpAdResponse.getAd_pkg_name());
        } else {
            ApkRequest apkRequest = new ApkRequest();
            apkRequest.requestId = requestId;
            apkRequest.offerId = cpAdResponse.getCampaign_id();
            apkRequest.url = url;
            apkRequest.pkgName = cpAdResponse.getAd_pkg_name();
            apkRequest.title = cpAdResponse.getAd_name();
            apkRequest.setAdid(cpAdResponse.getAd_id());
            apkRequest.setPid(cpAdResponse.getCampaign_id());
            apkRequest.setAsuid(requestId);
            int size = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)GlobalTradPlus.getInstance().getContext().getResources().getDisplayMetrics());
            apkRequest.icon = ImageLoader.getInstance((Context)this.mContext).getBitmapFromDiskCache(new ResourceEntry(1, ""), size, size);
            long cache_time = cpAdResponse.getCreative_cache_time();
            ApkDownloadManager.getInstance((Context)GlobalTradPlus.getInstance().getContext()).setCPCacheTime(cache_time > 0L ? cache_time : 86400000L);
            ApkDownloadManager.getInstance((Context)GlobalTradPlus.getInstance().getContext()).checkAndCleanApk();
            ApkDownloadManager.getInstance((Context)GlobalTradPlus.getInstance().getContext()).handleClick(apkRequest);
        }
    }

    public CPAdResponse getCpAdConfig(String pid) {
        return CPAdConfigController.getCpAdResponse(pid);
    }

    public boolean isReady(String pid) {
        CPAdResponse _cpAdResponse = this.getCpAdConfig(pid);
        if (this.mContext == null || _cpAdResponse == null) {
            return false;
        }
        return CPResourceManager.getInstance().isExist(_cpAdResponse);
    }
}

