/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.base.network.util.ImageLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.TaskUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.crosspro.R;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPClickController;
import com.tradplus.crosspro.network.splash.CPSplashAd;
import com.tradplus.crosspro.ui.EndCardView;
import java.util.ArrayList;
import java.util.List;

public class SplashView
extends LinearLayout {
    private int mScreenWidth;
    private int mScreenHeight;
    private ImageView img_endcard;
    private Button view_countdown;
    private Button view_skip;
    private ImageView img_bg;
    private ImageView img_tips;
    private int countdown_time;
    private int direction;
    private EndCardView.OnEndCardListener mListener;
    private Handler handler;
    private boolean isSkip;
    private CPAdResponse cpAdResponse;
    private Context context;
    private CPClickController cpClickController;
    private String adsourceId;
    private CPSplashAd.OnSplashShownListener onSplashShownListener;
    private Runnable countDownRunnable = new Runnable(){

        @Override
        public void run() {
            SplashView.this.view_countdown.setVisibility(0);
            SplashView.this.countdown_time--;
            SplashView.this.view_countdown.setText((CharSequence)(SplashView.this.countdown_time + ""));
            if (SplashView.this.countdown_time > 0 && !SplashView.this.isSkip) {
                SplashView.this.countDown();
            } else if (SplashView.this.mListener != null && !SplashView.this.isSkip) {
                EventSendMessageUtil.getInstance().sendAdVideoClose(SplashView.this.context, SplashView.this.cpAdResponse.getCampaign_id(), SplashView.this.cpAdResponse.getAd_id(), "1", SplashView.this.adsourceId);
                SplashView.this.mListener.onCloseEndCard();
            }
        }
    };
    private boolean isClicking;
    private boolean isShowView;

    public SplashView(Context context) {
        super(context);
        this.init(context);
    }

    public SplashView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.getScreenParams(context);
    }

    public void initView(final Context context, String campaignId, int countdowntime, int is_skipable, int direction, final String adsourceId, EndCardView.OnEndCardListener listener, CPSplashAd.OnSplashShownListener onSplashShownListener) {
        this.countdown_time = countdowntime;
        this.direction = direction;
        this.mListener = listener;
        this.adsourceId = adsourceId;
        this.onSplashShownListener = onSplashShownListener;
        this.handler = new Handler();
        SplashView.inflate((Context)context, (int)ResourceUtils.getLayoutIdByName((Context)context, (String)"cp_layout_splash"), (ViewGroup)this);
        this.img_endcard = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_img_end"));
        this.view_countdown = (Button)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_view_countdown"));
        this.img_bg = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_img_bg"));
        this.img_tips = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_img_tips"));
        this.view_skip = (Button)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_view_skip"));
        this.view_countdown.setText((CharSequence)(this.countdown_time + ""));
        this.setClickableBackground();
        this.setGlobalFocusChange();
        if (is_skipable == 1) {
            this.view_skip.setVisibility(0);
            this.view_skip.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SplashView.this.isSkip = true;
                    if (SplashView.this.mListener != null) {
                        EventSendMessageUtil.getInstance().sendAdVideoClose(context, SplashView.this.cpAdResponse.getCampaign_id(), SplashView.this.cpAdResponse.getAd_id(), "", adsourceId);
                        SplashView.this.mListener.onCloseEndCard();
                    }
                }
            });
        }
        this.img_endcard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplashView.this.onClick();
            }
        });
        this.cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(campaignId);
        EventSendMessageUtil.getInstance().sendShowAdStart(this.getContext(), campaignId, this.cpAdResponse.getAd_id(), adsourceId);
        this.loadBitmap(this.cpAdResponse);
        EventSendMessageUtil.getInstance().sendShowEndAd(context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), "1", adsourceId);
    }

    private void setClickableBackground() {
        if (TradPlus.invoker().getChinaHandler() != null) {
            this.view_skip.setBackgroundResource(R.drawable.cp_btn_skip_zh_pressed);
            this.img_tips.setBackgroundResource(R.drawable.cp_ad_cn);
        } else {
            this.view_skip.setBackgroundResource(R.drawable.cp_btn_skip_pressed);
            this.img_tips.setBackgroundResource(R.drawable.cp_ad);
        }
    }

    private void countDown() {
        TaskUtils.runOnUiThread((Runnable)this.countDownRunnable, (long)1000L);
    }

    private void loadBitmap(final CPAdResponse cpAdResponse) {
        try {
            String url = ((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(0)).getUrl();
            ImageLoader.getInstance((Context)this.getContext()).load(new ResourceEntry(1, url), this.mScreenWidth, this.mScreenHeight, new ImageLoader.ImageLoaderListener(){

                public void onSuccess(String url, Bitmap bitmap) {
                    SplashView.this.img_endcard.setImageBitmap(bitmap);
                    SplashView.this.sendTrackStart(SplashView.this.context, false);
                    EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(SplashView.this.context, EventPushMessageUtils.EventPushStats.EV_SHOW_PUSH_FAILED.getValue());
                    _eventShowEndRequest.setCampaign_id(cpAdResponse.getCampaign_id());
                    _eventShowEndRequest.setAd_id(cpAdResponse.getAd_id());
                    _eventShowEndRequest.setAsu_id(SplashView.this.adsourceId);
                    EventSendMessageUtil.getInstance().pushTrackToServer(SplashView.this.context, SplashView.this.replanceTrackIds(cpAdResponse.getImp_track_url_list()), _eventShowEndRequest);
                    if (SplashView.this.onSplashShownListener != null) {
                        SplashView.this.onSplashShownListener.onShown();
                    }
                    if (SplashView.this.countdown_time > 0) {
                        SplashView.this.countDown();
                    }
                }

                public void onFail(String url, String errorMsg) {
                }
            });
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onClick() {
        LogUtil.ownShow((String)"click \u3002\u3002\u3002\u3002\u3002");
        EventSendMessageUtil.getInstance().sendClickAd(this.context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adsourceId);
        if (this.isClicking) {
            LogUtil.ownShow((String)"during click \u3002\u3002\u3002\u3002\u3002");
            return;
        }
        if (this.cpAdResponse == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onClickEndCard();
        }
        if (this.cpAdResponse != null && this.context != null) {
            this.sendTrackStart(this.context, true);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.context, EventPushMessageUtils.EventPushStats.EV_CLICK_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.cpAdResponse.getCampaign_id());
            _eventShowEndRequest.setAd_id(this.cpAdResponse.getAd_id());
            _eventShowEndRequest.setAsu_id(this.adsourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.context, this.replanceTrackIds(this.cpAdResponse.getClick_track_url_list()), _eventShowEndRequest);
        }
        this.cpClickController = new CPClickController(this.context, this.cpAdResponse, this.adsourceId);
        this.cpClickController.startClick("", new CPClickController.ClickStatusCallback(){

            @Override
            public void clickStart() {
                SplashView.this.isClicking = true;
            }

            @Override
            public void clickEnd() {
                SplashView.this.isClicking = false;
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }

            @Override
            public void downloadApp(final String url) {
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CPAdManager.getInstance(SplashView.this.context).startDownloadApp(SplashView.this.cpAdResponse.getCampaign_id(), SplashView.this.cpAdResponse, url, SplashView.this.adsourceId);
                    }
                });
            }
        });
    }

    private List<String> replanceTrackIds(List<String> list) {
        ArrayList<String> _list = new ArrayList<String>();
        TPDataManager tpDataManager = TPDataManager.getInstance();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String url = list.get(i).replace("__TP_REQ_ID__", tpDataManager.getIds(this.adsourceId).getRequest_id()).replace("__TP_IMP_ID__", tpDataManager.getIds(this.adsourceId).getImpression_id()).replace("__TP_CLK_ID__", tpDataManager.getIds(this.adsourceId).getClick_id());
                LogUtil.ownShow((String)("cross pro url = " + url));
                _list.add(url);
            }
        }
        return _list;
    }

    private void sendTrackStart(Context context, boolean isClick) {
        List<String> _list = this.replanceTrackIds(isClick ? this.cpAdResponse.getClick_track_url_list() : this.cpAdResponse.getImp_track_url_list());
        if (_list != null) {
            for (int i = 0; i < _list.size(); ++i) {
                EventSendMessageUtil.getInstance().sendThirdCheckStart(context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adsourceId, isClick, _list.get(i));
            }
        }
    }

    private void setGlobalFocusChange() {
        this.getViewTreeObserver().addOnGlobalFocusChangeListener(new ViewTreeObserver.OnGlobalFocusChangeListener(){

            public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                if (!SplashView.this.isShowView) {
                    SplashView.this.isShowView = true;
                }
            }
        });
    }

    private void getScreenParams(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
    }
}

