/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAd;
import com.tradplus.crosspro.network.rewardvideo.CPRewardVideoAdListener;
import java.util.Map;

public class CPADRewardVideoAdapter
extends TPRewardAdapter {
    private String campaignId;
    private String adSourceId;
    private CPRewardVideoAd cpRewardVideoAd;
    private long timeoutValue = 10800000L;
    private long mFirstLoadTime;
    public static final long TIME_DELTA = 30000L;
    private static String TAG = "CrossPro";
    private int direction;
    private boolean isReward;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        Object d;
        if (this.extrasAreValid(tpParams)) {
            this.campaignId = tpParams.get("placementId");
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (tpParams.containsKey("adsource_placement_id")) {
            this.adSourceId = tpParams.get("adsource_placement_id");
        }
        if ((d = userParams.get("direction")) != null) {
            this.direction = Integer.parseInt(String.valueOf(d));
        }
        this.cpRewardVideoAd = new CPRewardVideoAd(context, this.campaignId, this.adSourceId);
        this.cpRewardVideoAd.setCpRewardVideoAdListener(new CPRewardVideoAdListener(){

            @Override
            public void onVideoAdPlayStart() {
                Log.i((String)TAG, (String)"onVideoAdPlayStart: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoStart();
                }
            }

            @Override
            public void onVideoAdPlayEnd() {
                Log.i((String)TAG, (String)"onVideoAdPlayEnd: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoEnd();
                }
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                Log.i((String)TAG, (String)"onVideoShowFailed: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoError(CPErrorUtil.getTradPlusErrorCode(error));
                }
            }

            @Override
            public void onRewarded() {
                Log.i((String)TAG, (String)"onRewarded: ");
                CPADRewardVideoAdapter.this.isReward = true;
            }

            @Override
            public void onInterstitialLoad() {
            }

            @Override
            public void onInterstitialLoaded() {
                Log.i((String)TAG, (String)"onInterstitialLoaded: ");
                CPADRewardVideoAdapter.this.setTimeoutValue(CPADRewardVideoAdapter.this.cpRewardVideoAd.getExpreTime());
                CPADRewardVideoAdapter.this.mFirstLoadTime = System.currentTimeMillis();
                if (CPADRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    CPADRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            @Override
            public void onInterstitialFailed(TPError error) {
                Log.i((String)TAG, (String)"onInterstitialFailed: ");
                if (CPADRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    CPADRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(error);
                }
            }

            @Override
            public void onInterstitialShown() {
                Log.i((String)TAG, (String)"onInterstitialShown: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdShown();
                }
            }

            @Override
            public void onInterstitialClicked() {
                Log.i((String)TAG, (String)"onInterstitialClicked: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdVideoClicked();
                }
            }

            @Override
            public void onLeaveApplication() {
                Log.i((String)TAG, (String)"onLeaveApplication: ");
            }

            @Override
            public void onInterstitialDismissed() {
                Log.i((String)TAG, (String)"onInterstitialDismissed: ");
                if (CPADRewardVideoAdapter.this.mShowListener != null && CPADRewardVideoAdapter.this.isReward) {
                    CPADRewardVideoAdapter.this.mShowListener.onReward();
                }
                if (CPADRewardVideoAdapter.this.mShowListener != null) {
                    CPADRewardVideoAdapter.this.mShowListener.onAdClosed();
                }
            }

            @Override
            public void onInterstitialRewarded(String currencyName, int amount) {
                Log.i((String)TAG, (String)"onInterstitialRewarded: ");
            }
        });
        this.cpRewardVideoAd.setDirection(this.direction);
        this.cpRewardVideoAd.load();
    }

    public void showAd() {
        if (this.cpRewardVideoAd != null) {
            this.cpRewardVideoAd.show();
        }
    }

    public boolean isReady() {
        if (this.cpRewardVideoAd != null) {
            return this.cpRewardVideoAd.isReady() && !this.isAdsTimeOut();
        }
        return false;
    }

    public void clean() {
        super.clean();
        if (this.cpRewardVideoAd != null) {
            this.cpRewardVideoAd.setCpRewardVideoAdListener(null);
            this.cpRewardVideoAd = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("27");
    }

    public String getNetworkVersion() {
        return null;
    }

    private boolean extrasAreValid(Map<String, String> tpParams) {
        String placementId = tpParams.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public void setTimeoutValue(long timeoutValue) {
        this.timeoutValue = timeoutValue;
    }

    public boolean isAdsTimeOut() {
        return System.currentTimeMillis() - this.mFirstLoadTime + 30000L > this.timeoutValue;
    }
}

