/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.CommonUtil;

public class LoadingView {
    private ViewGroup mRoot;
    private ImageView mLoadingIv;

    public LoadingView(ViewGroup container) {
        this.mRoot = container;
        this.mLoadingIv = new ImageView(this.mRoot.getContext());
        this.mLoadingIv.setId(CommonUtil.getResId((Context)this.mRoot.getContext(), (String)"cp_loading_id", (String)"id"));
        this.mLoadingIv.setImageResource(CommonUtil.getResId((Context)this.mRoot.getContext(), (String)"cp_loading", (String)"drawable"));
    }

    private void addView() {
        if (this.mLoadingIv != null) {
            this.mRoot.removeView((View)this.mLoadingIv);
        }
        int size = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.mRoot.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(size, size);
        rl.addRule(13);
        this.mRoot.addView((View)this.mLoadingIv, (ViewGroup.LayoutParams)rl);
    }

    public void startLoading() {
        this.addView();
        this.mLoadingIv.post(new Runnable(){

            @Override
            public void run() {
                LoadingView.this.mLoadingIv.setAlpha(1.0f);
                RotateAnimation ra = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
                ra.setDuration(1000L);
                ra.setInterpolator((Interpolator)new LinearInterpolator());
                ra.setRepeatCount(-1);
                LoadingView.this.mLoadingIv.startAnimation((Animation)ra);
            }
        });
    }

    public void hide() {
        if (this.mLoadingIv != null) {
            this.mRoot.post(new Runnable(){

                @Override
                public void run() {
                    LoadingView.this.mLoadingIv.clearAnimation();
                    LoadingView.this.mLoadingIv.setAlpha(0.0f);
                    LoadingView.this.mRoot.removeView((View)LoadingView.this.mLoadingIv);
                }
            });
        }
    }
}

