/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.BidderTokenProvider;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitManager;
import java.util.Map;

public class FacebookBanner
extends TPBannerAdapter {
    private AdView mFacebookBanner;
    private String mAdSize = "1";
    private String placementId;
    private TPBannerAdImpl mTpBannerAd;
    private String payload;
    private static final String TAG = "FacebookBanner";
    private String mName;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.serverExtrasAreValid(tpParams)) {
            this.placementId = tpParams.get("placementId");
            this.payload = tpParams.get("Bidding-Payload");
            Log.d((String)TAG, (String)("adsize:" + tpParams.get("ad_size" + this.placementId)));
            if (tpParams.containsKey("ad_size" + this.placementId)) {
                this.mAdSize = tpParams.get("ad_size" + this.placementId);
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams.size() > 0 && userParams.containsKey("COPPA")) {
            boolean coppa = (Boolean)userParams.get("COPPA");
            Log.i((String)"privacylaws", (String)("coppa: " + coppa));
            if (coppa) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                return;
            }
        }
        FacebookInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                FacebookBanner.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    private void requestAd(Context context) {
        this.mFacebookBanner = new AdView(context, this.placementId, this.calculateAdSize(this.mAdSize));
        AdListener adListener = new AdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.i((String)FacebookBanner.TAG, (String)("Facebook banner ad load failed  , ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookBanner.this.mLoadAdapterListener != null) {
                    FacebookBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                if (FacebookBanner.this.mFacebookBanner == null) {
                    return;
                }
                Log.i((String)FacebookBanner.TAG, (String)"onAdLoaded: ");
                FacebookBanner.this.mTpBannerAd = new TPBannerAdImpl(null, (View)FacebookBanner.this.mFacebookBanner);
                FacebookBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)FacebookBanner.this.mTpBannerAd);
            }

            public void onAdClicked(Ad ad) {
                Log.i((String)FacebookBanner.TAG, (String)"onAdClicked: ");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.i((String)FacebookBanner.TAG, (String)"onLoggingImpression: ");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adShown();
                }
            }
        };
        this.mFacebookBanner.loadAd(this.mFacebookBanner.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withAdListener(adListener).build());
    }

    public void clean() {
        Log.i((String)TAG, (String)"clean: ");
        if (this.mFacebookBanner != null) {
            Views.removeFromParent((View)this.mFacebookBanner);
            this.mFacebookBanner.destroy();
            this.mFacebookBanner = null;
        }
    }

    public String getNetworkVersion() {
        return "6.20.0";
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "Meta Audience Network" : this.mName;
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    private AdSize calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (adSize.equals("2")) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (adSize.equals("3")) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return AdSize.BANNER_HEIGHT_50;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

