/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdLayout;
import com.facebook.ads.NativeBannerAd;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdView;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPImageLoader;
import java.util.ArrayList;
import java.util.List;

public class FacebookNativeAd
extends TPBaseAd {
    private static final String TAG = "FacebookNative";
    private NativeAd mFacebookNative;
    private TPNativeAdView mNativeAdView;
    private NativeAdLayout mContainer;
    private NativeBannerAd mFacebookNativeBanner;
    private AdOptionsView adOptionsView;
    private View mFacebookView;
    private int isRender;
    private boolean mSingleIcon = false;

    public FacebookNativeAd(View facebookView, int templete) {
        this.mFacebookView = facebookView;
        this.isRender = templete;
    }

    public FacebookNativeAd(Context context, NativeAd facebookNative, boolean singleIcon) {
        this.mFacebookNative = facebookNative;
        this.mSingleIcon = singleIcon;
        this.initNativeAd(context);
    }

    public FacebookNativeAd(Context context, NativeBannerAd facebookNative, boolean singleIcon) {
        this.mFacebookNativeBanner = facebookNative;
        this.mSingleIcon = singleIcon;
        this.initNativeBannerAd(context);
    }

    private void initNativeAd(Context context) {
        String advertiserName;
        double starRating;
        String url;
        NativeAdBase.Image adIcon;
        String adBodyText;
        String adHeadline;
        this.mNativeAdView = new TPNativeAdView();
        this.mContainer = new NativeAdLayout(context);
        MediaView nativeAdMedia = new MediaView(context);
        this.adOptionsView = new AdOptionsView(context, (NativeAdBase)this.mFacebookNative, this.mContainer);
        this.adOptionsView.setSingleIcon(this.mSingleIcon);
        this.mNativeAdView.setAdChoiceView((Object)this.adOptionsView);
        String adCallToAction = this.mFacebookNative.getAdCallToAction();
        if (!TextUtils.isEmpty((CharSequence)adCallToAction)) {
            this.mNativeAdView.setCallToAction(adCallToAction);
        }
        if (!TextUtils.isEmpty((CharSequence)(adHeadline = this.mFacebookNative.getAdHeadline()))) {
            this.mNativeAdView.setTitle(adHeadline);
        }
        if (!TextUtils.isEmpty((CharSequence)(adBodyText = this.mFacebookNative.getAdBodyText()))) {
            this.mNativeAdView.setSubTitle(adBodyText);
        }
        if ((adIcon = this.mFacebookNative.getAdIcon()) != null && !TextUtils.isEmpty((CharSequence)(url = adIcon.getUrl()))) {
            this.mNativeAdView.setIconImageUrl(url);
        }
        float aspectRatio = this.mFacebookNative.getAspectRatio();
        Log.i((String)"aspectRatio", (String)("aspectRatio: " + aspectRatio));
        this.mNativeAdView.setAspectRatio(aspectRatio);
        NativeAdBase.Rating adStarRating = this.mFacebookNative.getAdStarRating();
        Log.i((String)"StarRating", (String)("Meta adStarRating: " + adStarRating));
        if (adStarRating != null && (starRating = adStarRating.getValue()) > 0.0) {
            Log.i((String)"StarRating", (String)("Meta starRating: " + starRating));
            this.mNativeAdView.setStarRating(Double.valueOf(starRating));
        }
        if (!TextUtils.isEmpty((CharSequence)(advertiserName = this.mFacebookNative.getAdvertiserName()))) {
            this.mNativeAdView.setAdvertiserName(advertiserName);
        }
        this.mNativeAdView.setMediaView((View)nativeAdMedia);
    }

    public ArrayList<String> getDownloadImgUrls() {
        this.downloadImgUrls.clear();
        if (!TextUtils.isEmpty((CharSequence)this.mNativeAdView.getIconImageUrl())) {
            this.downloadImgUrls.add(this.mNativeAdView.getIconImageUrl());
        }
        return super.getDownloadImgUrls();
    }

    private void initNativeBannerAd(Context context) {
        String url;
        NativeAdBase.Image adIcon;
        double starRating;
        String advertiserName;
        String adBodyText;
        String adHeadline;
        this.mNativeAdView = new TPNativeAdView();
        this.mContainer = new NativeAdLayout(context);
        this.adOptionsView = new AdOptionsView(context, (NativeAdBase)this.mFacebookNativeBanner, this.mContainer);
        this.adOptionsView.setSingleIcon(this.mSingleIcon);
        this.mNativeAdView.setAdChoiceView((Object)this.adOptionsView);
        String adCallToAction = this.mFacebookNativeBanner.getAdCallToAction();
        if (!TextUtils.isEmpty((CharSequence)adCallToAction)) {
            this.mNativeAdView.setCallToAction(adCallToAction);
        }
        if (!TextUtils.isEmpty((CharSequence)(adHeadline = this.mFacebookNativeBanner.getAdHeadline()))) {
            this.mNativeAdView.setTitle(adHeadline);
        }
        if (!TextUtils.isEmpty((CharSequence)(adBodyText = this.mFacebookNativeBanner.getAdBodyText()))) {
            this.mNativeAdView.setSubTitle(adBodyText);
        }
        if (!TextUtils.isEmpty((CharSequence)(advertiserName = this.mFacebookNativeBanner.getAdvertiserName()))) {
            this.mNativeAdView.setAdvertiserName(advertiserName);
            this.mNativeAdView.setAdSource(advertiserName);
        }
        float aspectRatio = this.mFacebookNativeBanner.getAspectRatio();
        Log.i((String)"aspectRatio", (String)("aspectRatio: " + aspectRatio));
        this.mNativeAdView.setAspectRatio(aspectRatio);
        NativeAdBase.Rating adStarRating = this.mFacebookNativeBanner.getAdStarRating();
        Log.i((String)"StarRating", (String)("Meta adStarRating: " + adStarRating));
        if (adStarRating != null && (starRating = adStarRating.getValue()) > 0.0) {
            Log.i((String)"StarRating", (String)("Meta starRating: " + starRating));
            this.mNativeAdView.setStarRating(Double.valueOf(starRating));
        }
        if ((adIcon = this.mFacebookNativeBanner.getAdIcon()) != null && !TextUtils.isEmpty((CharSequence)(url = adIcon.getUrl()))) {
            this.mNativeAdView.setIconImageUrl(url);
        }
        TPImageLoader.getInstance().loadImage(null, this.mFacebookNativeBanner.getAdIcon().getUrl());
    }

    public void onAdViewClicked() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdClicked();
        }
    }

    public void onAdViewExpanded() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdShown();
        }
    }

    public Object getNetworkObj() {
        if (this.mFacebookView != null) {
            return this.mFacebookView;
        }
        if (this.mFacebookNative != null) {
            return this.mFacebookNative;
        }
        if (this.mFacebookNativeBanner != null) {
            return this.mFacebookNativeBanner;
        }
        return null;
    }

    public void registerClickView(ViewGroup viewGroup, ArrayList<View> clickViews) {
        if (this.mFacebookNativeBanner != null) {
            View iconView = viewGroup.findViewWithTag((Object)"tp_icon");
            FrameLayout adChoicesView = (FrameLayout)viewGroup.findViewWithTag((Object)"tp_adchoices");
            if (adChoicesView != null && this.adOptionsView != null) {
                if (this.adOptionsView.getParent() != null) {
                    ((ViewGroup)this.adOptionsView.getParent()).removeView((View)this.adOptionsView);
                }
                adChoicesView.removeAllViews();
                adChoicesView.addView((View)this.adOptionsView, 0);
            }
            if (iconView instanceof ImageView) {
                this.mFacebookNativeBanner.registerViewForInteraction((View)viewGroup, (ImageView)iconView, clickViews);
            }
            return;
        }
        if (this.mFacebookNative != null) {
            FrameLayout adChoicesView;
            View iconView = viewGroup.findViewWithTag((Object)"tp_icon");
            if (this.mNativeAdView != null && this.mNativeAdView.getMediaView() instanceof MediaView && iconView instanceof ImageView) {
                this.mFacebookNative.registerViewForInteraction((View)viewGroup, (MediaView)this.mNativeAdView.getMediaView(), (ImageView)iconView, clickViews);
            }
            if ((adChoicesView = (FrameLayout)viewGroup.findViewWithTag((Object)"tp_adchoices")) != null && this.adOptionsView != null) {
                if (this.adOptionsView.getParent() != null) {
                    ((ViewGroup)this.adOptionsView.getParent()).removeView((View)this.adOptionsView);
                }
                adChoicesView.removeAllViews();
                adChoicesView.addView((View)this.adOptionsView, 0);
            }
        }
    }

    public TPNativeAdView getTPNativeView() {
        return this.mNativeAdView;
    }

    public int getNativeAdType() {
        Log.i((String)TAG, (String)("isRender: " + this.isRender));
        if (this.isRender == 1) {
            return 1;
        }
        return 0;
    }

    public View getRenderView() {
        if (this.mFacebookView != null) {
            return this.mFacebookView;
        }
        return null;
    }

    public List<View> getMediaViews() {
        return null;
    }

    public ViewGroup getCustomAdContainer() {
        return this.mContainer;
    }

    public void clean() {
        if (this.mFacebookNative != null) {
            this.mFacebookNative.unregisterView();
            this.mFacebookNative.destroy();
            this.mFacebookNative = null;
        }
        if (this.mFacebookNativeBanner != null) {
            this.mFacebookNativeBanner.unregisterView();
            this.mFacebookNativeBanner.destroy();
            this.mFacebookNativeBanner = null;
        }
        this.mNativeAdView = null;
        this.mContainer = null;
    }
}

