/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import java.util.ArrayList;
import java.util.Map;

public class AdManagerBanner
extends TPBannerAdapter {
    private AdManagerAdView adView;
    private String placementId;
    private String mAdSize;
    private AdManagerAdRequest request;
    private TPBannerAdImpl tpBannerAd;
    private String name;
    private String mContentUrls;
    private ArrayList<String> mNeighboringUrls;
    private static final String TAG = "GAMBanner";

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        Object contentUrl;
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.mAdSize = tpParams.get("ad_size" + this.placementId);
        this.name = tpParams.get("name");
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("google_neighboring_contenturls") && (contentUrl = userParams.get("google_neighboring_contenturls")) instanceof ArrayList) {
            ArrayList url = (ArrayList)contentUrl;
            int size = url.size();
            Log.i((String)TAG, (String)("contentUrl size : " + size));
            try {
                if (size == 1) {
                    this.mContentUrls = (String)url.get(0);
                }
                if (size >= 2) {
                    this.mNeighboringUrls = new ArrayList();
                    this.mNeighboringUrls.addAll(url);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.request = AdManagerInit.getInstance().getAdmobAdRequest(userParams, this.mContentUrls, this.mNeighboringUrls);
        AdManagerInit.getInstance().initSDK(context, (AdRequest)this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AdManagerBanner.this.requestBanner(context);
            }

            public void onFailed(String code, String msg) {
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestBanner(Context context) {
        this.adView = new AdManagerAdView(context);
        this.adView.setAdSizes(new AdSize[]{this.calculateAdSize(context, this.mAdSize)});
        this.adView.setAdUnitId(this.placementId);
        this.adView.setAdListener(new AdListener(){

            public void onAdClosed() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdClosed: ");
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.i((String)AdManagerBanner.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage(loadAdError.getMessage());
                tpError.setErrorCode(loadAdError.getCode() + "");
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAdOpened() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdOpened: ");
            }

            public void onAdLoaded() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdLoaded: ");
                if (AdManagerBanner.this.tpBannerAd == null) {
                    AdManagerBanner.this.tpBannerAd = new TPBannerAdImpl(null, (View)AdManagerBanner.this.adView);
                }
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)AdManagerBanner.this.tpBannerAd);
                }
            }

            public void onAdClicked() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdClicked: ");
                if (AdManagerBanner.this.tpBannerAd != null) {
                    AdManagerBanner.this.tpBannerAd.adClicked();
                }
            }

            public void onAdImpression() {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Log.i((String)AdManagerBanner.TAG, (String)"onAdImpression: ");
                        if (AdManagerBanner.this.tpBannerAd != null) {
                            AdManagerBanner.this.tpBannerAd.adShown();
                        }
                    }
                }, 1000L);
            }
        });
        this.adView.loadAd(this.request);
    }

    public void clean() {
        if (this.adView != null) {
            this.adView.setAdListener(null);
            this.adView.destroy();
            this.adView = null;
        }
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    private AdSize calculateAdSize(Context context, String adSize) {
        Log.i((String)TAG, (String)("BannerSize: " + this.mAdSize));
        if ("2".equals(adSize)) {
            return AdSize.LARGE_BANNER;
        }
        if ("3".equals(adSize)) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if ("4".equals(adSize)) {
            return AdSize.FULL_BANNER;
        }
        if ("5".equals(adSize)) {
            return AdSize.LEADERBOARD;
        }
        if ("6".equals(adSize)) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            float widthPixels = displayMetrics.widthPixels;
            float density = displayMetrics.density;
            int adWidth = (int)(widthPixels / density);
            return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)adWidth);
        }
        return AdSize.BANNER;
    }
}

