/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import java.util.Map;

public class AdManagerSplash
extends TPSplashAdapter {
    public static final String TAG = "GAMSplash";
    private String placementId;
    private AdManagerAdRequest request;
    private AppOpenAd mAppOpenAd;
    private Integer mVideoMute = 0;
    private String name;
    private boolean immersive_mode = false;
    private final AppOpenAd.AppOpenAdLoadCallback mAppOpenAdLoadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdLoaded(AppOpenAd ad) {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdLoaded: ");
            AdManagerSplash.this.mAppOpenAd = ad;
            if (AdManagerSplash.this.mLoadAdapterListener != null) {
                AdManagerSplash.this.setNetworkObjectAd(ad);
                AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)AdManagerSplash.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
            AdManagerSplash.this.mAppOpenAd = null;
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(loadAdError.getMessage());
            tpError.setErrorCode(loadAdError.getCode() + "");
            if (AdManagerSplash.this.mLoadAdapterListener != null) {
                AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    };
    private final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdDismissedFullScreenContent() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdDismissedFullScreenContent");
            AdManagerSplash.this.mAppOpenAd = null;
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdClosed();
            }
        }

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)AdManagerSplash.TAG, (String)("onAdFailedToShowFullScreenContent: code:" + adError.getCode() + ", msg:" + adError.getMessage()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(adError.getMessage());
            tpError.setErrorCode(adError.getCode() + "");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdVideoError(tpError);
            }
        }

        public void onAdShowedFullScreenContent() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdShowedFullScreenContent");
        }

        public void onAdImpression() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdImpression: ");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdShown();
            }
        }

        public void onAdClicked() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdClicked: ");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdClicked();
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.name = tpParams.get("name");
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("video_admob_mute")) {
                this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
            }
            if (userParams.containsKey("immersive_mode")) {
                int immersive_mode;
                Object object = userParams.get("immersive_mode");
                if (object instanceof Integer && (immersive_mode = ((Integer)object).intValue()) == 1) {
                    this.immersive_mode = true;
                }
                Log.i((String)TAG, (String)("loadCustomAd immersive_mode: " + this.immersive_mode));
            }
        }
        this.request = AdManagerInit.getInstance().getAdmobAdRequest(userParams, tpParams, null, null);
        AdManagerInit.getInstance().initSDK(context, (AdRequest)this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (AdManagerSplash.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((AdManagerSplash.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                AdManagerSplash.this.requestSplash(context);
            }

            public void onFailed(String code, String msg) {
                if (AdManagerSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestSplash(Context context) {
        AppOpenAd.load((Context)context, (String)this.placementId, (AdRequest)this.request, (AppOpenAd.AppOpenAdLoadCallback)this.mAppOpenAdLoadCallback);
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAppOpenAd == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
            }
            return;
        }
        if (this.immersive_mode) {
            this.mAppOpenAd.setImmersiveMode(true);
        }
        this.mAppOpenAd.setFullScreenContentCallback(this.fullScreenContentCallback);
        this.mAppOpenAd.show(activity);
    }

    public void clean() {
        if (this.mAppOpenAd != null) {
            this.mAppOpenAd.setFullScreenContentCallback(null);
            this.mAppOpenAd = null;
        }
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }
}

