/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GoogleInitManager
extends TPInitMediation {
    private static final String TAG = "GoogleInitManager";
    private static GoogleInitManager sInstance;
    private String name;
    private String mContentUrls;
    private ArrayList<String> mNeighboringUrls;

    public static synchronized GoogleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new GoogleInitManager();
        }
        return sInstance;
    }

    public void initSDK(final Context context, AdRequest request, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        final String customAs = RequestUtils.getInstance().getCustomAs("2");
        this.removeInited(customAs);
        if (GoogleInitManager.isInited((String)customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        this.suportGDPR(context, userParams);
        this.setTestDevice(request, context);
        String isInitNoCallBack = "1";
        if (tpParams != null && tpParams.size() > 0) {
            if (tpParams.containsKey("init_no_callback")) {
                isInitNoCallBack = tpParams.get("init_no_callback");
            }
            this.name = tpParams.get("name");
        }
        Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
        Log.i((String)TAG, (String)("isInitNoCallBack: " + isInitNoCallBack));
        if ("0".equals(isInitNoCallBack)) {
            TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                @Override
                public void run() {
                    MobileAds.disableMediationAdapterInitialization((Context)context);
                    MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                        public void onInitializationComplete(InitializationStatus initializationStatus) {
                            AdapterStatus.State state;
                            AdapterStatus status = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                            AdapterStatus.State state2 = state = status != null ? status.getInitializationState() : null;
                            if (state == AdapterStatus.State.READY) {
                                Log.i((String)GoogleInitManager.TAG, (String)"onInitializationComplete: ");
                                GoogleInitManager.this.sendResult(customAs, true);
                            } else {
                                GoogleInitManager.this.sendResult(customAs, false, "", "NOT READY");
                            }
                        }
                    });
                }
            });
        } else {
            TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                @Override
                public void run() {
                    MobileAds.disableMediationAdapterInitialization((Context)context);
                    MobileAds.initialize((Context)context);
                }
            });
            this.sendResult(customAs, true);
        }
    }

    public void setTestDevice(AdRequest request, Context context) {
        if (TestDeviceUtil.getInstance().isNeedTestDevice()) {
            String admobTestDevice = TestDeviceUtil.getInstance().getAdmobTestDevice();
            if (!TextUtils.isEmpty((CharSequence)admobTestDevice)) {
                List<String> testDeviceIds = Arrays.asList(admobTestDevice);
                RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
                MobileAds.setRequestConfiguration((RequestConfiguration)configuration);
            }
            boolean testDevice = request.isTestDevice(context);
            Log.i((String)TAG, (String)("isTestDevice  : " + testDevice));
        }
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        this.initSDK(context, this.getAdmobAdRequest(userParams, tpParams, false), userParams, tpParams, initCallback);
    }

    public AdRequest getAdmobAdRequest(Map<String, Object> userParams, Map<String, String> tpParams, boolean isBiddingAd) {
        Bundle networkExtrasBundle = new Bundle();
        boolean openPersonalizedAd = GlobalTradPlus.getInstance().isOpenPersonalizedAd();
        if (!openPersonalizedAd) {
            networkExtrasBundle.putString("npa", "1");
        }
        Log.i((String)"PersonalizeEnable", (String)("GoogleInitManager openPersonalizedAd \u4e2a\u6027\u5316\u5f00\u5173: " + openPersonalizedAd));
        int mAdViewWidth = 0;
        int mAdViewHeight = 0;
        if (userParams != null && userParams.size() > 0) {
            Object object;
            Boolean userConsent;
            if (userParams.containsKey("CCPA")) {
                boolean ccpa = (Boolean)userParams.get("CCPA");
                Log.i((String)"privacylaws", (String)("ccpa: " + ccpa));
                if (ccpa) {
                    networkExtrasBundle.putInt("rdp", 1);
                }
            }
            if (this.checkGoogleUMP(userParams) && (userConsent = this.updateUserConsent(userParams)) != null && !userConsent.booleanValue()) {
                networkExtrasBundle.putString("npa", "1");
            }
            if (userParams.containsKey("width") && (object = userParams.get("width")) instanceof Integer) {
                mAdViewWidth = (Integer)object;
            }
            if (userParams.containsKey("height") && (object = userParams.get("height")) instanceof Integer) {
                mAdViewHeight = (Integer)object;
            }
        }
        AdRequest.Builder builder = new AdRequest.Builder();
        if (!TextUtils.isEmpty((CharSequence)this.mContentUrls)) {
            builder.setContentUrl(this.mContentUrls);
            Log.i((String)TAG, (String)("contentUrls: " + this.mContentUrls));
        } else if (this.mNeighboringUrls != null) {
            builder.setNeighboringContentUrls(this.mNeighboringUrls);
            Log.i((String)TAG, (String)("neighboringUrls: " + this.mNeighboringUrls));
        }
        String mdn = "tradplus";
        String mediationEventId = "";
        String collapsible = "";
        AdSize adaptiveAdSize = AdSize.BANNER;
        String payload = "";
        int isHybridSetup = 0;
        if (tpParams != null && tpParams.size() > 0) {
            Context context;
            if (tpParams.containsKey("mdn")) {
                mdn = tpParams.get("mdn");
            }
            if (tpParams.containsKey("tp_bidid")) {
                mediationEventId = tpParams.get("tp_bidid");
                Log.i((String)TAG, (String)("mediationEventId: " + mediationEventId));
            }
            if (tpParams.containsKey("collapsible")) {
                collapsible = tpParams.get("collapsible");
                Log.i((String)TAG, (String)("collapsible: " + collapsible));
            }
            if ((context = GlobalTradPlus.getInstance().getContext()) != null && tpParams.containsKey("ad_size")) {
                String adSize = tpParams.get("ad_size");
                adaptiveAdSize = this.calculateAdSize(adSize, context, mAdViewWidth, mAdViewHeight);
            }
            if (tpParams.containsKey("Bidding-Payload") && !TextUtils.isEmpty((CharSequence)(payload = tpParams.get("Bidding-Payload")))) {
                isBiddingAd = true;
            }
            if (tpParams.containsKey("is_hybrid_setup")) {
                isHybridSetup = Integer.parseInt(tpParams.get("is_hybrid_setup"));
            }
        }
        Log.i((String)TAG, (String)("isBiddingAd :" + isBiddingAd + ", isHybridSetup :" + isHybridSetup));
        if (isBiddingAd) {
            networkExtrasBundle.putString("query_info_type", "requester_type_2");
            if (adaptiveAdSize != null) {
                networkExtrasBundle.putInt("adaptive_banner_w", adaptiveAdSize.getWidth());
                networkExtrasBundle.putInt("adaptive_banner_h", adaptiveAdSize.getHeight());
            }
            if (!TextUtils.isEmpty((CharSequence)payload)) {
                builder.setAdString(payload);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)mediationEventId)) {
            networkExtrasBundle.putString("placement_req_id", mediationEventId);
        }
        networkExtrasBundle.putBoolean("is_hybrid_setup", isHybridSetup == 1);
        networkExtrasBundle.putString("platform_name", mdn);
        Log.i((String)TAG, (String)("mdn: " + mdn));
        builder.setRequestAgent(mdn);
        if (!TextUtils.isEmpty((CharSequence)collapsible) && !"0".equals(collapsible)) {
            networkExtrasBundle.putString("collapsible", "1".equals(collapsible) ? "top" : "bottom");
        }
        return ((AdRequest.Builder)builder.addNetworkExtrasBundle(AdMobAdapter.class, networkExtrasBundle)).build();
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0) {
            RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration();
            RequestConfiguration.Builder builder = requestConfiguration.toBuilder();
            if (userParams.containsKey("COPPA")) {
                boolean coppa = (Boolean)userParams.get("COPPA");
                Log.i((String)"privacylaws", (String)("coppa: " + coppa));
                builder.setTagForChildDirectedTreatment(coppa ? 1 : 0);
            }
            if (userParams.containsKey("isue")) {
                if (userParams.containsKey("gdpr_child")) {
                    boolean gdprchild = (Boolean)userParams.get("gdpr_child");
                    Log.i((String)"privacylaws", (String)("gdprchild: " + gdprchild));
                    builder.setTagForUnderAgeOfConsent(gdprchild ? 1 : 0);
                } else {
                    builder.setTagForUnderAgeOfConsent(-1);
                }
            }
            if (userParams.containsKey("max_ad_content_rating")) {
                String maxAdContentRating = (String)userParams.get("max_ad_content_rating");
                Log.i((String)"privacylaws", (String)("maxAdContentRating: " + maxAdContentRating));
                if (!TextUtils.isEmpty((CharSequence)maxAdContentRating)) {
                    builder.setMaxAdContentRating(maxAdContentRating);
                }
            }
            builder.build();
            MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
        }
    }

    private boolean checkGoogleUMP(Map<String, Object> localExtras) {
        if (localExtras.containsKey("IABTCF_TCString")) {
            String consentString = (String)localExtras.get("IABTCF_TCString");
            Log.i((String)"privacylaws", (String)("Admob TCString: " + consentString));
            return TextUtils.isEmpty((CharSequence)consentString);
        }
        return true;
    }

    public String getNetworkVersionCode() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    public String getNetworkVersionName() {
        return this.name;
    }

    public AdSize calculateAdSize(String adSize, Context context, int adViewWidth, int adViewHeight) {
        if ("2".equals(adSize)) {
            return AdSize.LARGE_BANNER;
        }
        if ("3".equals(adSize)) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if ("4".equals(adSize)) {
            return AdSize.FULL_BANNER;
        }
        if ("5".equals(adSize)) {
            return AdSize.LEADERBOARD;
        }
        if ("6".equals(adSize)) {
            AdSize bannerAdSize;
            if (adViewWidth > 0 && adViewHeight > 0) {
                bannerAdSize = AdSize.getInlineAdaptiveBannerAdSize((int)adViewWidth, (int)adViewHeight);
            } else {
                DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
                float widthPixels = displayMetrics.widthPixels;
                float density = displayMetrics.density;
                int adWidth = (int)(widthPixels / density);
                bannerAdSize = AdSize.getCurrentOrientationInlineAdaptiveBannerAdSize((Context)context, (int)adWidth);
            }
            return bannerAdSize;
        }
        return AdSize.BANNER;
    }

    public void setLocalContentParmas(Map<String, Object> userParams) {
        Object contentUrl;
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("google_neighboring_contenturls") && (contentUrl = userParams.get("google_neighboring_contenturls")) instanceof ArrayList) {
            ArrayList url = (ArrayList)contentUrl;
            int size = url.size();
            Log.i((String)TAG, (String)("contentUrl size : " + size));
            try {
                if (size == 1) {
                    this.mContentUrls = (String)url.get(0);
                }
                if (size >= 2) {
                    this.mNeighboringUrls = new ArrayList();
                    this.mNeighboringUrls.addAll(url);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

