/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import java.util.HashMap;
import java.util.Map;

public class GooglePlayServicesInterstitial
extends TPInterstitialAdapter {
    private InterstitialAd mInterstitialAd;
    private AdRequest request;
    private String adUnitId;
    private Integer mVideoMute = 0;
    private String name;
    private boolean isBiddingAdToShow = false;
    private static final String TAG = "AdmobInterstitial";
    private boolean immersive_mode = false;
    private final InterstitialAdLoadCallback mInterstitialAdLoadCallback = new InterstitialAdLoadCallback(){

        public void onAdLoaded(InterstitialAd interstitialAd) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdLoaded: ");
            GooglePlayServicesInterstitial.this.setFirstLoadedTime();
            GooglePlayServicesInterstitial.this.mInterstitialAd = interstitialAd;
            GooglePlayServicesInterstitial.this.mInterstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(AdValue adValue) {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onPaidEvent: ");
                    long valueMicros = adValue.getValueMicros();
                    String currencyCode = adValue.getCurrencyCode();
                    int precision = adValue.getPrecisionType();
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.impPaidMap = new HashMap();
                        Long value = new Long(valueMicros);
                        double dvalue = value.doubleValue();
                        GooglePlayServicesInterstitial.this.impPaidMap.put("paid_valueMicros", dvalue / 1000.0 / 1000.0);
                        GooglePlayServicesInterstitial.this.impPaidMap.put("paid_currencycode", currencyCode);
                        GooglePlayServicesInterstitial.this.impPaidMap.put("paid_precision", precision);
                        GooglePlayServicesInterstitial.this.mShowListener.onAdImpPaid(GooglePlayServicesInterstitial.this.impPaidMap);
                    }
                }
            });
            if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.setNetworkObjectAd(interstitialAd);
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitial.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdDismissedFullScreenContent.");
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdClosed();
                    }
                }

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToShowFullScreenContent: code :" + adError.getCode() + ", msg :" + adError.getMessage()));
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                        tpError.setErrorCode(adError.getCode() + "");
                        tpError.setErrorMessage(adError.getMessage());
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoError(tpError);
                    }
                }

                public void onAdShowedFullScreenContent() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdShowedFullScreenContent: ");
                }

                public void onAdImpression() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdImpression: ");
                    GooglePlayServicesInterstitial.this.mInterstitialAd = null;
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.isBiddingAdToShow = true;
                        GooglePlayServicesInterstitial.this.mShowListener.onAdShown();
                    }
                }

                public void onAdClicked() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdClicked: ");
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoClicked();
                    }
                }
            });
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg :" + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitial.this.mInterstitialAd = null;
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (!this.extrasAreValid(tpParams)) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            }
            return;
        }
        this.adUnitId = tpParams.get("placementId");
        this.name = tpParams.get("name");
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("video_admob_mute")) {
                this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
            }
            if (userParams.containsKey("immersive_mode")) {
                int immersive_mode;
                Object object = userParams.get("immersive_mode");
                if (object instanceof Integer && (immersive_mode = ((Integer)object).intValue()) == 1) {
                    this.immersive_mode = true;
                }
                Log.i((String)TAG, (String)("loadCustomAd immersive_mode: " + this.immersive_mode));
            }
        }
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams, tpParams, false);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (GooglePlayServicesInterstitial.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((GooglePlayServicesInterstitial.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                GooglePlayServicesInterstitial.this.requestInterstitial(context);
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitial(Context context) {
        block2: {
            try {
                InterstitialAd.load((Context)context, (String)this.adUnitId, (AdRequest)this.request, (InterstitialAdLoadCallback)this.mInterstitialAdLoadCallback);
            }
            catch (Throwable e) {
                Log.i((String)TAG, (String)("Throwable: " + e.getLocalizedMessage()));
                if (this.mLoadAdapterListener == null) break block2;
                TPError tpError = new TPError("Unspecified error.");
                tpError.setErrorMessage(e.getLocalizedMessage());
                this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    }

    public void showAd() {
        if (this.mInterstitialAd != null) {
            Activity activity = GlobalTradPlus.getInstance().getActivity();
            if (activity == null) {
                if (this.mShowListener != null) {
                    this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
                }
                return;
            }
            if (this.immersive_mode) {
                this.mInterstitialAd.setImmersiveMode(true);
            }
            this.mInterstitialAd.show(activity);
        } else if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            Log.i((String)TAG, (String)"Tried to show a Google Play Services interstitial ad before it finished loading. Please try again.");
        }
    }

    public boolean isReady() {
        boolean isMainThread;
        if (this.mInterstitialAd == null) {
            return false;
        }
        boolean bl = isMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isMainThread) {
            return !this.isAdsTimeOut();
        }
        return !this.isAdsTimeOut();
    }

    public void clean() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.setFullScreenContentCallback(null);
            this.mInterstitialAd = null;
        }
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        GoogleInitManager.getInstance().setInitState("2");
        int isHybridSetup = 0;
        if (tpParams != null && tpParams.size() > 0 && tpParams.containsKey("is_hybrid_setup")) {
            isHybridSetup = Integer.parseInt(tpParams.get("is_hybrid_setup"));
        }
        final int finalIsHybridSetup = isHybridSetup;
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(localParams, tpParams, true);
        QueryInfo.generate((Context)context, (AdFormat)AdFormat.INTERSTITIAL, (AdRequest)this.request, (QueryInfoGenerationCallback)new QueryInfoGenerationCallback(){

            public void onFailure(String s) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(null, null);
                }
            }

            public void onSuccess(QueryInfo queryInfo) {
                if (queryInfo != null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("is_hybrid_setup", finalIsHybridSetup);
                    String query = queryInfo.getQuery();
                    if (onS2STokenListener != null) {
                        onS2STokenListener.onTokenResult(query, hashMap);
                    }
                }
            }
        });
    }

    public boolean getReadyToImpression() {
        return this.isBiddingAdToShow;
    }
}

