/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.AppKeyManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class GooglePlayServicesInterstitial
extends TPInterstitialAdapter {
    private InterstitialAd mInterstitialAd;
    private WeakReference<Context> contextWeakReference;
    private AdRequest request;
    private String adUnitId;
    private static final String TAG = "AdmobInterstitial";
    private final InterstitialAdLoadCallback mInterstitialAdLoadCallback = new InterstitialAdLoadCallback(){

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdLoaded: ");
            GooglePlayServicesInterstitial.this.setFirstLoadedTime();
            GooglePlayServicesInterstitial.this.mInterstitialAd = interstitialAd;
            if (GooglePlayServicesInterstitial.this.contextWeakReference.get() != null && GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitial.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    Log.d((String)GooglePlayServicesInterstitial.TAG, (String)"The ad was dismissed.");
                    if (GooglePlayServicesInterstitial.this.contextWeakReference.get() != null && GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoEnd();
                    }
                }

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                    Log.d((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToShowFullScreenContent: code :" + adError.getCode() + ", msg :" + adError.getMessage()));
                    if (GooglePlayServicesInterstitial.this.contextWeakReference.get() != null && GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoError(TradPlusErrorCode.SHOW_FAILED);
                    }
                }

                public void onAdShowedFullScreenContent() {
                    GooglePlayServicesInterstitial.this.mInterstitialAd = null;
                    Log.d((String)GooglePlayServicesInterstitial.TAG, (String)"The ad was shown.");
                    if (GooglePlayServicesInterstitial.this.contextWeakReference.get() != null && GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoStart();
                    }
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg :" + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitial.this.contextWeakReference.get() != null && GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(TradPlusErrorCode.NETWORK_NO_FILL, loadAdError));
                GooglePlayServicesInterstitial.this.mInterstitialAd = null;
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        this.contextWeakReference = new WeakReference<Context>(context);
        if (!this.extrasAreValid(tpParams)) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            }
            return;
        }
        this.adUnitId = tpParams.get("placementId");
        this.request = new AdRequest.Builder().build();
        if (!AppKeyManager.getInstance().isInited(this.getNetworkName(), AppKeyManager.AdType.SHARE)) {
            GoogleInitManager.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    GooglePlayServicesInterstitial.this.requestInterstitial();
                }

                public void onFailed(String code, String msg) {
                    if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                        TradPlusErrorCode tradPlusErrorCode = TradPlusErrorCode.INIT_FAILED;
                        tradPlusErrorCode.setErrormessage(msg);
                        GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tradPlusErrorCode);
                    }
                }
            });
        } else {
            this.requestInterstitial();
        }
    }

    private void requestInterstitial() {
        block2: {
            try {
                InterstitialAd.load((Context)((Context)this.contextWeakReference.get()), (String)this.adUnitId, (AdRequest)this.request, (InterstitialAdLoadCallback)this.mInterstitialAdLoadCallback);
            }
            catch (NoClassDefFoundError e) {
                if (this.mLoadAdapterListener == null) break block2;
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NETWORK_NO_FILL);
            }
        }
    }

    public void showAd() {
        if (this.mInterstitialAd != null) {
            Activity activity = GlobalTradPlus.getInstance().getActivity();
            this.mInterstitialAd.show(activity);
        } else if (this.contextWeakReference.get() != null && this.mShowListener != null) {
            this.mShowListener.onAdVideoError(TradPlusErrorCode.SHOW_FAILED);
            Log.i((String)TAG, (String)"Tried to show a Google Play Services interstitial ad before it finished loading. Please try again.");
        }
    }

    public boolean isReady() {
        boolean isMainThread;
        if (this.mInterstitialAd == null) {
            return false;
        }
        boolean bl = isMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isMainThread) {
            return !this.isAdsTimeOut();
        }
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }
}

