/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdManagerBanner
extends TPBannerAdapter {
    private AdManagerAdView adView;
    private Context mCxt;
    private String placementId;
    private String mAdSize;
    private AdRequest request;
    private TPBannerAdImpl tpBannerAd;
    private static final String TAG = "AdManagerBanner";

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.mAdSize = tpParams.get("ad_size" + this.placementId);
        this.request = new AdRequest.Builder().build();
        AdManagerInit.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AdManagerBanner.this.requestBanner();
            }

            public void onFailed(String code, String msg) {
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestBanner() {
        this.adView = new AdManagerAdView(this.mCxt);
        this.adView.setAdSizes(new AdSize[]{this.calculateAdSize(this.mAdSize)});
        this.adView.setAdUnitId(this.placementId);
        this.adView.setAdListener(new AdListener(){

            public void onAdClosed() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdClosed: ");
                if (AdManagerBanner.this.tpBannerAd != null) {
                    AdManagerBanner.this.tpBannerAd.adClosed();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.i((String)AdManagerBanner.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage(loadAdError.getMessage());
                tpError.setErrorCode(loadAdError.getCode() + "");
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAdOpened() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdOpened: ");
            }

            public void onAdLoaded() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdLoaded: ");
                AdManagerBanner.this.tpBannerAd = new TPBannerAdImpl(null, (View)AdManagerBanner.this.adView);
                if (AdManagerBanner.this.mLoadAdapterListener != null) {
                    AdManagerBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)AdManagerBanner.this.tpBannerAd);
                }
            }

            public void onAdClicked() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdClicked: ");
                if (AdManagerBanner.this.tpBannerAd != null) {
                    AdManagerBanner.this.tpBannerAd.adClicked();
                }
            }

            public void onAdImpression() {
                Log.i((String)AdManagerBanner.TAG, (String)"onAdImpression: ");
                if (AdManagerBanner.this.tpBannerAd != null) {
                    AdManagerBanner.this.tpBannerAd.adShown();
                }
            }
        });
        AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
        this.adView.loadAd(adRequest);
    }

    public void clean() {
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }

    private AdSize calculateAdSize(String adSize) {
        Log.i((String)TAG, (String)("BannerSize: " + this.mAdSize));
        if (adSize.equals("2")) {
            return AdSize.LARGE_BANNER;
        }
        if (adSize.equals("3")) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if (adSize.equals("4")) {
            return AdSize.FULL_BANNER;
        }
        if (adSize.equals("5")) {
            return AdSize.LEADERBOARD;
        }
        if (adSize.endsWith("6")) {
            DisplayMetrics displayMetrics = this.mCxt.getResources().getDisplayMetrics();
            float widthPixels = displayMetrics.widthPixels;
            float density = displayMetrics.density;
            int adWidth = (int)(widthPixels / density);
            return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)this.mCxt, (int)adWidth);
        }
        return AdSize.BANNER;
    }
}

