/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdManagerInterstitialVideo
extends TPRewardAdapter {
    private Context mCxt;
    private String placementId;
    private String customData;
    private String userid;
    private AdRequest request;
    private RewardedAd mRewardedAd;
    private RewardedInterstitialAd mRewardedInterstitialAd;
    private int isRewardedInterstitialAd;
    private static final String TAG = "AdManagerReward";
    private final RewardedInterstitialAdLoadCallback mRewardedInterstitialAdLoadCallback = new RewardedInterstitialAdLoadCallback(){

        public void onAdLoaded(RewardedInterstitialAd ad) {
            AdManagerInterstitialVideo.this.mRewardedInterstitialAd = ad;
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)"onAdLoaded: ");
            AdManagerInterstitialVideo.this.setFirstLoadedTime();
            if (AdManagerInterstitialVideo.this.mLoadAdapterListener != null) {
                AdManagerInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            AdManagerInterstitialVideo.this.mRewardedInterstitialAd.setFullScreenContentCallback(AdManagerInterstitialVideo.this.mFullScreenContentCallback);
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(loadAdError.getMessage());
            tpError.setErrorCode(loadAdError.getCode() + "");
            if (AdManagerInterstitialVideo.this.mLoadAdapterListener != null) {
                AdManagerInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    };
    private final RewardedAdLoadCallback mRewardedAdLoadCallback = new RewardedAdLoadCallback(){

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            AdManagerInterstitialVideo.this.mRewardedAd = null;
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(loadAdError.getMessage());
            tpError.setErrorCode(loadAdError.getCode() + "");
            if (AdManagerInterstitialVideo.this.mLoadAdapterListener != null) {
                AdManagerInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)"onAdLoaded: ");
            AdManagerInterstitialVideo.this.mRewardedAd = rewardedAd;
            AdManagerInterstitialVideo.this.setFirstLoadedTime();
            if (AdManagerInterstitialVideo.this.mLoadAdapterListener != null) {
                AdManagerInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            AdManagerInterstitialVideo.this.mRewardedAd.setFullScreenContentCallback(AdManagerInterstitialVideo.this.mFullScreenContentCallback);
        }
    };
    private final OnUserEarnedRewardListener mOnUserEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)"onUserEarnedReward: ");
            if (AdManagerInterstitialVideo.this.mShowListener != null) {
                AdManagerInterstitialVideo.this.mShowListener.onReward();
            }
        }
    };
    private final FullScreenContentCallback mFullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)("onAdFailedToShowFullScreenContent: code:" + adError.getCode() + ", msg:" + adError.getMessage()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(adError.getMessage());
            tpError.setErrorCode(adError.getCode() + "");
            if (AdManagerInterstitialVideo.this.mShowListener != null) {
                AdManagerInterstitialVideo.this.mShowListener.onAdVideoError(tpError);
            }
        }

        public void onAdShowedFullScreenContent() {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)"onAdShowedFullScreenContent");
            if (AdManagerInterstitialVideo.this.mShowListener != null) {
                AdManagerInterstitialVideo.this.mShowListener.onAdVideoStart();
            }
        }

        public void onAdDismissedFullScreenContent() {
            Log.i((String)AdManagerInterstitialVideo.TAG, (String)"onAdDismissedFullScreenContent");
            AdManagerInterstitialVideo.this.mRewardedInterstitialAd = null;
            if (AdManagerInterstitialVideo.this.mShowListener != null) {
                AdManagerInterstitialVideo.this.mShowListener.onAdVideoEnd();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.isRewardedInterstitialAd = Integer.parseInt(tpParams.get("adsource_type"));
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("custom_data")) {
                this.customData = (String)userParams.get("custom_data");
                if (TextUtils.isEmpty((CharSequence)this.customData)) {
                    this.customData = "";
                }
            }
            if (userParams.containsKey("user_id")) {
                this.userid = (String)userParams.get("user_id");
                if (TextUtils.isEmpty((CharSequence)this.userid)) {
                    this.userid = "";
                }
            }
        }
        this.request = new AdRequest.Builder().build();
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AdManagerInterstitialVideo.this.requestInterstitialVideo();
            }

            public void onFailed(String code, String msg) {
                if (AdManagerInterstitialVideo.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitialVideo() {
        AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
        if (this.isRewardedInterstitialAd == 2) {
            Log.i((String)TAG, (String)"load RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
            RewardedInterstitialAd.load((Context)this.mCxt, (String)this.placementId, (AdManagerAdRequest)adRequest, (RewardedInterstitialAdLoadCallback)this.mRewardedInterstitialAdLoadCallback);
        } else {
            Log.i((String)TAG, (String)"load RewardedAd: \u6fc0\u52b1\u89c6\u9891");
            RewardedAd.load((Context)this.mCxt, (String)this.placementId, (AdManagerAdRequest)adRequest, (RewardedAdLoadCallback)this.mRewardedAdLoadCallback);
        }
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.isRewardedInterstitialAd == 2) {
            Log.i((String)TAG, (String)"load RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
            if (this.mRewardedInterstitialAd == null) {
                if (this.mShowListener != null) {
                    this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
                }
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData) && !TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(this.customData).setUserId(this.userid).build();
                this.mRewardedInterstitialAd.setServerSideVerificationOptions(options);
            }
            this.mRewardedInterstitialAd.show(activity, this.mOnUserEarnedRewardListener);
        } else {
            Log.i((String)TAG, (String)"load RewardedAd: \u6fc0\u52b1\u89c6\u9891");
            if (this.mRewardedAd == null) {
                if (this.mShowListener != null) {
                    this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
                }
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData) && !TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(this.customData).setUserId(this.userid).build();
                this.mRewardedAd.setServerSideVerificationOptions(options);
            }
            this.mRewardedAd.show(activity, this.mOnUserEarnedRewardListener);
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }
}

