/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class googlePlaySplashAd
extends TPSplashAdapter {
    private static final long EXPIRED_TIME = 4L;
    private long loadTime = 0L;
    public static final String TAG = "AdmobSplash";
    private AppOpenAd mAppOpenAd;
    private Context mCxt;
    private String mAdUnitId;
    private AdRequest request;
    private int mOrientation = 1;
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdLoaded(AppOpenAd appOpenAd) {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAppOpenAdLoaded: ");
            if (appOpenAd != null) {
                googlePlaySplashAd.this.loadTime = System.currentTimeMillis();
                googlePlaySplashAd.this.mAppOpenAd = appOpenAd;
                if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                    googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)googlePlaySplashAd.TAG, (String)("onAppOpenAdFailedToLoad message: " + loadAdError.getMessage() + ":code:" + loadAdError.getCode()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorCode(String.valueOf(loadAdError.getCode()));
            tpError.setErrorMessage(loadAdError.getMessage());
            if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    };
    final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdDismissedFullScreenContent() {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAdDismissedFullScreenContent: ");
            if (googlePlaySplashAd.this.mShowListener != null) {
                googlePlaySplashAd.this.mShowListener.onAdClosed();
            }
        }

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)googlePlaySplashAd.TAG, (String)("onAdFailedToShowFullScreenContent msg : " + adError.getMessage() + ":code:" + adError.getCode()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorCode(String.valueOf(adError.getCode()));
            tpError.setErrorMessage(adError.getMessage());
            if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }

        public void onAdShowedFullScreenContent() {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAdShowedFullScreenContent: ");
            if (googlePlaySplashAd.this.mShowListener != null) {
                googlePlaySplashAd.this.mShowListener.onAdShown();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        this.mCxt = context;
        if (tpParams != null && tpParams.size() > 0) {
            this.mAdUnitId = tpParams.get("placementId");
        }
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("Admob_Direction")) {
            this.mOrientation = (Integer)userParams.get("Admob_Direction");
        }
        this.request = new AdRequest.Builder().build();
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                googlePlaySplashAd.this.requestSplash();
            }

            public void onFailed(String code, String msg) {
                if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestSplash() {
        if (this.mOrientation == 2) {
            this.mOrientation = 2;
        }
        Log.i((String)TAG, (String)("Orientation: " + this.mOrientation + ", 1:\u7ad6\u5c4f\uff1b2:\u6a2a\u5c4f"));
        AppOpenAd.load((Context)this.mCxt, (String)this.mAdUnitId, (AdRequest)this.request, (int)this.mOrientation, (AppOpenAd.AppOpenAdLoadCallback)this.appOpenAdLoadCallback);
    }

    public void showAd() {
        if (!(this.mCxt instanceof Activity)) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAppOpenAd != null) {
            Log.i((String)TAG, (String)"showAd: ");
            this.mAppOpenAd.setFullScreenContentCallback(this.fullScreenContentCallback);
            this.mAppOpenAd.show((Activity)this.mCxt);
        } else if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    private boolean wasLoadTimeLessThanNHoursAgo(long numHours) {
        long dateDifference = System.currentTimeMillis() - this.loadTime;
        return dateDifference < numHours * 3600000L;
    }

    public void clean() {
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }
}

