/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import com.tradplus.ads.google.AdManagerNativeAd;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

class AdManagerNative
extends TPNativeAdapter {
    private AdManagerAdRequest request;
    private AdManagerAdView mAdManagerAdView;
    private AdManagerNativeAd mAdManagerNativeAd;
    private String adUnitId;
    private int mIsTemplateRending;
    private static final String TAG = "GAMNative";
    private Boolean mVideoMute = true;
    private String mAdSize;
    private Integer adSize;
    private int AdChoicesPlacementOptions = -1;

    AdManagerNative() {
    }

    public void loadCustomAd(final Context context, final Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.adUnitId = tpParams.get("placementId");
        String template = tpParams.get("is_template_rendering");
        this.mAdSize = tpParams.get("ad_size" + this.adUnitId);
        if (!TextUtils.isEmpty((CharSequence)template)) {
            this.mIsTemplateRending = Integer.parseInt(template);
        }
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("native_video_mute")) {
                this.mVideoMute = (Boolean)userParams.get("native_video_mute");
            }
            if (userParams.containsKey("native_express_size")) {
                this.adSize = (Integer)userParams.get("native_express_size");
            }
        }
        this.request = AdManagerInit.getInstance().getAdmobAdRequest(userParams);
        GoogleInitManager.getInstance().initSDK(context, (AdRequest)this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AdManagerNative.this.requestNative(userParams, context);
            }

            public void onFailed(String code, String msg) {
                if (AdManagerNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestNative(Map<String, Object> userParams, Context context) {
        if (this.mIsTemplateRending == 1) {
            Log.i((String)TAG, (String)("requestExpressNative: adUnitId:" + this.adUnitId));
            final AdManagerAdView adManagerAdView = new AdManagerAdView(context);
            adManagerAdView.setAdUnitId(this.adUnitId);
            adManagerAdView.setAdSize(this.calculateAdSize(this.adSize));
            adManagerAdView.setAdListener(new AdListener(){

                public void onAdClicked() {
                    Log.i((String)AdManagerNative.TAG, (String)"onAdClicked: ");
                    if (AdManagerNative.this.mAdManagerNativeAd != null) {
                        AdManagerNative.this.mAdManagerNativeAd.onAdViewClicked();
                    }
                }

                public void onAdClosed() {
                    Log.i((String)AdManagerNative.TAG, (String)"onAdClosed: ");
                    if (AdManagerNative.this.mAdManagerNativeAd != null) {
                        AdManagerNative.this.mAdManagerNativeAd.onAdViewClosed();
                    }
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    Log.i((String)AdManagerNative.TAG, (String)("onAdFailedToLoad: Code :" + loadAdError.getCode() + ", msg : " + loadAdError.getMessage()));
                    if (AdManagerNative.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network failed to provide an ad.");
                        tpError.setErrorCode(loadAdError.getCode() + "");
                        tpError.setErrorMessage(loadAdError.getMessage());
                        AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }

                public void onAdImpression() {
                    Log.i((String)AdManagerNative.TAG, (String)"onAdImpression: ");
                    if (AdManagerNative.this.mAdManagerNativeAd != null) {
                        AdManagerNative.this.mAdManagerNativeAd.onAdViewExpanded();
                    }
                }

                public void onAdLoaded() {
                    Log.i((String)AdManagerNative.TAG, (String)"onAdLoaded: ");
                    AdManagerNative.this.mAdManagerNativeAd = new AdManagerNativeAd(adManagerAdView, 1);
                    if (AdManagerNative.this.mLoadAdapterListener != null) {
                        AdManagerNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)AdManagerNative.this.mAdManagerNativeAd);
                    }
                }

                public void onAdOpened() {
                    super.onAdOpened();
                }
            });
            adManagerAdView.loadAd(this.request);
        } else {
            block11: {
                try {
                    Object object = userParams.get("Admob_Adchoices");
                    Log.i((String)TAG, (String)("adchoices:" + object));
                    if (object instanceof Integer) {
                        int tempCode = (Integer)object;
                        switch (tempCode) {
                            case 0: {
                                this.AdChoicesPlacementOptions = 0;
                                break;
                            }
                            case 1: {
                                this.AdChoicesPlacementOptions = 1;
                                break;
                            }
                            case 2: {
                                this.AdChoicesPlacementOptions = 2;
                                break;
                            }
                            case 3: {
                                this.AdChoicesPlacementOptions = 3;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("requestNative: Exception : " + e.getLocalizedMessage()));
                    if (this.mLoadAdapterListener == null) break block11;
                    TPError tpError = new TPError("Unspecified error.");
                    tpError.setErrorMessage(e.getLocalizedMessage());
                    this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
            this.loadAd(context, this.adUnitId);
        }
    }

    private void loadAd(final Context context, String adUnitId) {
        Log.i((String)TAG, (String)("requestNative adUnitId:" + adUnitId));
        AdLoader.Builder builder = new AdLoader.Builder(context, adUnitId);
        NativeAdOptions.Builder optionsBuilder = new NativeAdOptions.Builder();
        optionsBuilder.setReturnUrlsForImageAssets(true);
        optionsBuilder.setRequestMultipleImages(false);
        optionsBuilder.setReturnUrlsForImageAssets(false);
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(this.mVideoMute.booleanValue()).build();
        optionsBuilder.setVideoOptions(videoOptions);
        Log.i((String)TAG, (String)("adchoices AdChoicesPlacementOptions: " + this.AdChoicesPlacementOptions));
        if (this.AdChoicesPlacementOptions != -1) {
            optionsBuilder.setAdChoicesPlacement(this.AdChoicesPlacementOptions);
        }
        optionsBuilder.setMediaAspectRatio(this.calculateAdRatio(this.mAdSize));
        NativeAdOptions adOptions = optionsBuilder.build();
        AdLoader adLoader = builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

            public void onNativeAdLoaded(NativeAd nativeAd) {
                if (!AdManagerNative.this.isValidUnifiedAd(nativeAd)) {
                    if (AdManagerNative.this.mLoadAdapterListener != null) {
                        AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                    }
                    return;
                }
                Log.i((String)AdManagerNative.TAG, (String)"onNativeAdLoaded: ");
                AdManagerNative.this.mAdManagerNativeAd = new AdManagerNativeAd(context, nativeAd, 0);
                if (AdManagerNative.this.mLoadAdapterListener != null) {
                    AdManagerNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)AdManagerNative.this.mAdManagerNativeAd);
                }
            }
        }).withAdListener(new AdListener(){

            public void onAdClicked() {
                Log.i((String)AdManagerNative.TAG, (String)"onAdClicked: ");
                if (AdManagerNative.this.mAdManagerNativeAd != null) {
                    AdManagerNative.this.mAdManagerNativeAd.onAdViewClicked();
                }
            }

            public void onAdImpression() {
                Log.i((String)AdManagerNative.TAG, (String)"onAdImpression: ");
                if (AdManagerNative.this.mAdManagerNativeAd != null) {
                    AdManagerNative.this.mAdManagerNativeAd.onAdViewExpanded();
                }
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                Log.i((String)AdManagerNative.TAG, (String)("onAdFailedToLoad: Code :" + loadAdError.getCode() + " , Message :" + loadAdError.getMessage()));
                if (AdManagerNative.this.mLoadAdapterListener != null) {
                    switch (loadAdError.getCode()) {
                        case 0: {
                            AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("CustomEventNative was configured incorrectly."), loadAdError));
                            break;
                        }
                        case 1: {
                            AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network received invalid request."), loadAdError));
                            break;
                        }
                        case 2: {
                            AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Network is unavailable."), loadAdError));
                            break;
                        }
                        case 3: {
                            AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                            break;
                        }
                        default: {
                            AdManagerNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Unspecified error."), loadAdError));
                        }
                    }
                }
            }
        }).withNativeAdOptions(adOptions).build();
        adLoader.loadAd(this.request);
    }

    private boolean isValidUnifiedAd(NativeAd unifiedNativeAd) {
        return unifiedNativeAd.getHeadline() != null && unifiedNativeAd.getBody() != null && unifiedNativeAd.getImages() != null && unifiedNativeAd.getImages().size() > 0 && unifiedNativeAd.getImages().get(0) != null && unifiedNativeAd.getIcon() != null && unifiedNativeAd.getCallToAction() != null;
    }

    public void clean() {
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("49");
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int microVersion = version.getMicroVersion();
        int minorVersion = version.getMinorVersion();
        return majorVersion + "." + microVersion + "." + minorVersion + "";
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }

    private AdSize calculateAdSize(int adSize) {
        Log.i((String)TAG, (String)("calculateAdSize: " + adSize));
        if (2 == adSize) {
            return AdSize.LARGE_BANNER;
        }
        if (3 == adSize) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if (4 == adSize) {
            return AdSize.FLUID;
        }
        if (5 == adSize) {
            return AdSize.LEADERBOARD;
        }
        return AdSize.BANNER;
    }

    private int calculateAdRatio(String adSize) {
        Log.i((String)TAG, (String)("calculateAdRatio: " + adSize));
        if ("3".equals(adSize)) {
            return 2;
        }
        if ("4".equals(adSize)) {
            return 3;
        }
        if ("5".equals(adSize)) {
            return 4;
        }
        return 1;
    }
}

