/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GoogleInitManager
extends TPInitMediation {
    private static final String TAG = "Admob";
    private static GoogleInitManager sInstance;

    public static synchronized GoogleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new GoogleInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, AdRequest request, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        final String customAs = RequestUtils.getInstance().getCustomAs("2");
        this.removeInited(customAs);
        if (GoogleInitManager.isInited((String)customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        this.suportGDPR(context, userParams);
        this.setTestDevice(request, context);
        MobileAds.disableMediationAdapterInitialization((Context)context);
        String isInitNoCallBack = "1";
        if (tpParams != null && tpParams.size() > 0 && tpParams.containsKey("init_no_callback")) {
            isInitNoCallBack = tpParams.get("init_no_callback");
        }
        Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
        Log.i((String)TAG, (String)("isInitNoCallBack: " + isInitNoCallBack));
        if ("0".equals(isInitNoCallBack)) {
            MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                public void onInitializationComplete(InitializationStatus initializationStatus) {
                    AdapterStatus.State state;
                    AdapterStatus status = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                    AdapterStatus.State state2 = state = status != null ? status.getInitializationState() : null;
                    if (state == AdapterStatus.State.READY) {
                        Log.i((String)GoogleInitManager.TAG, (String)"onInitializationComplete: ");
                        GoogleInitManager.this.sendResult(customAs, true);
                    } else {
                        GoogleInitManager.this.sendResult(customAs, false, "", "NOT READY");
                    }
                }
            });
        } else {
            MobileAds.initialize((Context)context);
            this.sendResult(customAs, true);
        }
    }

    public void setTestDevice(AdRequest request, Context context) {
        if (TestDeviceUtil.getInstance().isNeedTestDevice()) {
            String admobTestDevice = TestDeviceUtil.getInstance().getAdmobTestDevice();
            if (!TextUtils.isEmpty((CharSequence)admobTestDevice)) {
                List<String> testDeviceIds = Arrays.asList(admobTestDevice);
                RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
                MobileAds.setRequestConfiguration((RequestConfiguration)configuration);
            }
            boolean testDevice = request.isTestDevice(context);
            Log.i((String)TAG, (String)("isTestDevice  : " + testDevice));
        }
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        this.initSDK(context, this.getAdmobAdRequest(userParams), userParams, tpParams, initCallback);
    }

    public AdRequest getAdmobAdRequest(Map<String, Object> userParams) {
        if (userParams == null || userParams.size() <= 0) {
            return new AdRequest.Builder().build();
        }
        Bundle networkExtrasBundle = new Bundle();
        if (!GlobalTradPlus.getInstance().isOpenPersonalizedAd()) {
            networkExtrasBundle.putString("npa", "1");
        }
        Log.i((String)"PersonalizeEnable", (String)("Admob openPersonalizedAd \u4e2a\u6027\u5316\u5f00\u5173: " + GlobalTradPlus.getInstance().isOpenPersonalizedAd()));
        if (userParams.containsKey("CCPA")) {
            boolean ccpa = (Boolean)userParams.get("CCPA");
            Log.i((String)TAG, (String)("ccpa: " + ccpa));
            if (ccpa) {
                networkExtrasBundle.putInt("rdp", 1);
            }
        }
        if (userParams.containsKey("gdpr_consent") && userParams.containsKey("isue")) {
            boolean need_set_gdpr = false;
            int consent = (Integer)userParams.get("gdpr_consent");
            if (consent == 1 || consent == 2) {
                need_set_gdpr = true;
            }
            boolean isEu = (Boolean)userParams.get("isue");
            Log.i((String)TAG, (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
            if (need_set_gdpr && isEu) {
                networkExtrasBundle.putString("npa", "1");
            }
        }
        return new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, networkExtrasBundle).build();
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("COPPA")) {
            boolean coppa = (Boolean)userParams.get("COPPA");
            RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration().toBuilder().setTagForChildDirectedTreatment(coppa ? 1 : 0).build();
            MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
        }
    }

    public String getNetworkVersionCode() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int microVersion = version.getMicroVersion();
        int minorVersion = version.getMinorVersion();
        return majorVersion + "." + microVersion + "." + minorVersion + "";
    }

    public String getNetworkVersionName() {
        return "Google Admob";
    }
}

