/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class GooglePlayServicesInterstitial
extends TPInterstitialAdapter {
    private InterstitialAd mInterstitialAd;
    private AdRequest request;
    private String adUnitId;
    private static final String TAG = "AdmobInterstitial";
    private final InterstitialAdLoadCallback mInterstitialAdLoadCallback = new InterstitialAdLoadCallback(){

        public void onAdLoaded(InterstitialAd interstitialAd) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdLoaded: ");
            GooglePlayServicesInterstitial.this.setFirstLoadedTime();
            GooglePlayServicesInterstitial.this.mInterstitialAd = interstitialAd;
            if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.setNetworkObjectAd(interstitialAd);
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitial.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"The ad was dismissed.");
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdClosed();
                    }
                }

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToShowFullScreenContent: code :" + adError.getCode() + ", msg :" + adError.getMessage()));
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                        tpError.setErrorCode(adError.getCode() + "");
                        tpError.setErrorMessage(adError.getMessage());
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoError(tpError);
                    }
                }

                public void onAdShowedFullScreenContent() {
                    GooglePlayServicesInterstitial.this.mInterstitialAd = null;
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"The ad was shown.");
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdShown();
                    }
                }

                public void onAdClicked() {
                    Log.i((String)GooglePlayServicesInterstitial.TAG, (String)"onAdClicked: ");
                    if (GooglePlayServicesInterstitial.this.mShowListener != null) {
                        GooglePlayServicesInterstitial.this.mShowListener.onAdVideoClicked();
                    }
                }
            });
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitial.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg :" + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitial.this.mInterstitialAd = null;
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (!this.extrasAreValid(tpParams)) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            }
            return;
        }
        this.adUnitId = tpParams.get("placementId");
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                GooglePlayServicesInterstitial.this.requestInterstitial(context);
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesInterstitial.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitial(Context context) {
        block2: {
            try {
                InterstitialAd.load((Context)context, (String)this.adUnitId, (AdRequest)this.request, (InterstitialAdLoadCallback)this.mInterstitialAdLoadCallback);
            }
            catch (Throwable e) {
                Log.i((String)TAG, (String)("Throwable: " + e.getLocalizedMessage()));
                if (this.mLoadAdapterListener == null) break block2;
                TPError tpError = new TPError("Unspecified error.");
                tpError.setErrorMessage(e.getLocalizedMessage());
                this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    }

    public void showAd() {
        if (this.mInterstitialAd != null) {
            Activity activity = GlobalTradPlus.getInstance().getActivity();
            if (activity == null) {
                if (this.mShowListener != null) {
                    this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
                }
                return;
            }
            this.mInterstitialAd.show(activity);
        } else if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            Log.i((String)TAG, (String)"Tried to show a Google Play Services interstitial ad before it finished loading. Please try again.");
        }
    }

    public boolean isReady() {
        boolean isMainThread;
        if (this.mInterstitialAd == null) {
            return false;
        }
        boolean bl = isMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isMainThread) {
            return !this.isAdsTimeOut();
        }
        return !this.isAdsTimeOut();
    }

    public void clean() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.setFullScreenContentCallback(null);
            this.mInterstitialAd = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int microVersion = version.getMicroVersion();
        int minorVersion = version.getMinorVersion();
        return majorVersion + "." + microVersion + "." + minorVersion + "";
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }
}

