/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.google.GoogleNativeAd;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

class GooglePlayServicesNative
extends TPNativeAdapter {
    private AdRequest request;
    private GoogleNativeAd mGoogleNativeAd;
    private String adUnitId;
    private static final String TAG = "AdmobNative";
    private Boolean mVideoMute = true;
    private String mAdSize;
    private int adChoicesPosition = 1;
    private String id;

    GooglePlayServicesNative() {
    }

    public void loadCustomAd(final Context context, final Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.adUnitId = tpParams.get("placementId");
        this.mAdSize = tpParams.get("ad_size" + this.adUnitId);
        this.id = tpParams.get("id");
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("native_video_mute")) {
                this.mVideoMute = (Boolean)userParams.get("native_video_mute");
            }
            if (userParams.containsKey("adchoices_position")) {
                this.adChoicesPosition = (Integer)userParams.get("adchoices_position");
                Log.i((String)TAG, (String)("adChoicesPosition: " + this.adChoicesPosition));
            }
        }
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                GooglePlayServicesNative.this.requestNative(userParams, context);
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestNative(Map<String, Object> userParams, Context context) {
        block3: {
            try {
                Object object = userParams.get("Admob_Adchoices");
                Log.i((String)TAG, (String)("adchoices: " + object));
                if (object instanceof Integer) {
                    this.adChoicesPosition = (Integer)object;
                }
            }
            catch (Throwable e) {
                Log.i((String)TAG, (String)("requestNative: Exception : " + e.getLocalizedMessage()));
                if (this.mLoadAdapterListener == null) break block3;
                TPError tpError = new TPError("Unspecified error.");
                tpError.setErrorMessage(e.getLocalizedMessage());
                this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
        this.loadAd(context, this.adUnitId);
    }

    private void loadAd(final Context context, String adUnitId) {
        AdLoader.Builder builder = new AdLoader.Builder(context, adUnitId);
        NativeAdOptions.Builder optionsBuilder = new NativeAdOptions.Builder();
        optionsBuilder.setRequestMultipleImages(false);
        optionsBuilder.setReturnUrlsForImageAssets(false);
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(this.mVideoMute.booleanValue()).build();
        optionsBuilder.setVideoOptions(videoOptions);
        Log.i((String)TAG, (String)("adchoices adChoicesPosition: " + this.adChoicesPosition));
        optionsBuilder.setAdChoicesPlacement(this.adChoicesPosition);
        optionsBuilder.setMediaAspectRatio(this.calculateAdRatio(this.mAdSize));
        NativeAdOptions adOptions = optionsBuilder.build();
        AdLoader adLoader = builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

            public void onNativeAdLoaded(NativeAd nativeAd) {
                if (nativeAd == null || TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                    if (GooglePlayServicesNative.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network failed to provide an ad.");
                        tpError.setErrorMessage("Google native ad is missing one or more required assets.");
                        GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                    return;
                }
                Log.i((String)GooglePlayServicesNative.TAG, (String)"onNativeAdLoaded: ");
                GooglePlayServicesNative.this.mGoogleNativeAd = new GoogleNativeAd(context, nativeAd);
                if (GooglePlayServicesNative.this.mLoadAdapterListener != null) {
                    GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)GooglePlayServicesNative.this.mGoogleNativeAd);
                }
            }
        }).withAdListener(new AdListener(){

            public void onAdClicked() {
                Log.i((String)GooglePlayServicesNative.TAG, (String)"onAdClicked: ");
                if (GooglePlayServicesNative.this.mGoogleNativeAd != null) {
                    GooglePlayServicesNative.this.mGoogleNativeAd.onAdViewClicked();
                }
            }

            public void onAdImpression() {
                Log.i((String)GooglePlayServicesNative.TAG, (String)"onAdImpression: ");
                if (GooglePlayServicesNative.this.mGoogleNativeAd != null) {
                    GooglePlayServicesNative.this.mGoogleNativeAd.onAdViewExpanded();
                }
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                Log.i((String)GooglePlayServicesNative.TAG, (String)("onAdFailedToLoad: Code :" + loadAdError.getCode() + " , Message :" + loadAdError.getMessage()));
                if (GooglePlayServicesNative.this.mLoadAdapterListener != null) {
                    switch (loadAdError.getCode()) {
                        case 0: {
                            GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("CustomEventNative was configured incorrectly."), loadAdError));
                            break;
                        }
                        case 1: {
                            GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network received invalid request."), loadAdError));
                            break;
                        }
                        case 2: {
                            GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Network is unavailable."), loadAdError));
                            break;
                        }
                        case 3: {
                            GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                            break;
                        }
                        default: {
                            GooglePlayServicesNative.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Unspecified error."), loadAdError));
                        }
                    }
                }
            }
        }).withNativeAdOptions(adOptions).build();
        adLoader.loadAd(this.request);
    }

    public void clean() {
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs(this.id);
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }

    private int calculateAdRatio(String adSize) {
        Log.i((String)TAG, (String)("calculateAdRatio: " + adSize));
        if ("3".equals(adSize)) {
            return 2;
        }
        if ("4".equals(adSize)) {
            return 3;
        }
        if ("5".equals(adSize)) {
            return 4;
        }
        return 1;
    }
}

