/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class googlePlaySplashAd
extends TPSplashAdapter {
    private static final long EXPIRED_TIME = 4L;
    private long loadTime = 0L;
    public static final String TAG = "AdmobSplash";
    private AppOpenAd mAppOpenAd;
    private String mAdUnitId;
    private AdRequest request;
    private Integer mVideoMute = 0;
    private int mOrientation = 1;
    private String id;
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdLoaded(AppOpenAd appOpenAd) {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAppOpenAdLoaded: ");
            if (appOpenAd != null) {
                googlePlaySplashAd.this.loadTime = System.currentTimeMillis();
                googlePlaySplashAd.this.mAppOpenAd = appOpenAd;
                if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                    googlePlaySplashAd.this.setNetworkObjectAd(appOpenAd);
                    googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)googlePlaySplashAd.TAG, (String)("onAppOpenAdFailedToLoad message: " + loadAdError.getMessage() + ":code:" + loadAdError.getCode()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorCode(String.valueOf(loadAdError.getCode()));
            tpError.setErrorMessage(loadAdError.getMessage());
            if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    };
    final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdDismissedFullScreenContent() {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAdDismissedFullScreenContent: ");
            if (googlePlaySplashAd.this.mShowListener != null) {
                googlePlaySplashAd.this.mShowListener.onAdClosed();
            }
        }

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)googlePlaySplashAd.TAG, (String)("onAdFailedToShowFullScreenContent msg : " + adError.getMessage() + ":code:" + adError.getCode()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorCode(String.valueOf(adError.getCode()));
            tpError.setErrorMessage(adError.getMessage());
            if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }

        public void onAdShowedFullScreenContent() {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAdShowedFullScreenContent: ");
            if (googlePlaySplashAd.this.mShowListener != null) {
                googlePlaySplashAd.this.mShowListener.onAdShown();
            }
        }

        public void onAdClicked() {
            Log.i((String)googlePlaySplashAd.TAG, (String)"onAdClicked: ");
            if (googlePlaySplashAd.this.mShowListener != null) {
                googlePlaySplashAd.this.mShowListener.onAdClicked();
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mAdUnitId = tpParams.get("placementId");
            this.id = tpParams.get("id");
        }
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("Admob_Direction")) {
                this.mOrientation = (Integer)userParams.get("Admob_Direction");
            }
            if (userParams.containsKey("video_admob_mute")) {
                this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
            }
        }
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (googlePlaySplashAd.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((googlePlaySplashAd.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                googlePlaySplashAd.this.requestSplash(context);
            }

            public void onFailed(String code, String msg) {
                if (googlePlaySplashAd.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    googlePlaySplashAd.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestSplash(Context context) {
        if (this.mOrientation == 2) {
            this.mOrientation = 2;
        }
        Log.i((String)TAG, (String)("Orientation: " + this.mOrientation + ", 1:\u7ad6\u5c4f\uff1b2:\u6a2a\u5c4f"));
        AppOpenAd.load((Context)context, (String)this.mAdUnitId, (AdRequest)this.request, (int)this.mOrientation, (AppOpenAd.AppOpenAdLoadCallback)this.appOpenAdLoadCallback);
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAppOpenAd != null) {
            Log.i((String)TAG, (String)"showAd: ");
            this.mAppOpenAd.setFullScreenContentCallback(this.fullScreenContentCallback);
            this.mAppOpenAd.show(activity);
        } else if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    private boolean wasLoadTimeLessThanNHoursAgo(long numHours) {
        long dateDifference = System.currentTimeMillis() - this.loadTime;
        return dateDifference < numHours * 3600000L;
    }

    public void clean() {
        if (this.mAppOpenAd != null) {
            this.mAppOpenAd.setFullScreenContentCallback(null);
            this.mAppOpenAd = null;
        }
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs(this.id);
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }
}

