/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.bytedance.sdk.openadsdk.TTAdConfig;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import java.util.Map;

public class TDADManagerHolder {
    private static final String TAG = "Pangle";
    private static TDADManagerHolder sInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public static synchronized TDADManagerHolder getInstance() {
        if (sInstance == null) {
            sInstance = new TDADManagerHolder();
        }
        return sInstance;
    }

    public void init(Context context, Map<String, Object> localExtras, String appId, final InitCallback initCallback) {
        TTAdSdk.init((Context)context, (TTAdConfig)TDADManagerHolder.buildConfig(context, localExtras, appId), (TTAdSdk.InitCallback)new TTAdSdk.InitCallback(){

            public void success() {
                TDADManagerHolder.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Log.i((String)TDADManagerHolder.TAG, (String)"success: ");
                        if (initCallback != null) {
                            initCallback.onSuccess();
                        }
                    }
                }, 500L);
            }

            public void fail(int code, String msg) {
                Log.i((String)TDADManagerHolder.TAG, (String)("fail: code :" + code + ",msg :" + code));
                if (initCallback != null) {
                    initCallback.onFailed(code, msg);
                }
            }
        });
    }

    private static TTAdConfig buildConfig(Context context, Map<String, Object> localExtras, String appId) {
        boolean need_set_gdpr = false;
        int ischild = 0;
        if (localExtras != null && localExtras.size() > 0) {
            boolean coppa;
            int consent;
            if (localExtras.containsKey("gdpr_consent") && (consent = ((Integer)localExtras.get("gdpr_consent")).intValue()) == 0) {
                need_set_gdpr = true;
            }
            Log.i((String)"TDADManagerHolder", (String)("suportGDPR :COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                ischild = 1;
            }
        }
        return new TTAdConfig.Builder().appId(appId).appName("TradPlus").useTextureView(true).titleBarTheme(1).allowShowNotify(true).allowShowPageWhenScreenLock(true).supportMultiProcess(true).needClearTaskReset(new String[0]).setGDPR(need_set_gdpr ? 1 : 0).coppa(ischild).debug(false).build();
    }

    public static interface InitCallback {
        public void onSuccess();

        public void onFailed(int var1, String var2);
    }
}

