/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.TDADManagerHolder;
import com.tradplus.ads.fpangolin.ToutiaoAdsInterstitialListener;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TPContextUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ToutiaoRewardVideoAdapter
extends TPRewardAdapter {
    private static final String TAG = "PangleRewardedVideo";
    private TTAdNative ttAdNative;
    private TTRewardVideoAd mttRewardVideoAd;
    private WeakReference<Context> contextWeakReference;
    private ToutiaoInterstitialCallbackRouter toutiaoInterstitialCallbackRouter;
    private String appId;
    private String placementId;
    private String userId;
    private int mIsTemplateRending;
    private TTAdManager mTTAdManager;

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.toutiaoInterstitialCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        if (serverExtras != null && serverExtras.size() > 0) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        }
        if (localExtras != null && localExtras.size() > 0) {
            this.userId = (String)localExtras.get("user_id");
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userId = "";
            }
        }
        Log.i((String)TAG, (String)("loadInterstitial appId: " + this.appId + ":PId:" + this.placementId));
        this.toutiaoInterstitialCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        this.mLoadAdapterListener = this.toutiaoInterstitialCallbackRouter.getListener(this.placementId);
        if (this.mTTAdManager == null) {
            this.mTTAdManager = TTAdSdk.getAdManager();
        }
        if (this.ttAdNative == null) {
            this.ttAdNative = this.mTTAdManager.createAdNative(context);
        }
        if (!TTAdSdk.isInitSuccess()) {
            TDADManagerHolder.getInstance().init(context, localExtras, this.appId, new TDADManagerHolder.InitCallback(){

                @Override
                public void onSuccess() {
                    ToutiaoRewardVideoAdapter.this.requestInterstitial(context);
                }

                @Override
                public void onFailed(int code, String msg) {
                    if (ToutiaoRewardVideoAdapter.this.mLoadAdapterListener != null) {
                        TradPlusErrorCode tradPlusErrorCode = TradPlusErrorCode.INIT_FAILED;
                        tradPlusErrorCode.setCode(code + "");
                        tradPlusErrorCode.setErrormessage(msg);
                        ToutiaoRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tradPlusErrorCode);
                    }
                }
            });
        } else {
            this.requestInterstitial(context);
        }
    }

    private void requestInterstitial(Context context) {
        int ori = context.getResources().getConfiguration().orientation;
        Log.i((String)TAG, (String)("RewardData: userId : " + this.userId));
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setAdCount(1).setImageAcceptedSize(1080, 1920).setUserID(TextUtils.isEmpty((CharSequence)this.userId) ? "" : this.userId).setOrientation(ori == 0 ? 2 : 1);
        Log.i((String)"ToutiaoRewardVideo", (String)("initRewardVideo: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 1) {
            builder.setExpressViewAcceptedSize(500.0f, 500.0f);
        }
        AdSlot adSlot = builder.build();
        this.ttAdNative.loadRewardVideoAd(adSlot, new TTAdNative.RewardVideoAdListener(){

            public void onError(int i, String s) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)("onError: " + i + ":msg:" + s));
                if (ToutiaoRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    ToutiaoRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(i, s));
                }
            }

            public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onRewardVideoAdLoad: ");
                ToutiaoRewardVideoAdapter.this.setFirstLoadedTime();
                ToutiaoRewardVideoAdapter.this.mttRewardVideoAd = ttRewardVideoAd;
            }

            public void onRewardVideoCached() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onRewardVideoCached: ");
                ToutiaoRewardVideoAdapter.this.mttRewardVideoAd.setRewardAdInteractionListener((TTRewardVideoAd.RewardAdInteractionListener)new ToutiaoAdsInterstitialListener(ToutiaoRewardVideoAdapter.this.placementId));
                ToutiaoRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        });
    }

    public void showAd() {
        Context context;
        Context _ct;
        if (this.toutiaoInterstitialCallbackRouter != null && this.mShowListener != null) {
            this.toutiaoInterstitialCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((_ct = TPContextUtils.getInstance((Context)(context = (Context)this.contextWeakReference.get())).compareContext(context)) == null) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.SHOW_FAILED);
            }
        } else if (context != null && this.mttRewardVideoAd != null) {
            this.mttRewardVideoAd.showRewardVideoAd((Activity)_ct);
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.SHOW_FAILED);
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        if (this.mTTAdManager != null) {
            return this.mTTAdManager.getSDKVersion();
        }
        return null;
    }
}

