/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFeedAd;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoNativeAd;
import com.tradplus.ads.fpangolin.UIUtils;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.AppKeyManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.List;
import java.util.Map;

public class TouTiaoRenderNativeVideo
extends TPNativeAdapter {
    private Context mCxt;
    private String mAppId;
    private TTFeedAd mTtNativeExpressAd;
    public static final String TAG = "PangleNative";
    private String mPlacementId;
    private int mIsTemplateRending;
    private TTAdManager adManager;
    private TTAdNative mAdNative;
    private int mWidth;
    private int mHeight;
    private ToutiaoNativeAd mToutiaoNativeAd;
    private boolean mNeedDownloadImg = false;
    private TTNativeExpressAd mExpressAd;
    final TTAdNative.NativeExpressAdListener nativeExpressAdListener = new TTAdNative.NativeExpressAdListener(){

        public void onError(int errorCode, String errorMsg) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)("onError: " + errorCode + ":errorMsg:" + errorMsg));
            if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onNativeExpressAdLoad: ");
            if (list == null || list.size() == 0) {
                return;
            }
            TouTiaoRenderNativeVideo.this.mExpressAd = list.get(0);
            TouTiaoRenderNativeVideo.this.bindListener(TouTiaoRenderNativeVideo.this.mExpressAd);
            TouTiaoRenderNativeVideo.this.mExpressAd.render();
        }
    };
    final TTAdNative.FeedAdListener feedAdListener = new TTAdNative.FeedAdListener(){

        public void onError(int errorCode, String errorMsg) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)("onError: errorCode:" + errorCode + ", errorMsg :" + errorMsg));
            if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onFeedAdLoad(List<TTFeedAd> list) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onNativeExpressAdLoad: ");
            if (list == null || list.size() == 0) {
                return;
            }
            TouTiaoRenderNativeVideo.this.mTtNativeExpressAd = list.get(0);
            ToutiaoNativeAd toutiaoNativeAd = new ToutiaoNativeAd(TouTiaoRenderNativeVideo.this.mTtNativeExpressAd);
            toutiaoNativeAd.setRenderType(TouTiaoRenderNativeVideo.this.mIsTemplateRending);
            TouTiaoRenderNativeVideo.this.downloadAndCallback(toutiaoNativeAd, TouTiaoRenderNativeVideo.this.mNeedDownloadImg);
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Log.i((String)TAG, (String)"loadAdView: ");
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        if (serverExtras != null && serverExtras.size() > 0) {
            this.mAppId = serverExtras.get("appId");
            this.mPlacementId = serverExtras.get("placementId");
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        }
        if (localExtras != null && localExtras.size() > 0) {
            String downLoadImg;
            if (localExtras.containsKey("com_tp_ad_width")) {
                this.mWidth = (Integer)localExtras.get("com_tp_ad_width");
            }
            if (localExtras.containsKey("com_tp_ad_height")) {
                this.mHeight = (Integer)localExtras.get("com_tp_ad_height");
            }
            if (localExtras.containsKey("need_down_load_img") && (downLoadImg = (String)localExtras.get("need_down_load_img")).equals("true")) {
                this.mNeedDownloadImg = true;
            }
        }
        if (this.mWidth <= 0 && this.mHeight <= 0) {
            if (this.mIsTemplateRending == 1) {
                this.mWidth = (int)UIUtils.getScreenWidthDp(context);
                this.mHeight = 340;
            } else {
                this.mWidth = 600;
                this.mHeight = 257;
            }
        }
        Log.i((String)TAG, (String)("Width :" + this.mWidth + ", Height :" + this.mHeight));
        if (this.adManager == null) {
            this.adManager = TTAdSdk.getAdManager();
        }
        if (this.mAdNative == null) {
            this.mAdNative = this.adManager.createAdNative(this.mCxt);
        }
        if (!TTAdSdk.isInitSuccess() && !AppKeyManager.getInstance().isInited(this.mAppId, AppKeyManager.AdType.SHARE)) {
            PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TouTiaoRenderNativeVideo.this.requestNative();
                }

                public void onFailed(String code, String msg) {
                    if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                        TradPlusErrorCode tradPlusErrorCode = TradPlusErrorCode.INIT_FAILED;
                        tradPlusErrorCode.setCode(code + "");
                        tradPlusErrorCode.setErrormessage(msg);
                        TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tradPlusErrorCode);
                    }
                }
            });
        } else {
            this.requestNative();
        }
    }

    private void requestNative() {
        Log.i((String)TAG, (String)("requestNative TemplateRending: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 2) {
            AdSlot slot = new AdSlot.Builder().setCodeId(this.mPlacementId).setImageAcceptedSize(this.mWidth, this.mHeight).setAdCount(3).build();
            this.mAdNative.loadFeedAd(slot, this.feedAdListener);
        } else {
            AdSlot slot = new AdSlot.Builder().setCodeId(this.mPlacementId).setSupportDeepLink(true).setAdCount(1).setExpressViewAcceptedSize((float)this.mWidth, (float)this.mHeight).build();
            this.mAdNative.loadNativeExpressAd(slot, this.nativeExpressAdListener);
        }
    }

    private void bindListener(TTNativeExpressAd mTtNativeExpressAd) {
        Log.i((String)TAG, (String)"bindListener: ");
        if (mTtNativeExpressAd != null) {
            mTtNativeExpressAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener(){

                public void onAdClicked(View view, int i) {
                    Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onAdClicked: ");
                    if (TouTiaoRenderNativeVideo.this.mToutiaoNativeAd != null) {
                        TouTiaoRenderNativeVideo.this.mToutiaoNativeAd.adClicked();
                    }
                }

                public void onAdShow(View view, int i) {
                    Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onAdShow: ");
                    if (TouTiaoRenderNativeVideo.this.mToutiaoNativeAd != null) {
                        TouTiaoRenderNativeVideo.this.mToutiaoNativeAd.adShown();
                    }
                }

                public void onRenderFail(View view, String errorMsg, int errorCode) {
                    Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)("onRenderFail: " + errorMsg + ":errorCode:" + errorCode));
                    if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                        TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                    }
                }

                public void onRenderSuccess(View view, float v, float v1) {
                    Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onRenderSuccess: ");
                    RelativeLayout mRelativeLayout = new RelativeLayout(TouTiaoRenderNativeVideo.this.mCxt);
                    mRelativeLayout.addView(view);
                    mRelativeLayout.setGravity(17);
                    TouTiaoRenderNativeVideo.this.mToutiaoNativeAd = new ToutiaoNativeAd((View)mRelativeLayout);
                    TouTiaoRenderNativeVideo.this.mToutiaoNativeAd.setRenderType(TouTiaoRenderNativeVideo.this.mIsTemplateRending);
                    if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                        TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)TouTiaoRenderNativeVideo.this.mToutiaoNativeAd);
                    }
                }
            });
        }
    }

    public void clean() {
        Log.i((String)TAG, (String)"clean: ");
        if (this.mExpressAd != null) {
            this.mExpressAd.destroy();
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        if (this.adManager != null) {
            return this.adManager.getSDKVersion();
        }
        return null;
    }
}

