/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.AppKeyManager;
import com.tradplus.ads.mobileads.util.TPContextUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;

public class ToutiaoInterstitialAdapter
extends TPInterstitialAdapter
implements TTAdNative.NativeExpressAdListener {
    public static final String TAG = "PangleInterstitial";
    public static final float EXPRESSVIEW_WIDTH1 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT1 = 300.0f;
    public static final float EXPRESSVIEW_WIDTH2 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT2 = 450.0f;
    public static final float EXPRESSVIEW_WIDTH3 = 450.0f;
    public static final float EXPRESSVIEW_HEIGHT3 = 300.0f;
    private TTAdNative ttAdNative;
    private TTNativeExpressAd ttNativeExpressAd;
    private WeakReference<Context> contextWeakReference;
    private ToutiaoInterstitialCallbackRouter toutiaoInterstitialCallbackRouter;
    private String appId;
    private String placementId;
    private int mIsTemplateRending;
    private int fullScreenType;
    private TTAdManager mTTAdManager;
    private TTFullScreenVideoAd _fullScreenVideoAd;
    TTAdNative.FullScreenVideoAdListener fullScreenVideoAdListener = new TTAdNative.FullScreenVideoAdListener(){

        public void onError(int errorCode, String errorMsg) {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)("onError: " + errorCode + ":msg:" + errorMsg));
            if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ttFullScreenVideoAd) {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onFullScreenVideoAdLoad: ");
            ToutiaoInterstitialAdapter.this._fullScreenVideoAd = ttFullScreenVideoAd;
            if (ttFullScreenVideoAd != null) {
                ttFullScreenVideoAd.setFullScreenVideoAdInteractionListener(ToutiaoInterstitialAdapter.this.fullScreenVideoAdInteractionListener);
            }
            ToutiaoInterstitialAdapter.this.setFirstLoadedTime();
        }

        public void onFullScreenVideoCached() {
            if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onFullScreenVideoCached: ");
        }
    };
    TTFullScreenVideoAd.FullScreenVideoAdInteractionListener fullScreenVideoAdInteractionListener = new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener(){

        public void onAdShow() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShow: ");
            if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                ToutiaoInterstitialAdapter.this.mShowListener.onAdShown();
            }
        }

        public void onAdVideoBarClick() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdVideoBarClick: ");
            if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                ToutiaoInterstitialAdapter.this.mShowListener.onAdClicked();
            }
        }

        public void onAdClose() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClose: ");
            if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                ToutiaoInterstitialAdapter.this.mShowListener.onAdClosed();
            }
        }

        public void onVideoComplete() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onVideoComplete: ");
        }

        public void onSkippedVideo() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onSkippedVideo: ");
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.contextWeakReference = new WeakReference<Context>(context);
        if (context instanceof Application) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_ACTIVITY_ERROR);
            return;
        }
        this.toutiaoInterstitialCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        if (this.extrasAreValid(serverExtras)) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            this.fullScreenType = Integer.parseInt(serverExtras.get("full_screen_type"));
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        }
        this.toutiaoInterstitialCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        this.mLoadAdapterListener = this.toutiaoInterstitialCallbackRouter.getListener(this.placementId);
        if (this.mTTAdManager == null) {
            this.mTTAdManager = TTAdSdk.getAdManager();
        }
        if (this.ttAdNative == null) {
            this.ttAdNative = this.mTTAdManager.createAdNative(context);
        }
        if (!TTAdSdk.isInitSuccess() && !AppKeyManager.getInstance().isInited(this.appId, AppKeyManager.AdType.SHARE)) {
            PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    ToutiaoInterstitialAdapter.this.requestInterstitial(context);
                }

                public void onFailed(String code, String msg) {
                    if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                        TradPlusErrorCode tradPlusErrorCode = TradPlusErrorCode.INIT_FAILED;
                        tradPlusErrorCode.setCode(code + "");
                        tradPlusErrorCode.setErrormessage(msg);
                        ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tradPlusErrorCode);
                    }
                }
            });
        } else {
            this.requestInterstitial(context);
        }
    }

    private void requestInterstitial(Context context) {
        if (this.fullScreenType == 1) {
            this.intFullScreen(context);
        } else {
            this.initInsterstitial(context);
        }
    }

    private void initInsterstitial(Context context) {
        Log.i((String)TAG, (String)"initInsterstitial: \u63d2\u5c4f\u5e7f\u544a");
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setAdCount(1);
        Log.i((String)TAG, (String)("initInsterstitial: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 1) {
            builder.setExpressViewAcceptedSize(450.0f, 300.0f);
        }
        AdSlot adSlot = builder.build();
        this.ttAdNative.loadInteractionExpressAd(adSlot, (TTAdNative.NativeExpressAdListener)this);
    }

    private void intFullScreen(Context context) {
        Log.i((String)TAG, (String)"intFullScreen: \u5168\u5c4f\u89c6\u9891");
        int orientation = context.getResources().getConfiguration().orientation;
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setOrientation(orientation == 0 ? 2 : 1);
        Log.i((String)TAG, (String)("intFullScreen: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 1) {
            builder.setExpressViewAcceptedSize(500.0f, 500.0f);
        }
        AdSlot adSlot = builder.build();
        if (this.ttAdNative != null) {
            this.ttAdNative.loadFullScreenVideoAd(adSlot, this.fullScreenVideoAdListener);
        }
    }

    public void showAd() {
        Context context;
        Context _ct;
        if (this.toutiaoInterstitialCallbackRouter != null && this.mShowListener != null) {
            this.toutiaoInterstitialCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((_ct = TPContextUtils.getInstance((Context)(context = (Context)this.contextWeakReference.get())).compareContext(context)) == null) {
            if (this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId) != null) {
                this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId).onAdVideoError(TradPlusErrorCode.SHOW_FAILED);
            }
        } else if (this.fullScreenType == 1) {
            if (this._fullScreenVideoAd != null) {
                this._fullScreenVideoAd.showFullScreenVideoAd((Activity)_ct);
            } else if (this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId) != null) {
                this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId).onAdVideoError(TradPlusErrorCode.SHOW_FAILED);
            }
        } else if (this.ttNativeExpressAd != null) {
            this.ttNativeExpressAd.showInteractionExpressAd((Activity)_ct);
        } else if (this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId).onAdVideoError(TradPlusErrorCode.SHOW_FAILED);
        }
        this.mShowListener = this.toutiaoInterstitialCallbackRouter.getShowListener(this.placementId);
    }

    public void clean() {
        super.clean();
        if (this.ttNativeExpressAd != null) {
            this.ttNativeExpressAd.destroy();
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public void onError(int errorCode, String errorMsg) {
        Log.i((String)TAG, (String)("onError: " + errorCode + ":msg:" + errorMsg));
        if (this.toutiaoInterstitialCallbackRouter != null && this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
        }
    }

    public void onNativeExpressAdLoad(List<TTNativeExpressAd> ads) {
        if (ads == null || ads.size() == 0) {
            return;
        }
        this.ttNativeExpressAd = ads.get(0);
        this.bindAdListener(this.ttNativeExpressAd);
        this.ttNativeExpressAd.render();
    }

    private void bindAdListener(TTNativeExpressAd ad) {
        ad.setExpressInteractionListener(new TTNativeExpressAd.AdInteractionListener(){

            public void onAdDismiss() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdDismiss: ");
                if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                    ToutiaoInterstitialAdapter.this.mShowListener.onAdClosed();
                }
            }

            public void onAdClicked(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClicked: ");
                if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                    ToutiaoInterstitialAdapter.this.mShowListener.onAdClicked();
                }
            }

            public void onAdShow(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShow: ");
                if (ToutiaoInterstitialAdapter.this.mShowListener != null) {
                    ToutiaoInterstitialAdapter.this.mShowListener.onAdShown();
                }
            }

            public void onRenderFail(View view, String msg, int code) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onRenderFail: ");
                if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                    ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(code, msg));
                }
            }

            public void onRenderSuccess(View view, float width, float height) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onRenderSuccess: ");
                ToutiaoInterstitialAdapter.this.setFirstLoadedTime();
                if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                    ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }
        });
        if (ad.getInteractionType() != 4) {
            return;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        if (this.mTTAdManager != null) {
            return this.mTTAdManager.getSDKVersion();
        }
        return null;
    }
}

