/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdDislike;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.List;
import java.util.Map;

public class TouTiaoBanner
extends TPBannerAdapter {
    private Context mCxt;
    private String mAppId;
    private TTAdNative mAdNative;
    private String mPlacementId;
    private int viewWidth;
    private int viewHeight;
    private int bannerWidth;
    private int bannerHeight;
    private TTNativeExpressAd mTTAd;
    private TPBannerAdImpl mTpBannerAd;
    private Integer mAdSize;
    private TTAdManager adManager;
    private static final String TAG = "PangleBanner";
    TTNativeExpressAd.ExpressAdInteractionListener mExpressAdInteractionListener = new TTNativeExpressAd.ExpressAdInteractionListener(){

        public void onAdClicked(View view, int i) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onAdClicked: ");
            if (TouTiaoBanner.this.mTpBannerAd != null) {
                TouTiaoBanner.this.mTpBannerAd.adClicked();
            }
        }

        public void onAdShow(View view, int i) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onAdShow: ");
            if (TouTiaoBanner.this.mTpBannerAd != null) {
                TouTiaoBanner.this.mTpBannerAd.adShown();
            }
        }

        public void onRenderFail(View view, String errorMsg, int errorCode) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onRenderFail: ");
            if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onRenderSuccess(View view, float v, float v1) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onRenderSuccess: ");
            if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                RelativeLayout relativeLayout = new RelativeLayout(TouTiaoBanner.this.mCxt);
                relativeLayout.setGravity(17);
                relativeLayout.addView(view);
                TouTiaoBanner.this.mTpBannerAd = new TPBannerAdImpl(null, (View)relativeLayout);
                TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)TouTiaoBanner.this.mTpBannerAd);
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        String adm = null;
        if (tpParams != null && tpParams.size() > 0) {
            this.mAppId = tpParams.get("appId");
            this.mPlacementId = tpParams.get("placementId");
            adm = tpParams.get("Bidding-Payload");
            if (tpParams.get("ad_size" + this.mPlacementId) != null && !"0".equals(tpParams.get("ad_size" + this.mPlacementId))) {
                this.bannerWidth = Integer.valueOf(tpParams.get("ad_size_info_x" + this.mPlacementId));
                this.bannerHeight = Integer.valueOf(tpParams.get("ad_size_info_y" + this.mPlacementId));
            } else {
                this.bannerWidth = 640;
                this.bannerHeight = 100;
            }
            Log.i((String)TAG, (String)("width : " + this.bannerWidth + " , height : " + this.bannerHeight + "  , adm : " + adm));
        }
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("width")) {
                this.viewWidth = (Integer)userParams.get("width");
                this.viewWidth = DeviceUtils.px2dip((Context)context, (float)this.viewWidth);
            }
            if (userParams.containsKey("height")) {
                this.viewHeight = (Integer)userParams.get("height");
                this.viewHeight = DeviceUtils.px2dip((Context)context, (float)this.viewHeight);
            }
            Log.i((String)TAG, (String)("userParams: viewWidth :" + this.viewWidth + "\uff0cviewHeight :" + this.viewHeight));
        }
        this.adManager = TTAdSdk.getAdManager();
        this.mAdNative = this.adManager.createAdNative(this.mCxt);
        if (!TTAdSdk.isInitSuccess()) {
            final String ttAdm = adm;
            PangleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TouTiaoBanner.this.requestBanner(ttAdm);
                }

                public void onFailed(String code, String msg) {
                    if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestBanner(adm);
        }
    }

    private void requestBanner(String bidAdm) {
        AdSlot adSlot = new AdSlot.Builder().setCodeId(this.mPlacementId).setAdCount(1).withBid(bidAdm).setImageAcceptedSize(this.bannerWidth, this.bannerHeight).setExpressViewAcceptedSize(this.viewWidth <= 0 ? (float)(this.bannerWidth / 2) : (float)this.viewWidth, this.viewHeight <= 0 ? (float)(this.bannerHeight / 2) : (float)this.viewHeight).build();
        this.mAdNative.loadBannerExpressAd(adSlot, new TTAdNative.NativeExpressAdListener(){

            public void onError(int errorCode, String errorMsg) {
                Log.i((String)TouTiaoBanner.TAG, (String)("onError: errorCode : " + errorCode + ", errorMsg :" + errorMsg));
                if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                    TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                }
            }

            public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
                if (list == null || list.size() == 0) {
                    return;
                }
                TouTiaoBanner.this.mTTAd = list.get(0);
                TouTiaoBanner.this.mTTAd.setSlideIntervalTime(0);
                TouTiaoBanner.this.mTTAd.setExpressInteractionListener(TouTiaoBanner.this.mExpressAdInteractionListener);
                if (TouTiaoBanner.this.mCxt instanceof Activity) {
                    TouTiaoBanner.this.bindDislike((Activity)TouTiaoBanner.this.mCxt, TouTiaoBanner.this.mTTAd, false);
                }
                TouTiaoBanner.this.mTTAd.render();
            }
        });
    }

    private void bindDislike(Activity activity, TTNativeExpressAd ad, boolean customStyle) {
        ad.setDislikeCallback(activity, new TTAdDislike.DislikeInteractionCallback(){

            public void onSelected(int i, String s) {
                Log.i((String)TouTiaoBanner.TAG, (String)"onSelected: ");
                if (TouTiaoBanner.this.mTpBannerAd != null) {
                    TouTiaoBanner.this.mTpBannerAd.adClosed();
                }
            }

            public void onCancel() {
                Log.i((String)TouTiaoBanner.TAG, (String)"onCancel: ");
            }

            public void onRefuse() {
            }
        });
    }

    public void clean() {
        if (this.mTTAd != null) {
            this.mTTAd.setExpressInteractionListener(null);
            this.mTTAd.destroy();
            this.mTTAd = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams) {
        return TTAdSdk.getAdManager().getBiddingToken();
    }
}

