/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.util.OpenBackUpInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;

public class OpenLoadManager {
    public static final String OPEN_BACKUP = "open_backup";
    private static final int[] refreshTimeRelease = new int[]{1, 2, 4};
    private static OpenLoadManager mInstance;
    public static final int HOST_STATUS = 0;
    public static final int BACKUP_HOST_STATUS = 1;
    public static final int NETDISK_HOST_STATUS = 2;
    public static final int NORMAL_LOAD_SDK = 1;
    public static final int RELOAD_SDK = 2;
    private final long AUTO_LOAD_INTERVAL_TIME;
    private int loadErrorNum;
    private int domainStatus = 0;
    private String netdiskDomain;
    private int reloadOpenNum;
    private boolean cnServer = TPURLManager.getInstance().isCnServer();
    private int limitLoadErrorNum = 6;
    private OpenBackUpInfo openBackUpInfo;
    private Runnable reLoadRunnable = null;
    private boolean switchDomain = false;
    private int backupMsg = 0;
    private int netdiskMsg = 0;

    private OpenLoadManager() {
        OpenBackUpInfo openBackUpInfo;
        this.AUTO_LOAD_INTERVAL_TIME = 60000L;
        this.openBackUpInfo = openBackUpInfo = StoreManager.getOpenBackUpInfo(OPEN_BACKUP);
        if (openBackUpInfo != null) {
            OpenLoadManager openLoadManager = this;
            openLoadManager.loadErrorNum = openBackUpInfo.getError_num();
            openLoadManager.domainStatus = openLoadManager.openBackUpInfo.getDomain_status();
            openLoadManager.netdiskDomain = openLoadManager.openBackUpInfo.getDisk_domain();
        } else {
            OpenBackUpInfo openBackUpInfo2;
            openBackUpInfo = openBackUpInfo2;
            openBackUpInfo2 = new OpenBackUpInfo();
            this.openBackUpInfo = openBackUpInfo;
        }
        LogUtil.ownShow("OpenLoadManager initLocalParams cnServer == " + this.cnServer + ", openBackUpInfo == " + this.openBackUpInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized OpenLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<OpenLoadManager> clazz = OpenLoadManager.class;
        synchronized (OpenLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OpenLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void updateBackUpInfo() {
        int n = this.loadErrorNum;
        int n2 = this.limitLoadErrorNum;
        if (n == n2) {
            int n3 = this.domainStatus;
            if (n3 == 0) {
                this.domainStatus = 1;
            } else if (n3 == 1) {
                this.domainStatus = 2;
            }
        }
        if (n > n2) {
            this.loadErrorNum = 1;
        }
        OpenLoadManager openLoadManager = this;
        openLoadManager.openBackUpInfo.setDomain_status(this.domainStatus);
        openLoadManager.openBackUpInfo.setError_num(this.loadErrorNum);
        StoreManager.saveOpenBackUpInfo(OPEN_BACKUP, openLoadManager.openBackUpInfo);
        LogUtil.ownShow("updateBackUpInfo == " + this.openBackUpInfo);
    }

    private void checkNeedToRequestNetdisk() {
        if (this.loadErrorNum == this.limitLoadErrorNum && this.domainStatus == 2) {
            LogUtil.ownShow("\u8fbe\u5230\u5931\u8d25\u6b21\u6570\u4e0a\u9650 \u8bf7\u6c42\u7f51\u76d8 checkNeedToRequestNetdisk");
            TPRequestManager.getInstance().requestNetdiskDomain(new BaseHttpRequest.OnHttpLoaderListener(){

                public void loadSuccess(Object object) {
                    block11: {
                        block12: {
                            block10: {
                                if (object == null) {
                                    return;
                                }
                                LogUtil.ownShow("requestNetDisKDomain loadSuccess result == " + object.toString());
                                object = JSON.parseObject(object.toString());
                                if (object != null) break block10;
                                return;
                            }
                            if (!((JSONObject)object).containsKey("urlPath")) break block11;
                            2 v0 = this;
                            object = ((JSONObject)object).get("urlPath").toString();
                            if (TextUtils.isEmpty((CharSequence)v0.OpenLoadManager.this.netdiskDomain)) break block12;
                            if (OpenLoadManager.this.netdiskDomain.equals(object)) break block12;
                            OpenLoadManager.access$202(OpenLoadManager.this, true);
                        }
                        2 v1 = this;
                        2 v2 = v1;
                        OpenLoadManager.access$102(v1.OpenLoadManager.this, (String)object);
                        try {
                            OpenLoadManager openLoadManager = v2.OpenLoadManager.this;
                            openLoadManager.saveNetdiskDomain(openLoadManager.netdiskDomain);
                        }
                        catch (Throwable throwable) {
                            Log.i((String)OpenLoadManager.OPEN_BACKUP, (String)throwable.getLocalizedMessage());
                        }
                    }
                }

                @Override
                public void loadError(int n, String string) {
                    Log.i((String)OpenLoadManager.OPEN_BACKUP, (String)("loadError code: " + n + ",msg: " + string));
                }

                @Override
                public void loadCanceled() {
                }
            });
        }
    }

    private void saveNetdiskDomain(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        OpenLoadManager openLoadManager = this;
        openLoadManager.openBackUpInfo.setDisk_domain(string);
        StoreManager.saveOpenBackUpInfo(OPEN_BACKUP, openLoadManager.openBackUpInfo);
        LogUtil.ownShow("OpenLoadManager saveNetdiskDomain == " + this.openBackUpInfo);
    }

    static /* synthetic */ boolean access$202(OpenLoadManager openLoadManager, boolean bl) {
        openLoadManager.switchDomain = bl;
        return bl;
    }

    static /* synthetic */ String access$102(OpenLoadManager openLoadManager, String string) {
        openLoadManager.netdiskDomain = string;
        return string;
    }

    public String getNetdiskDomain() {
        return this.netdiskDomain;
    }

    public int getDomainSatus() {
        return this.domainStatus;
    }

    public void setServerLoadErrorNum(int n) {
        this.limitLoadErrorNum = n;
        LogUtil.ownShow("OpenLoadManager setServerLoadErrorNum == " + this.limitLoadErrorNum);
    }

    public void loadOpenFailed(boolean bl, int n) {
        LogUtil.ownShow("OpenLoadManager loadOpenFailed reloadOpenNum == " + this.reloadOpenNum);
        if (n == 2) {
            if (!this.cnServer && !bl) {
                OpenLoadManager openLoadManager = this;
                ++openLoadManager.loadErrorNum;
                openLoadManager.updateBackUpInfo();
                openLoadManager.checkNeedToRequestNetdisk();
            }
            if (this.reloadOpenNum < 3) {
                TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(this.reLoadRunnable, (long)refreshTimeRelease[this.reloadOpenNum] * 60000L);
            } else {
                this.removeCallBacks();
            }
        }
        if (this.reLoadRunnable == null) {
            this.reLoadRunnable = new Runnable(){

                @Override
                public void run() {
                    if (OpenLoadManager.this.reloadOpenNum < 3) {
                        OpenLoadManager.this.reloadOpenNum++;
                        try {
                            TradPlus.invoker().reLoadSDK();
                            LogUtil.ownShow("SDK\u521d\u59cb\u5316\u5931\u8d25 \u672c\u5730\u91cd\u8bd5\u6b21\u6570 == " + OpenLoadManager.this.reloadOpenNum);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            };
            TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(this.reLoadRunnable, (long)refreshTimeRelease[this.reloadOpenNum] * 60000L);
        }
    }

    public void removeCallBacks() {
        if (this.reLoadRunnable != null) {
            TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.reLoadRunnable);
        }
    }

    public void clearOpenBackUpInfo() {
        OpenLoadManager openLoadManager = this;
        openLoadManager.removeCallBacks();
        if (openLoadManager.cnServer) {
            return;
        }
        OpenLoadManager openLoadManager2 = this;
        openLoadManager2.loadErrorNum = 0;
        openLoadManager2.openBackUpInfo.setError_num(0);
        StoreManager.saveOpenBackUpInfo(OPEN_BACKUP, openLoadManager2.openBackUpInfo);
        LogUtil.ownShow("\u52a0\u8f7d\u6210\u529f clearOpenBackUpInfo == " + this.openBackUpInfo);
    }

    public void sendMessage(Context context) {
        if (!TextUtils.isEmpty((CharSequence)this.netdiskDomain)) {
            if (this.domainStatus == 2 && this.netdiskMsg == 0) {
                this.netdiskMsg = 1;
                SendMessageUtil.getInstance().sendOpenAPIBackUp(context, this.netdiskDomain);
            } else if (this.switchDomain) {
                this.switchDomain = false;
                SendMessageUtil.getInstance().sendOpenAPIBackUp(context, this.netdiskDomain);
            }
        } else if (this.backupMsg == 0) {
            this.backupMsg = 1;
            SendMessageUtil.getInstance().sendOpenAPIBackUp(context, "https://api.tpvisim.com/api/v1_2/open");
        }
    }
}

