/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.bean.TPImpCallbackInfo;
import com.tradplus.ads.base.bean.TPRewardCallbackInfo;
import com.tradplus.ads.base.common.OnCallbackPrintListener;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.network.TPUrlGenerator;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public class TPCallbackManager {
    public static final int CALLBACK_REWARD = 0;
    public static final int CALLBACK_IMP = 1;
    private static OnCallbackPrintListener onCallbackPrintListener;
    private String url;
    private int restartCount;
    private TPAdInfo tpAdInfo;
    private MyBaseHttp myBaseHttp;
    private ConfigResponse.WaterfallBean waterfallBean;
    private String unitId;
    private int callbackType;
    private Map<String, String> callbackParams;

    public TPCallbackManager(String string, int n, TPBaseAdapter tPBaseAdapter, TPAdInfo tPAdInfo) {
        TPCallbackManager tPCallbackManager = this;
        this.tpAdInfo = tPAdInfo;
        this.callbackType = n;
        this.unitId = string;
        tPCallbackManager.waterfallBean = tPBaseAdapter.getWaterfallBean();
        tPCallbackManager.url = tPCallbackManager.getCallbackUrl();
        n = tPCallbackManager.callbackType;
        if (n == 0) {
            this.callbackParams = JSON.parseObject(JSON.toJSONString(new TPRewardCallbackInfo(string, tPBaseAdapter, tPAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        } else if (n == 1) {
            this.callbackParams = JSON.parseObject(JSON.toJSONString(new TPImpCallbackInfo(string, tPBaseAdapter, tPAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        }
    }

    private void requestCallBack() {
        MyBaseHttp myBaseHttp;
        TPUrlGenerator tPUrlGenerator;
        TPUrlGenerator tPUrlGenerator2 = tPUrlGenerator;
        tPUrlGenerator2(GlobalTradPlus.getInstance().getContext());
        tPUrlGenerator.generateCallback(((TPCallbackManager)((Object)string)).callbackParams);
        if (((TPCallbackManager)((Object)string)).myBaseHttp == null) {
            MyBaseHttp myBaseHttp2;
            myBaseHttp = myBaseHttp2;
            myBaseHttp2 = (TPCallbackManager)((Object)string).new MyBaseHttp();
            ((TPCallbackManager)((Object)string)).myBaseHttp = myBaseHttp;
        }
        TPCallbackManager tPCallbackManager = string;
        String string = tPCallbackManager.url;
        myBaseHttp = tPCallbackManager.myBaseHttp;
        TPRequestManager.getInstance().requestCallback(string, tPUrlGenerator2, myBaseHttp);
    }

    public static void initOnCallbackPrintListener(OnCallbackPrintListener onCallbackPrintListener) {
        if (TPCallbackManager.onCallbackPrintListener != null) {
            return;
        }
        TPCallbackManager.onCallbackPrintListener = onCallbackPrintListener;
    }

    public static void setOnCallbackPrintListener(OnCallbackPrintListener onCallbackPrintListener) {
        TPCallbackManager.onCallbackPrintListener = onCallbackPrintListener;
    }

    public void startCallbackRequest(TPBaseAdapter tPBaseAdapter) {
        ConfigResponse configResponse = ConfigLoadManager.getInstance().getDefaultLocalConfigResponse(this.unitId);
        if (configResponse == null) {
            return;
        }
        int n = this.callbackType;
        if (n == 0) {
            if (configResponse.getIs_server_callback() == 0) {
                return;
            }
        } else if (n == 1) {
            OnCallbackPrintListener onCallbackPrintListener = TPCallbackManager.onCallbackPrintListener;
            if (onCallbackPrintListener != null && tPBaseAdapter != null) {
                try {
                    onCallbackPrintListener.onPrint(tPBaseAdapter, this.tpAdInfo);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (configResponse.getIs_server_imp_callback() == 0) {
                return;
            }
        }
        this.requestCallBack();
    }

    public String getCallbackUrl() {
        TPCallbackManager tPCallbackManager = object;
        Object object = "";
        int n = tPCallbackManager.callbackType;
        if (n == 0) {
            object = TPURLManager.getInstance().getRewardCallbackHost();
        } else if (n == 1) {
            object = TPURLManager.getInstance().getImpCallbackHost();
        }
        LogUtil.ownShow("callback url = " + (String)object);
        return object;
    }

    private class MyBaseHttp
    implements BaseHttpRequest.OnHttpLoaderListener {
        private MyBaseHttp() {
        }

        public void loadSuccess(Object object) {
        }

        @Override
        public void loadError(int n, String string) {
            MyBaseHttp myBaseHttp = this;
            myBaseHttp.TPCallbackManager.this.restartCount++;
            if (myBaseHttp.TPCallbackManager.this.restartCount <= 2) {
                TPCallbackManager.this.requestCallBack();
            }
        }

        @Override
        public void loadCanceled() {
        }
    }
}

