/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.TPConfigUtils;
import com.tradplus.ads.base.config.TradPlusConfigUtils;
import com.tradplus.ads.base.config.UserValueGroupManager;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.OnConfigListener;
import com.tradplus.ads.base.network.TPSettingManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.network.util.SplashSceneUtils;
import com.tradplus.ads.base.network.util.TradPlusConfigLoadUtils;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.common.serialization.JSON;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigLoadManager {
    private static final String CONFIG_AES_KEY = "tradplus";
    private static ConfigLoadManager mInstance;
    private ConcurrentHashMap<String, ConfigResponse> mConfigResponses;

    private ConfigLoadManager() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.mConfigResponses = concurrentHashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConfigLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ConfigLoadManager> clazz = ConfigLoadManager.class;
        synchronized (ConfigLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ConfigLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void setServerAutoLoad(ConfigResponse configResponse, String string) {
        if (configResponse == null) {
            return;
        }
        if (configResponse.getOpen_auto_load() == 0) {
            TPSettingManager.getInstance().setServerAutoLoad(string, false);
        } else {
            TPSettingManager.getInstance().setServerAutoLoad(string, true);
        }
    }

    private boolean checkConfigTimeout(Context object, final String string, ConfigResponse configResponse) {
        if (configResponse == null) {
            return true;
        }
        if (TradPlusConfigLoadUtils.isConfigExpires(configResponse.getCreateTime(), configResponse.getExpires()) && !TestDeviceUtil.getInstance().isTools()) {
            TradPlusConfigLoadUtils tradPlusConfigLoadUtils;
            final String string2 = UserValueGroupManager.getInstance(string).getConfigEcpmUid(configResponse);
            final TradPlusConfigLoadUtils tradPlusConfigLoadUtils2 = tradPlusConfigLoadUtils;
            Context context = object;
            ConfigResponse configResponse2 = configResponse;
            object = configResponse2.getResp_uid();
            long l = configResponse2.getResp_time();
            new TradPlusConfigLoadUtils(context, string, (String)object, l).setOnConfigListener(new OnConfigListener(){

                @Override
                public void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        2 v0 = this;
                        String string3 = UserValueGroupManager.getInstance(v0.string).getConfigEcpmUid(configResponse);
                        ConfigResponse configResponse2 = v0.ConfigLoadManager.this.getConfigResponses(string2);
                        v0.ConfigLoadManager.this.setServerAutoLoad(configResponse, string);
                        if (configResponse.getResp_uid() != null && configResponse2 != null && configResponse.getResp_uid().equals(configResponse2.getResp_uid())) {
                            configResponse2.setCreateTime(configResponse.getCreateTime());
                        } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                            ConfigLoadManager.this.putConfigResponses(string3, configResponse);
                        }
                    }
                }

                @Override
                public void onFailed(int n, String string3) {
                }
            });
            TPTaskManager.getInstance().runDyCorePool(new Runnable(){

                @Override
                public void run() {
                    TPDataManager.getInstance().getGaidM();
                    tradPlusConfigLoadUtils2.stillLoadConfig();
                }
            });
            return true;
        }
        return false;
    }

    private void putConfigResponses(String string, ConfigResponse configResponse) {
        if (SplashSceneUtils.getInstance().isSplashColdType(string) && configResponse.getScene_type() == 1) {
            string = SplashSceneUtils.getInstance().getSplashColdAdUnitId(string);
        }
        this.mConfigResponses.put(string, configResponse);
    }

    private ConfigResponse getConfigResponses(String string) {
        if (SplashSceneUtils.getInstance().isSplashColdType(string)) {
            string = SplashSceneUtils.getInstance().getSplashColdAdUnitId(string);
        }
        return this.mConfigResponses.get(string);
    }

    public void clearConfigResponse() {
        this.mConfigResponses.clear();
    }

    public ConfigResponse getLocalConfigResponse(String string) {
        ConfigResponse configResponse = this.getConfigResponses(string = UserValueGroupManager.getInstance(string).matchConfigByEcpmUid());
        if (configResponse != null) {
            return configResponse;
        }
        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (configResponse != null) {
            this.putConfigResponses(string, configResponse);
        }
        return configResponse;
    }

    public ConfigResponse getDefaultLocalConfigResponse(String string) {
        Object object = SplashSceneUtils.getInstance().isSplashColdType(string) ? SplashSceneUtils.getInstance().getSplashColdAdUnitId(string) : string;
        if ((object = this.getConfigResponses((String)object)) != null) {
            return object;
        }
        object = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (object != null) {
            this.putConfigResponses(string, (ConfigResponse)object);
        }
        return object;
    }

    public ConfigResponse getDefaultLocalConfigNotSecResponse(String string) {
        if (SplashSceneUtils.getInstance().isSplashType(string)) {
            ConfigResponse configResponse = this.getDefaultLocalConfigResponse(SplashSceneUtils.getInstance().getSplashColdAdUnitId(string));
            if (configResponse != null) {
                return configResponse;
            }
            configResponse = this.mConfigResponses.get(string);
            if (configResponse != null) {
                return configResponse;
            }
            configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
            if (configResponse != null) {
                this.putConfigResponses(string, configResponse);
            }
        }
        return this.getDefaultLocalConfigResponse(string);
    }

    public long getLocalRefreshTime(String string) {
        long l = 0L;
        ConfigResponse configResponse = this.getConfigResponses(string);
        if (configResponse != null) {
            return configResponse.getRefreshTime();
        }
        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (configResponse != null) {
            long l2 = configResponse.getRefreshTime();
            this.putConfigResponses(string, configResponse);
            return l2;
        }
        return l;
    }

    public ConfigResponse getMemoryConfigResponse(String string) {
        return this.getConfigResponses(UserValueGroupManager.getInstance(string).matchConfigByEcpmUid());
    }

    public void loadConfig(final String string, final ConfigLoadListener configLoadListener) {
        OnConfigListener onConfigListener;
        String string2 = string;
        final Context context = GlobalTradPlus.getInstance().getContext();
        TradPlus.invoker().checkTestMode();
        UserValueGroupManager.getInstance(string2).getUvaEcpm();
        Object object = this.getConfigResponses(UserValueGroupManager.getInstance(string2).matchConfigByEcpmUid());
        if (object != null && !TradPlusConfigUtils.isIsTestModeByConfig()) {
            configLoadListener.onSuccess((ConfigResponse)object);
            this.checkConfigTimeout(context, string, (ConfigResponse)object);
            return;
        }
        TradPlusConfigLoadUtils tradPlusConfigLoadUtils = new TradPlusConfigLoadUtils(context, string, "", 0L);
        object = onConfigListener;
        onConfigListener = new OnConfigListener(){

            @Override
            public void onSuccess(ConfigResponse configResponse) {
                1 v0 = string2;
                Object object = v0.context;
                string2.ConfigLoadManager.this.checkConfigTimeout(object, v0.string, configResponse);
                if (configResponse != null) {
                    object = configResponse.getFrequency();
                    NetWorkFrequencyUtils.getInstance().saveGroupFrequency((ConfigResponse.FrequencyBean)object, string2.string);
                    NetWorkFrequencyUtils.getInstance().saveServerConfigResponseLimit(configResponse, string2.string);
                    FrequencyUtils.getInstance().saveFrequency((ConfigResponse.FrequencyBean)object, string2.string);
                    string2.ConfigLoadManager.this.setServerAutoLoad(configResponse, string2.string);
                    if (configResponse.getIs_nothing() != 1) {
                        1 v1 = string2;
                        String string2 = UserValueGroupManager.getInstance(v1.string).getConfigEcpmUid(configResponse);
                        v1.ConfigLoadManager.this.putConfigResponses(string2, configResponse);
                        v1.configLoadListener.onSuccess(configResponse);
                    } else {
                        string2.configLoadListener.onFailed(10, "nothing response");
                    }
                } else {
                    string2.configLoadListener.onFailed(10, "response is null");
                }
            }

            @Override
            public void onFailed(int n, String string2) {
                configLoadListener.onFailed(n, string2);
            }
        };
        tradPlusConfigLoadUtils.setOnConfigListener((OnConfigListener)object);
        tradPlusConfigLoadUtils.load(true);
    }

    public void setDefaultConfig(String string, String object, String string2) {
        if (object != null && ((String)object).length() > 0) {
            block15: {
                Object object2;
                block14: {
                    String string3;
                    object2 = "";
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        string2 = object2;
                    }
                    Log.v((String)"ConfigLoadManager", (String)("setDefaultConfig iso---------" + string2));
                    if (this.getLocalConfigResponse(string) != null) {
                        return;
                    }
                    if (((String)object).contains("\n")) {
                        object = ((String)object).replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "");
                    }
                    object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
                    object2 = string3;
                    string3 = new String((byte[])object, "utf-8");
                    object = TPConfigUtils.getInstance().getIsoConfig(string2, (String)object2);
                    if (TextUtils.isEmpty((CharSequence)object)) break block14;
                    Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig deStr = v14901IsoConfig ========");
                    object2 = object;
                }
                String string4 = object2;
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig decode ========");
                object = JSON.parseObject(string4, ConfigResponse.class);
                if (object == null) break block15;
                ConfigLoadManager configLoadManager = this;
                String string5 = string;
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig success ========");
                try {
                    configLoadManager.putConfigResponses(string5, (ConfigResponse)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig error ==========");
                }
            }
            return;
        }
    }

    public String getCurrentConfig(String string) {
        if ((object2 = ((ConfigLoadManager)object2).getLocalConfigResponse(string)) == null) {
            return "";
        }
        Object object = object2;
        Object object2 = "";
        try {
            object2 = Base64.encodeToString((byte[])JSON.toJSONString(object).getBytes(), (int)0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    public void deleteColdConfigResponse(String string) {
        this.mConfigResponses.remove(string);
    }

    public static interface ConfigLoadListener {
        public void onSuccess(ConfigResponse var1);

        public void onFailed(int var1, String var2);
    }
}

