/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.bean.UserValueInfo;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.network.util.SplashSceneUtils;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.common.util.LogUtil;

public class TradPlusConfigUtils {
    private static TradPlusConfigUtils instance;
    private static boolean isTestModeByConfig;

    public static TradPlusConfigUtils getInstance() {
        if (instance == null) {
            instance = new TradPlusConfigUtils();
        }
        return instance;
    }

    public static boolean isIsTestModeByConfig() {
        return isTestModeByConfig;
    }

    public static void setIsTestModeByConfig(boolean bl) {
        if (bl) {
            StoreManager.clearConfigResponse();
            ConfigLoadManager.getInstance().clearConfigResponse();
        }
        isTestModeByConfig = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkConfigValid(ConfigResponse configResponse) {
        ConfigResponse.WaterfallBean waterfallBean;
        int n;
        if (configResponse == null) {
            return false;
        }
        boolean bl = true;
        if (configResponse.getWaterfall() != null) {
            for (n = 0; n < configResponse.getWaterfall().size(); ++n) {
                waterfallBean = configResponse.getWaterfall().get(n);
                if (!TextUtils.isEmpty((CharSequence)waterfallBean.getAdsource_placement_id()) && !TextUtils.isEmpty((CharSequence)waterfallBean.getCustomClassName()) && waterfallBean.checkConfigVaild()) continue;
                bl = false;
                break;
            }
        }
        if (configResponse.getBiddingwaterfall() != null) {
            for (n = 0; n < configResponse.getBiddingwaterfall().size(); ++n) {
                waterfallBean = configResponse.getBiddingwaterfall().get(n);
                if (!TextUtils.isEmpty((CharSequence)waterfallBean.getAdsource_placement_id()) && !TextUtils.isEmpty((CharSequence)waterfallBean.getCustomClassName()) && waterfallBean.checkConfigVaild()) continue;
                bl = false;
                break;
            }
        }
        LogUtil.ownShow("save config to local = " + bl);
        return bl;
    }

    public ConfigResponse getConfigByUnitId(String object) {
        if (SplashSceneUtils.getInstance().isSplashColdType((String)object) && StoreManager.getLocalConfigResponse((String)(this = SplashSceneUtils.getInstance().getSplashColdAdUnitId((String)object)), true) != null) {
            object = this;
        }
        if ((this = StoreManager.getLocalConfigResponse((String)object, true)) == null) {
            return null;
        }
        if ((TPDataManager.getInstance().isDebugMode() || TradPlusConfigUtils.isIsTestModeByConfig()) && !TestDeviceUtil.getInstance().isTools()) {
            return null;
        }
        return this;
    }

    public void setConfigByUnitId(String string, ConfigResponse configResponse) {
        if (configResponse.getIs_test_mode() == 1) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (SplashSceneUtils.getInstance().isSplashColdType(string) && configResponse.getScene_type() == 1) {
            string = string + "_1";
        }
        StoreManager.saveConfigResponse(string, configResponse);
    }

    public void deleteConfigByUnitId(String string) {
        String string2 = SplashSceneUtils.getInstance().getSplashColdAdUnitId(string);
        ConfigLoadManager.getInstance().deleteColdConfigResponse(string2);
        StoreManager.deleteConfigResponse(string2);
    }

    public UserValueInfo getUvaConfigByUnitId(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return StoreManager.getUvaConfigByUid(string);
    }

    public void setUvaConfigByUnitId(String string, UserValueInfo userValueInfo) {
        if (userValueInfo != null && !TextUtils.isEmpty((CharSequence)string)) {
            StoreManager.saveUvaConfig(string, userValueInfo);
            return;
        }
    }

    public void deleteUvaConfig(String string) {
        StoreManager.deleteUvaConfig(string);
    }

    public TPOpenResponse getOpenByUnitId(Context context, int n) {
        TPOpenResponse tPOpenResponse = StoreManager.getLocalTPOpenResponse(true);
        if (TPDataManager.getInstance().isDebugMode()) {
            return null;
        }
        return tPOpenResponse;
    }

    public void setOpenByUnitId(Context context, TPOpenResponse tPOpenResponse, int n) {
        StoreManager.saveTPOpenResponse(tPOpenResponse);
    }
}

