/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import com.tradplus.ads.base.db.MemoryCacheManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.db.entity.AdImpEcpm;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.common.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class UserImpEcpmManager {
    private static ConcurrentHashMap<String, UserImpEcpmManager> uvaManagerMap = new ConcurrentHashMap();
    private boolean isOpen;
    private String mAdUnitId;
    private boolean isDelete = false;

    private UserImpEcpmManager(String string) {
        this.mAdUnitId = string;
    }

    public static synchronized UserImpEcpmManager getInstance(String string) {
        UserImpEcpmManager userImpEcpmManager = uvaManagerMap.get(string);
        if (userImpEcpmManager == null) {
            UserImpEcpmManager userImpEcpmManager2;
            userImpEcpmManager = userImpEcpmManager2;
            new UserImpEcpmManager(string).initData();
            uvaManagerMap.put(string, userImpEcpmManager);
        }
        return userImpEcpmManager;
    }

    private void initData() {
        TPOpenResponse tPOpenResponse = StoreManager.getLocalTPOpenResponse(true);
        if (tPOpenResponse == null) {
            return;
        }
        this.isOpen = tPOpenResponse.isFirstPartyDataApi();
    }

    private float calculateMedian(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        Arrays.sort(objectArray2);
        return ((Float)objectArray[objectArray2.length / 2]).floatValue();
    }

    private List<Float> getWeekEcpmList() {
        ArrayList<Float> arrayList;
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        ArrayList<Float> arrayList2 = arrayList;
        arrayList = new ArrayList<Float>();
        for (int i = 0; i < 7; ++i) {
            if (i > 0) {
                calendar.add(6, -1);
            }
            long l = calendar.getTime().getTime();
            AdImpEcpm adImpEcpm = MemoryCacheManager.getInstance().getAdImpEcpm(this.mAdUnitId + "_" + simpleDateFormat2.format(new Date(l)));
            if (adImpEcpm.getImpEcpmList() != null) {
                arrayList2.addAll(0, adImpEcpm.getImpEcpmList());
            }
            if (arrayList2.size() >= AdImpEcpm.getMaxCount()) break;
        }
        if (arrayList2.size() > AdImpEcpm.getMaxCount()) {
            ArrayList<Float> arrayList3 = arrayList2;
            int n = arrayList3.size() - AdImpEcpm.getMaxCount();
            return arrayList3.subList(n, arrayList3.size());
        }
        return arrayList2;
    }

    private void deleteHistoryWeekEcpmList() {
        if (this.isDelete) {
            return;
        }
        this.isDelete = true;
        new Thread(() -> {
            SimpleDateFormat simpleDateFormat;
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            for (int i = 0; i < 365; ++i) {
                Calendar calendar2 = calendar;
                calendar2.add(6, -7 - i);
                long l = calendar2.getTime().getTime();
                MemoryCacheManager.getInstance().deleteAdImpEcpm(this.mAdUnitId + "_" + simpleDateFormat2.format(new Date(l)));
            }
        }).start();
    }

    public void test() {
        for (int i = 0; i < 10; ++i) {
            int n = new Random().nextInt(10) + 1;
            double d = n > 0 ? (double)n : (double)n / -1.0;
            this.saveAdImpEcpm(d);
        }
        this.getAdImpEcpm();
    }

    public void saveAdImpEcpm(double d) {
        UserImpEcpmManager userImpEcpmManager = string;
        userImpEcpmManager.deleteHistoryWeekEcpmList();
        if (!userImpEcpmManager.isOpen) {
            return;
        }
        String string = ((UserImpEcpmManager)((Object)string)).mAdUnitId + "_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        AdImpEcpm adImpEcpm = MemoryCacheManager.getInstance().getAdImpEcpm(string);
        adImpEcpm.addImpEcpm((float)d);
        MemoryCacheManager.getInstance().saveAdImpEcpm(string, adImpEcpm);
        LogUtil.ownShow("saveAdImpEcpm  key:" + (String)string + " ,ecpm:" + d);
    }

    public HashMap<String, Float> getAdImpEcpm() {
        HashMap hashMap;
        if (!((UserImpEcpmManager)((Object)hashMap2)).isOpen) {
            return new HashMap<String, Float>();
        }
        List<Float> list = ((UserImpEcpmManager)((Object)hashMap2)).getWeekEcpmList();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (float f4 : list) {
            LogUtil.ownShow("for end adImpEcpmList  weekEcpm:" + f4);
            f += f4;
        }
        if (!list.isEmpty()) {
            f2 = ((UserImpEcpmManager)((Object)hashMap2)).calculateMedian(list.toArray());
            f3 = f / (float)list.size();
        }
        LogUtil.ownShow("getAdImpEcpm  sumEcpm:" + f + " ,median:" + f2 + " ,average:" + f3);
        HashMap<String, Float> hashMap2 = hashMap;
        hashMap2();
        hashMap2.put("l7d_iaa_rev_x1000_total", Float.valueOf(f));
        hashMap2.put("l7d_iaa_rev_x1000_median", Float.valueOf(f2));
        hashMap.put("l7d_iaa_rev_x1000_mean", Float.valueOf(f3));
        return hashMap;
    }
}

