/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.bean.UserValueInfo;
import com.tradplus.ads.base.db.DBStoreProvider;
import com.tradplus.ads.base.db.api.cache.Store;
import com.tradplus.ads.base.db.api.cache.StoreProvider;
import com.tradplus.ads.base.db.entity.AdSourceFrenquency;
import com.tradplus.ads.base.db.entity.AdUnitConfig;
import com.tradplus.ads.base.db.entity.AdUnitFrenquency;
import com.tradplus.ads.base.db.entity.Event;
import com.tradplus.ads.base.db.entity.EventAdx;
import com.tradplus.ads.base.db.entity.EventCross;
import com.tradplus.ads.base.db.entity.EventSimplify;
import com.tradplus.ads.base.db.entity.KVEntity;
import com.tradplus.ads.base.db.entity.OpenBackUp;
import com.tradplus.ads.base.db.entity.Tracks;
import com.tradplus.ads.base.db.entity.UvaEcpmConfig;
import com.tradplus.ads.base.event.push.LocalEventUtil;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.util.OpenBackUpInfo;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoreManager {
    private static volatile StoreProvider<String> storeProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Context context) {
        if (storeProvider != null) return;
        Class<StoreManager> clazz = StoreManager.class;
        synchronized (StoreManager.class) {
            if (storeProvider != null) return;
            storeProvider = DBStoreProvider.create(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static <T> Store<String, T> getStore(Class<T> clazz) {
        if (storeProvider == null) {
            StoreManager.init(GlobalTradPlus.getInstance().getContext());
        }
        return storeProvider.getStore(clazz);
    }

    public static String getVersionName() {
        return "15.0.20.1";
    }

    public static boolean checkVersion(String string) {
        return StoreManager.getVersionName().compareTo(string) != 0;
    }

    private static String toJson(Object object) {
        if (object instanceof JSONObject) {
            return object.toString();
        }
        return JSONHelper.toJSON(object);
    }

    private static <T> T fromJson(String string, Class<T> clazz) {
        return JSONHelper.fromJson(string, clazz);
    }

    public static AdUnitFrenquency getAdUnitFrenquency(String string) {
        return StoreManager.getStore(AdUnitFrenquency.class).get(string);
    }

    public static AdSourceFrenquency getAdSourceFrenquency(String string) {
        return StoreManager.getStore(AdSourceFrenquency.class).get(string);
    }

    public static void deleteAdUnitFrenquency(String string) {
        StoreManager.getStore(AdUnitFrenquency.class).delete((String[])new String[]{string});
    }

    public static void deleteAdSourceFrenquency(String string) {
        StoreManager.getStore(AdSourceFrenquency.class).delete((String[])new String[]{string});
    }

    public static void saveConfigResponse(String string, ConfigResponse configResponse) {
        AdUnitConfig adUnitConfig;
        AdUnitConfig adUnitConfig2;
        AdUnitConfig adUnitConfig3 = adUnitConfig2 = adUnitConfig;
        adUnitConfig2();
        adUnitConfig3.setId(string);
        adUnitConfig3.setVersion_name(StoreManager.getVersionName());
        adUnitConfig.setBean(StoreManager.toJson(configResponse));
        StoreManager.getStore(AdUnitConfig.class).save((AdUnitConfig[])new AdUnitConfig[]{adUnitConfig2});
    }

    public static ConfigResponse getLocalConfigResponse(String object, boolean bl) {
        object = StoreManager.getStore(AdUnitConfig.class).get((String)object);
        if (!(object == null || bl && StoreManager.checkVersion(((AdUnitConfig)object).getVersion_name()))) {
            return StoreManager.fromJson(((AdUnitConfig)object).getBean(), ConfigResponse.class);
        }
        return null;
    }

    public static void clearConfigResponse() {
        StoreManager.getStore(AdUnitConfig.class).clear();
    }

    public static void deleteConfigResponse(String string) {
        StoreManager.getStore(AdUnitConfig.class).delete((String[])new String[]{string});
    }

    public static void saveUvaConfig(String string, UserValueInfo userValueInfo) {
        UvaEcpmConfig uvaEcpmConfig;
        UvaEcpmConfig uvaEcpmConfig2 = uvaEcpmConfig;
        uvaEcpmConfig2();
        uvaEcpmConfig2.setId(string);
        uvaEcpmConfig2.setShow_ecpm(StoreManager.toJson(userValueInfo.getImpressionEcpm()));
        uvaEcpmConfig2.setUva_ecpm(String.valueOf(userValueInfo.getUvaEcpm()));
        uvaEcpmConfig.setBean(StoreManager.toJson(userValueInfo));
        StoreManager.getStore(UvaEcpmConfig.class).save((UvaEcpmConfig[])new UvaEcpmConfig[]{uvaEcpmConfig2});
    }

    public static UserValueInfo getUvaConfigByUid(String object) {
        object = StoreManager.getStore(UvaEcpmConfig.class).get((String)object);
        if (object == null) {
            return null;
        }
        return StoreManager.fromJson(((UvaEcpmConfig)object).getBean(), UserValueInfo.class);
    }

    public static void clearUvaConfig() {
        Store<String, UvaEcpmConfig> store = StoreManager.getStore(UvaEcpmConfig.class);
        if (store == null) {
            return;
        }
        store.clear();
    }

    public static void deleteUvaConfig(String string) {
        String[] stringArray = StoreManager.getStore(UvaEcpmConfig.class);
        if (stringArray == null) {
            return;
        }
        if (stringArray.get((String)string) == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        String[] stringArray3 = new String[1];
        stringArray = stringArray3;
        stringArray3[0] = string;
        stringArray2.delete(stringArray);
    }

    public static void saveKeyEntity(String string, String string2) {
        KVEntity kVEntity;
        KVEntity kVEntity2 = kVEntity;
        kVEntity2();
        kVEntity2.setKey(string);
        kVEntity2.setValue(string2);
        kVEntity.setType(string);
        StoreManager.getStore(KVEntity.class).save((KVEntity[])new KVEntity[]{kVEntity2});
    }

    public static String getLocalKeyEntity(String object) {
        object = StoreManager.getStore(KVEntity.class).get((String)object);
        object = object == null ? null : ((KVEntity)object).getValue();
        if (object == null) {
            return null;
        }
        return object;
    }

    public static void saveTPOpenResponse(TPOpenResponse tPOpenResponse) {
        KVEntity kVEntity;
        TPOpenResponse tPOpenResponse2 = tPOpenResponse;
        tPOpenResponse2.setCreate_time(System.currentTimeMillis());
        tPOpenResponse2.setVersion_name(StoreManager.getVersionName());
        KVEntity kVEntity2 = kVEntity;
        kVEntity2();
        kVEntity2.setKey(tPOpenResponse.getClass().getName());
        kVEntity2.setValue(StoreManager.toJson(tPOpenResponse));
        kVEntity.setType(tPOpenResponse.getClass().getName());
        StoreManager.getStore(KVEntity.class).save((KVEntity[])new KVEntity[]{kVEntity2});
    }

    public static TPOpenResponse getLocalTPOpenResponse(boolean bl) {
        block8: {
            Object object;
            block7: {
                block6: {
                    try {
                        object = StoreManager.getStore(KVEntity.class).get(TPOpenResponse.class.getName());
                        if (object != null) break block6;
                        object = null;
                        break block7;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                object = StoreManager.fromJson(((KVEntity)object).getValue(), TPOpenResponse.class);
            }
            if (object != null) {
                if (bl) {
                    if (StoreManager.checkVersion(((TPOpenResponse)object).getVersion_name())) break block8;
                }
                return object;
            }
        }
        return null;
    }

    public static void saveOpenBackUpInfo(String string, OpenBackUpInfo openBackUpInfo) {
        OpenBackUp openBackUp;
        OpenBackUp openBackUp2 = openBackUp;
        openBackUp2();
        openBackUp2.setId(string);
        openBackUp2.setError_num(String.valueOf(openBackUpInfo.getError_num()));
        openBackUp2.setDisk_domain(openBackUpInfo.getDisk_domain());
        openBackUp.setDomain_status(String.valueOf(openBackUpInfo.getDomain_status()));
        openBackUp.setBean(StoreManager.toJson(openBackUp));
        StoreManager.getStore(OpenBackUp.class).save((OpenBackUp[])new OpenBackUp[]{openBackUp2});
    }

    public static OpenBackUpInfo getOpenBackUpInfo(String object) {
        object = StoreManager.getStore(OpenBackUp.class).get((String)object);
        if (object == null) {
            return null;
        }
        return StoreManager.fromJson(((OpenBackUp)object).getBean(), OpenBackUpInfo.class);
    }

    public static Pair<String[], String[]> getEvent(int n) {
        List<Event> list = StoreManager.getStore(Event.class).getList(n);
        if (list != null && list.size() != 0) {
            Pair pair;
            LocalEventUtil.getInstance().saveEvent(list);
            int n2 = list.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            Pair pair2 = pair;
            pair = new Pair((Object)stringArray, (Object)stringArray2);
            for (int i = 0; i < n2; ++i) {
                Event event = list.get(i);
                stringArray[i] = event.getId();
                stringArray2[i] = event.getContent();
            }
            return pair2;
        }
        return null;
    }

    public static Pair<String[], String[]> getSimplifyEvent(int n) {
        List<EventSimplify> list = StoreManager.getStore(EventSimplify.class).getList(n);
        if (list != null && list.size() != 0) {
            Pair pair;
            LocalEventUtil.getInstance().saveEventSimplify(list);
            int n2 = list.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            Pair pair2 = pair;
            pair = new Pair((Object)stringArray, (Object)stringArray2);
            for (int i = 0; i < n2; ++i) {
                EventSimplify eventSimplify = list.get(i);
                stringArray[i] = eventSimplify.getId();
                stringArray2[i] = eventSimplify.getContent();
            }
            return pair2;
        }
        return null;
    }

    public static int getEventCount() {
        return StoreManager.getStore(Event.class).count();
    }

    public static int getSimplifyEventCount() {
        return StoreManager.getStore(EventSimplify.class).count();
    }

    public static void clearEvent() {
        StoreManager.getStore(Event.class).clear();
    }

    public static void clearSimplifyEvent() {
        StoreManager.getStore(EventSimplify.class).clear();
    }

    public static void removeEvent(String[] stringArray) {
        StoreManager.getStore(Event.class).delete((String[])stringArray);
    }

    public static void removeSimplifyEvent(String[] stringArray) {
        StoreManager.getStore(EventSimplify.class).delete((String[])stringArray);
    }

    public static void clearAll() {
        StoreManager.clearEvent();
        StoreManager.clearCrossEvent();
        StoreManager.clearAdxEvent();
        StoreManager.clearSimplifyEvent();
    }

    public static void saveEvent(BaseRequest baseRequest) {
        if (baseRequest == null) {
            return;
        }
        Event event = new Event();
        event.setId(UUID.randomUUID().toString());
        event.setContent(StoreManager.toJson(baseRequest));
        StoreManager.saveEvent(event);
    }

    public static void saveEvent(Event event) {
        if (event == null) {
            return;
        }
        StoreManager.getStore(Event.class).save((Event[])new Event[]{event});
    }

    public static void saveSimplifyEvent(SimplifyEvent simplifyEvent) {
        if (simplifyEvent == null) {
            return;
        }
        EventSimplify eventSimplify = new EventSimplify();
        eventSimplify.setId(UUID.randomUUID().toString());
        eventSimplify.setContent(StoreManager.toJson(simplifyEvent));
        StoreManager.saveSimplifyEvent(eventSimplify);
    }

    public static void saveSimplifyEvent(EventSimplify eventSimplify) {
        if (eventSimplify == null) {
            return;
        }
        StoreManager.getStore(EventSimplify.class).save((EventSimplify[])new EventSimplify[]{eventSimplify});
    }

    public static Pair<String[], String[]> saveEventJSONArray(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            int n = jSONArray.length();
            Event[] eventArray = new Event[n];
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                Event event;
                Event event2;
                Event event3 = event2 = event;
                event3();
                event3.setId(UUID.randomUUID().toString());
                stringArray[i] = event3.getId();
                try {
                    event.setContent(StoreManager.toJson(jSONArray.get(i)));
                }
                catch (Exception exception) {}
                stringArray2[i] = event2.getContent();
                eventArray[i] = event2;
            }
            StoreManager.getStore(Event.class).save((Event[])eventArray);
            return new Pair((Object)stringArray, (Object)stringArray2);
        }
        return null;
    }

    public static Pair<String[], String[]> saveSimplifyEventJSONArray(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            int n = jSONArray.length();
            EventSimplify[] eventSimplifyArray = new EventSimplify[n];
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                EventSimplify eventSimplify;
                EventSimplify eventSimplify2;
                EventSimplify eventSimplify3 = eventSimplify2 = eventSimplify;
                eventSimplify3();
                eventSimplify3.setId(UUID.randomUUID().toString());
                stringArray[i] = eventSimplify3.getId();
                try {
                    eventSimplify.setContent(StoreManager.toJson(jSONArray.get(i)));
                }
                catch (Exception exception) {}
                stringArray2[i] = eventSimplify2.getContent();
                eventSimplifyArray[i] = eventSimplify2;
            }
            StoreManager.getStore(EventSimplify.class).save((EventSimplify[])eventSimplifyArray);
            return new Pair((Object)stringArray, (Object)stringArray2);
        }
        return null;
    }

    public static Pair<String[], String[]> getEventCross(int n) {
        List<EventCross> list = StoreManager.getStore(EventCross.class).getList(n);
        if (list != null && list.size() != 0) {
            Pair pair;
            LocalEventUtil.getInstance().saveEventCross(list);
            int n2 = list.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            Pair pair2 = pair;
            pair = new Pair((Object)stringArray, (Object)stringArray2);
            for (int i = 0; i < n2; ++i) {
                EventCross eventCross = list.get(i);
                stringArray[i] = eventCross.getId();
                stringArray2[i] = eventCross.getContent();
            }
            return pair2;
        }
        return null;
    }

    public static int getEventCountCross() {
        return StoreManager.getStore(EventCross.class).count();
    }

    public static void saveCrossEvent(EventBaseRequest eventBaseRequest) {
        if (eventBaseRequest == null) {
            return;
        }
        EventCross eventCross = new EventCross();
        eventCross.setId(UUID.randomUUID().toString());
        eventCross.setContent(StoreManager.toJson(eventBaseRequest));
        StoreManager.saveCrossEvent(eventCross);
    }

    public static void saveCrossEvent(EventCross eventCross) {
        StoreManager.getStore(EventCross.class).save((EventCross[])new EventCross[]{eventCross});
    }

    public static void clearCrossEvent() {
        StoreManager.getStore(EventCross.class).clear();
    }

    public static Pair<String[], String[]> saveCrossEventJSONArray(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            JSONArray jSONArray2 = jSONArray;
            int n = jSONArray2.length();
            EventCross[] eventCrossArray = new EventCross[jSONArray.length()];
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int n2 = jSONArray2.length();
            for (int i = 0; i < n2; ++i) {
                EventCross eventCross;
                EventCross eventCross2;
                EventCross eventCross3 = eventCross2 = eventCross;
                eventCross3();
                eventCross3.setId(UUID.randomUUID().toString());
                stringArray[i] = eventCross3.getId();
                try {
                    eventCross.setContent(StoreManager.toJson(jSONArray.get(i)));
                }
                catch (Exception exception) {}
                stringArray2[i] = eventCross2.getContent();
                eventCrossArray[i] = eventCross2;
            }
            StoreManager.getStore(EventCross.class).save((EventCross[])eventCrossArray);
            return new Pair((Object)stringArray, (Object)stringArray2);
        }
        return null;
    }

    public static void removeCrossEvent(String[] stringArray) {
        StoreManager.getStore(EventCross.class).delete((String[])stringArray);
    }

    public static Pair<String[], String[]> getEventAdx(int n) {
        List<EventAdx> list = StoreManager.getStore(EventAdx.class).getList(n);
        if (list != null && list.size() != 0) {
            Pair pair;
            LocalEventUtil.getInstance().saveEventAdx(list);
            int n2 = list.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            Pair pair2 = pair;
            pair = new Pair((Object)stringArray, (Object)stringArray2);
            for (int i = 0; i < n2; ++i) {
                EventAdx eventAdx = list.get(i);
                stringArray[i] = eventAdx.getId();
                stringArray2[i] = eventAdx.getContent();
            }
            return pair2;
        }
        return null;
    }

    public static int getEventCountAdx() {
        return StoreManager.getStore(EventAdx.class).count();
    }

    public static void saveAdxEvent(Object object) {
        if (object == null) {
            return;
        }
        EventAdx eventAdx = new EventAdx();
        eventAdx.setId(UUID.randomUUID().toString());
        eventAdx.setContent(StoreManager.toJson(object));
        StoreManager.saveAdxEvent(eventAdx);
    }

    public static void saveAdxEvent(EventAdx eventAdx) {
        if (eventAdx == null) {
            return;
        }
        StoreManager.getStore(EventAdx.class).save((EventAdx[])new EventAdx[]{eventAdx});
    }

    public static void clearAdxEvent() {
        StoreManager.getStore(EventAdx.class).clear();
    }

    public static Pair<String[], String[]> saveAdxEventJSONArray(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            JSONArray jSONArray2 = jSONArray;
            int n = jSONArray2.length();
            EventAdx[] eventAdxArray = new EventAdx[jSONArray.length()];
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int n2 = jSONArray2.length();
            for (int i = 0; i < n2; ++i) {
                EventAdx eventAdx;
                EventAdx eventAdx2;
                EventAdx eventAdx3 = eventAdx2 = eventAdx;
                eventAdx3();
                eventAdx3.setId(UUID.randomUUID().toString());
                stringArray[i] = eventAdx3.getId();
                try {
                    eventAdx.setContent(StoreManager.toJson(jSONArray.get(i)));
                }
                catch (Exception exception) {}
                stringArray2[i] = eventAdx2.getContent();
                eventAdxArray[i] = eventAdx2;
            }
            StoreManager.getStore(EventAdx.class).save((EventAdx[])eventAdxArray);
            return new Pair((Object)stringArray, (Object)stringArray2);
        }
        return null;
    }

    public static void removeAdxEvent(String[] stringArray) {
        StoreManager.getStore(EventAdx.class).delete((String[])stringArray);
    }

    public static void saveTrack(Pair<String[], String[]> pair) {
        int n = ((String[])pair.first).length;
        Tracks[] tracksArray = new Tracks[n];
        for (int i = 0; i < n; ++i) {
            Tracks tracks;
            Tracks tracks2 = tracks;
            tracks2();
            tracks2.setId(((String[])pair.first)[i]);
            tracks.setUrl(((String[])pair.first)[i]);
            Object object = pair.second;
            if (object != null) {
                tracks2.setContent(((String[])object)[i]);
            }
            tracksArray[i] = tracks2;
        }
        StoreManager.getStore(Tracks.class).save((Tracks[])tracksArray);
    }

    public static void removeTracks(String string) {
        StoreManager.getStore(Tracks.class).delete((String[])new String[]{string});
    }

    public static String getTracksContent(String object) {
        object = StoreManager.getStore(Tracks.class).get((String)object);
        if (object != null && !TextUtils.isEmpty((CharSequence)((Tracks)object).getContent())) {
            return ((Tracks)object).getContent();
        }
        return null;
    }

    public static Pair<String[], String[]> getTracksContent(int n) {
        List<Tracks> list = StoreManager.getStore(Tracks.class).getList(n);
        if (list != null && list.size() != 0) {
            int n2 = list.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                Tracks tracks = list.get(i);
                stringArray[i] = tracks.getId();
                stringArray2[i] = tracks.getContent();
            }
            return new Pair((Object)stringArray, (Object)stringArray2);
        }
        return null;
    }
}

