/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.text.TextUtils;
import com.tradplus.ads.base.db.MemoryCacheManager;
import com.tradplus.ads.base.db.entity.AdSourceFrenquency;
import com.tradplus.ads.base.db.entity.AdUnitFrenquency;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DateAndTime;
import com.tradplus.ads.common.util.LogUtil;

public class TPFrequencyManager {
    private static TPFrequencyManager mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized TPFrequencyManager getInstance() {
        if (mInstance == null) {
            Class<TPFrequencyManager> clazz = TPFrequencyManager.class;
            synchronized (TPFrequencyManager.class) {
                mInstance = new TPFrequencyManager();
            }
        }
        return mInstance;
    }

    public static void addNetworkIdFrequencyShowCount(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        AdUnitFrenquency adUnitFrenquency = MemoryCacheManager.getInstance().getAdUnitFrenquency(string);
        String string2 = DateAndTime.getDate(0);
        if (adUnitFrenquency == null) {
            AdUnitFrenquency adUnitFrenquency2;
            adUnitFrenquency = adUnitFrenquency2;
            adUnitFrenquency();
            adUnitFrenquency.setId(string);
            adUnitFrenquency2.setShow_time(Integer.parseInt(string2));
        } else if (!string2.equals(String.valueOf(adUnitFrenquency.getShow_time()))) {
            adUnitFrenquency.setShow_count(0);
            adUnitFrenquency.setShow_time(Integer.parseInt(string2));
        }
        AdUnitFrenquency adUnitFrenquency3 = adUnitFrenquency;
        adUnitFrenquency3.setShow_count(adUnitFrenquency3.getShow_count() + 1);
        MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
    }

    public static int checkNetworkIdFrequencyShowCount(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        AdUnitFrenquency adUnitFrenquency = TPFrequencyManager.getAdUnitFrenquency(string);
        String string2 = DateAndTime.getDate(0);
        if (adUnitFrenquency == null) {
            return 0;
        }
        if (!string2.equals(String.valueOf(adUnitFrenquency.getShow_time()))) {
            adUnitFrenquency.setShow_count(0);
            adUnitFrenquency.setShow_time(Integer.parseInt(string2));
            MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
        }
        LogUtil.ownShow("TPFrequencyManager adSourceFrequency - save networkId \uff1a" + string + " == " + adUnitFrenquency.toString(), "TPFrequency");
        return adUnitFrenquency.getShow_count();
    }

    public static void saveFrequency(String string, ConfigResponse.FrequencyBean frequencyBean) {
        AdUnitFrenquency adUnitFrenquency = TPFrequencyManager.getAdUnitFrenquency(string);
        if (frequencyBean == null) {
            if (adUnitFrenquency != null) {
                MemoryCacheManager.getInstance().deleteAdUnitFrenquency(string);
            }
            return;
        }
        if (frequencyBean.getCapping_day() <= 0 && frequencyBean.getCapping_hour() <= 0 && frequencyBean.getPacing_min() <= 0) {
            long l = System.currentTimeMillis();
            if (adUnitFrenquency == null) {
                AdUnitFrenquency adUnitFrenquency2;
                adUnitFrenquency = adUnitFrenquency2;
                new AdUnitFrenquency().setId(string);
                adUnitFrenquency.setLoad_time(l);
                adUnitFrenquency.setShow_time(l);
            } else if ((l - adUnitFrenquency.getShow_time()) / 60000L >= (long)adUnitFrenquency.getTime()) {
                AdUnitFrenquency adUnitFrenquency3 = adUnitFrenquency;
                adUnitFrenquency3.setShow_time(l);
                adUnitFrenquency3.setShow_count(0);
            }
            AdUnitFrenquency adUnitFrenquency4 = adUnitFrenquency;
            adUnitFrenquency.setTime_limit(frequencyBean.getLimit());
            adUnitFrenquency4.setTime(frequencyBean.getTime());
            adUnitFrenquency4.setVersion_name(TPFrequencyManager.getVersionName());
            MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
            return;
        }
        if (adUnitFrenquency != null) {
            AdUnitFrenquency adUnitFrenquency5 = adUnitFrenquency;
            adUnitFrenquency5.setTime_limit(-1);
            adUnitFrenquency5.setTime(-1);
            MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
        }
    }

    public static ConfigResponse.FrequencyBean getFrequency(String object, boolean bl) {
        if (!((object = TPFrequencyManager.getAdUnitFrenquency((String)object)) == null || bl && TPFrequencyManager.checkVersion(((AdUnitFrenquency)object).getVersion_name()))) {
            ConfigResponse.FrequencyBean frequencyBean;
            ConfigResponse.FrequencyBean frequencyBean2 = frequencyBean;
            frequencyBean2();
            frequencyBean2.setLimit(((AdUnitFrenquency)object).getTime_limit());
            frequencyBean.setTime(((AdUnitFrenquency)object).getTime());
            return frequencyBean;
        }
        return null;
    }

    public static void addFrequencyShowCount(String string) {
        AdUnitFrenquency adUnitFrenquency = TPFrequencyManager.getAdUnitFrenquency(string);
        if (adUnitFrenquency == null) {
            return;
        }
        AdUnitFrenquency adUnitFrenquency2 = adUnitFrenquency;
        adUnitFrenquency2.setShow_count(adUnitFrenquency2.getShow_count() + 1);
        adUnitFrenquency2.setShow_time(System.currentTimeMillis());
        MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
    }

    public static boolean needShowAd(String string) {
        AdUnitFrenquency adUnitFrenquency = TPFrequencyManager.getAdUnitFrenquency(string);
        if (adUnitFrenquency != null && adUnitFrenquency.getTime_limit() != -1 && adUnitFrenquency.getTime() != -1) {
            long l = System.currentTimeMillis();
            if ((l - adUnitFrenquency.getShow_time()) / 60000L >= (long)adUnitFrenquency.getTime()) {
                AdUnitFrenquency adUnitFrenquency2 = adUnitFrenquency;
                adUnitFrenquency2.setLoad_time(l);
                adUnitFrenquency2.setShow_count(0);
                MemoryCacheManager.getInstance().saveAdUnitFrenquency(string, adUnitFrenquency);
                return true;
            }
            return adUnitFrenquency.getTime_limit() > adUnitFrenquency.getShow_count();
        }
        return true;
    }

    private static AdUnitFrenquency getAdUnitFrenquency(String string) {
        return MemoryCacheManager.getInstance().getAdUnitFrenquency(string);
    }

    public static NetWorkFrequencyUtils.NetworkFrequencyBean getGroupFrequency(String object) {
        NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean;
        if ((object = TPFrequencyManager.getAdSourceFrenquency((String)object)) == null) {
            return null;
        }
        NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean2 = networkFrequencyBean;
        networkFrequencyBean2();
        networkFrequencyBean2.setHourTime(((AdSourceFrenquency)object).getHourTime());
        networkFrequencyBean2.setDayTime(((AdSourceFrenquency)object).getDayTime());
        networkFrequencyBean2.setDayCount(((AdSourceFrenquency)object).getDayCount());
        networkFrequencyBean2.setHourCount(((AdSourceFrenquency)object).getHourCount());
        networkFrequencyBean2.setShowTime(((AdSourceFrenquency)object).getShowTime());
        networkFrequencyBean2.setCapping_day(((AdSourceFrenquency)object).getCapping_day());
        networkFrequencyBean2.setCapping_hour(((AdSourceFrenquency)object).getCapping_hour());
        networkFrequencyBean.setPacing_min(((AdSourceFrenquency)object).getPacing_min());
        LogUtil.ownShow("TPFrequencyManager getGroupFrequency - nfb == " + networkFrequencyBean2);
        return networkFrequencyBean;
    }

    public static void saveGroupFrequency(String string, NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean) {
        AdSourceFrenquency adSourceFrenquency;
        AdSourceFrenquency adSourceFrenquency2;
        AdSourceFrenquency adSourceFrenquency3 = adSourceFrenquency2 = adSourceFrenquency;
        adSourceFrenquency2();
        adSourceFrenquency3.setId(string);
        adSourceFrenquency3.setVersion_name(TPFrequencyManager.getVersionName());
        adSourceFrenquency2.setDayTime(networkFrequencyBean.getDayTime());
        adSourceFrenquency2.setHourTime(networkFrequencyBean.getHourTime());
        adSourceFrenquency2.setHourCount(networkFrequencyBean.getHourCount());
        adSourceFrenquency2.setDayCount(networkFrequencyBean.getDayCount());
        adSourceFrenquency2.setShowTime(networkFrequencyBean.getShowTime());
        adSourceFrenquency2.setCapping_day(networkFrequencyBean.getCapping_day());
        adSourceFrenquency2.setCapping_hour(networkFrequencyBean.getCapping_hour());
        adSourceFrenquency.setPacing_min(networkFrequencyBean.getPacing_min());
        MemoryCacheManager.getInstance().saveAdSource(string, adSourceFrenquency2);
        LogUtil.ownShow("TPFrequencyManager saveGroupFrequency - get == " + adSourceFrenquency2);
    }

    public static NetWorkFrequencyUtils.NetworkFrequencyBean getNetworkFrequency(String object, boolean bl) {
        if (!((object = TPFrequencyManager.getAdSourceFrenquency((String)object)) == null || bl && TPFrequencyManager.checkVersion(((AdSourceFrenquency)object).getVersion_name()))) {
            NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean;
            LogUtil.ownShow("TPFrequencyManager GroupFrequency - get == " + object);
            NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean2 = networkFrequencyBean;
            networkFrequencyBean2();
            networkFrequencyBean2.setHourTime(((AdSourceFrenquency)object).getHourTime());
            networkFrequencyBean2.setDayTime(((AdSourceFrenquency)object).getDayTime());
            networkFrequencyBean2.setDayCount(((AdSourceFrenquency)object).getDayCount());
            networkFrequencyBean2.setHourCount(((AdSourceFrenquency)object).getHourCount());
            networkFrequencyBean2.setShowTime(((AdSourceFrenquency)object).getShowTime());
            networkFrequencyBean2.setCapping_day(((AdSourceFrenquency)object).getCapping_day());
            networkFrequencyBean2.setCapping_hour(((AdSourceFrenquency)object).getCapping_hour());
            networkFrequencyBean.setPacing_min(((AdSourceFrenquency)object).getPacing_min());
            return networkFrequencyBean;
        }
        return null;
    }

    public static void saveNetworkFrequency(String string, NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean) {
        AdSourceFrenquency adSourceFrenquency;
        AdSourceFrenquency adSourceFrenquency2;
        AdSourceFrenquency adSourceFrenquency3 = adSourceFrenquency2 = adSourceFrenquency;
        adSourceFrenquency2();
        adSourceFrenquency3.setId(string);
        adSourceFrenquency3.setVersion_name(TPFrequencyManager.getVersionName());
        adSourceFrenquency2.setDayTime(networkFrequencyBean.getDayTime());
        adSourceFrenquency2.setHourTime(networkFrequencyBean.getHourTime());
        adSourceFrenquency2.setHourCount(networkFrequencyBean.getHourCount());
        adSourceFrenquency2.setDayCount(networkFrequencyBean.getDayCount());
        adSourceFrenquency2.setShowTime(networkFrequencyBean.getShowTime());
        adSourceFrenquency2.setCapping_day(networkFrequencyBean.getCapping_day());
        adSourceFrenquency2.setCapping_hour(networkFrequencyBean.getCapping_hour());
        adSourceFrenquency.setPacing_min(networkFrequencyBean.getPacing_min());
        MemoryCacheManager.getInstance().saveAdSource(string, adSourceFrenquency2);
    }

    private static AdSourceFrenquency getAdSourceFrenquency(String string) {
        return MemoryCacheManager.getInstance().getAdSourceFrenquency(string);
    }

    public static String getVersionName() {
        return "15.0.20.1";
    }

    public static boolean checkVersion(String string) {
        return TPFrequencyManager.getVersionName().compareTo(string) != 0;
    }
}

