/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.event.TPMessageUtils;
import com.tradplus.ads.base.event.push.EventAdxPushUtil;
import com.tradplus.ads.base.event.push.EventCrossPushUtil;
import com.tradplus.ads.base.event.push.EventPushUtil;
import com.tradplus.ads.base.event.push.EventSimplifyPushUtil;
import com.tradplus.ads.base.event.push.TrackPushUtil;
import com.tradplus.ads.base.event.timer.TPEventTimer;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TPPushCenter {
    private static volatile TPPushCenter instance;
    private ExecutorService executorService;
    private boolean enableEvent = true;
    private int maxEventNum = 100;
    private boolean isSimplify = false;
    private ArrayList<Integer> unused_eids;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPPushCenter getInstance() {
        if (instance != null) return instance;
        Class<TPPushCenter> clazz = TPPushCenter.class;
        synchronized (TPPushCenter.class) {
            if (instance != null) return instance;
            instance = new TPPushCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TPPushCenter() {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, timeUnit, linkedBlockingQueue2);
        v2.executorService = threadPoolExecutor2;
    }

    private boolean filterEvRequest(Object object) {
        if (object == null) {
            return false;
        }
        String string = "";
        if (object instanceof BaseRequest) {
            string = ((BaseRequest)object).getEid();
        } else if (object instanceof SimplifyEvent) {
            string = ((SimplifyEvent)object).getEid();
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        if (this.unused_eids == null) {
            return true;
        }
        for (int i = 0; i < this.unused_eids.size(); ++i) {
            Integer n = this.unused_eids.get(i);
            if (n == null || !TextUtils.equals((CharSequence)n.toString(), (CharSequence)string)) continue;
            LogUtil.ownShow("filter ev = " + string);
            return false;
        }
        return true;
    }

    public void init(Context context) {
        PushCenterHttpUtils.init(context);
        TPEventTimer.getInstance().init();
    }

    public boolean isEnable() {
        return this.enableEvent;
    }

    public void setEnable(boolean bl) {
        this.enableEvent = bl;
    }

    public void setTime(long l) {
        if (l != 0L && l >= 5000L && l <= 10000000L) {
            TPEventTimer.getInstance().setTime(l);
            return;
        }
    }

    public void setMaxMessageLength(int n) {
        if (n < 0) {
            this.enableEvent = false;
        }
        if (n != 0 && n >= 5 && n <= 500) {
            this.maxEventNum = n;
            return;
        }
    }

    public void saveEvent(final BaseRequest baseRequest) {
        if (this.isEnable() && !this.isSimplify && this.filterEvRequest(baseRequest)) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (TPDataManager.getInstance().isDebugMode()) {
                        LogUtil.ownShowForPushCenter(JSONHelper.toJSON(baseRequest), "TradPlus  : PUSHMESSAGEARRAY");
                    }
                    TPMessageUtils.saveEvent(baseRequest);
                }
            });
            return;
        }
    }

    public void saveEvent(final SimplifyEvent simplifyEvent) {
        if (this.isEnable() && this.isSimplify && this.filterEvRequest(simplifyEvent)) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (TPDataManager.getInstance().isDebugMode()) {
                        LogUtil.ownShowForPushCenter(JSONHelper.toJSON(simplifyEvent), "TradPlus  : simplifyEvent PUSHMESSAGEARRAY");
                    }
                    TPMessageUtils.saveSimplifyEvent(simplifyEvent);
                }
            });
            return;
        }
    }

    public void saveCrossEvent(final EventBaseRequest eventBaseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(eventBaseRequest), "Cross  : PUSHMESSAGEARRAY");
                }
                TPMessageUtils.saveCrossEvent(eventBaseRequest);
            }
        });
    }

    public void saveTrackMessage(final String string, final EventShowEndRequest eventShowEndRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(eventShowEndRequest), "Cross  : PUSHMESSAGEARRAY");
                }
                TPMessageUtils.saveTrackMessage(string, eventShowEndRequest);
            }
        });
    }

    public void saveAdxEvent(final Object object) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(object), "Adx  : PUSHMESSAGEARRAY");
                }
                StoreManager.saveAdxEvent(object);
            }
        });
    }

    public void pushEvent(final BaseRequest baseRequest) {
        if (this.isEnable() && !this.isSimplify) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (TPDataManager.getInstance().isDebugMode()) {
                        LogUtil.ownShowForPushCenter(JSONHelper.toJSON(baseRequest), "TradPlus  : PUSHMESSAGEARRAY");
                    }
                    new EventPushUtil().pushSingleEvent(baseRequest);
                }
            });
            return;
        }
    }

    public void pushEvent(final SimplifyEvent simplifyEvent) {
        if (this.isEnable() && this.isSimplify) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (TPDataManager.getInstance().isDebugMode()) {
                        LogUtil.ownShowForPushCenter(JSONHelper.toJSON(simplifyEvent), "TradPlus  : PUSHMESSAGEARRAY");
                    }
                    new EventSimplifyPushUtil().pushSingleEvent(simplifyEvent);
                }
            });
            return;
        }
    }

    public void pushCrossEvent(final EventBaseRequest eventBaseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(eventBaseRequest), "Cross  : PUSHMESSAGEARRAY");
                }
                new EventCrossPushUtil().pushSingleEvent(eventBaseRequest);
            }
        });
    }

    public void pushTrackEvent(final String string, final EventShowEndRequest eventShowEndRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(eventShowEndRequest), "Cross  : PUSHMESSAGEARRAY");
                }
                TrackPushUtil.pushTracks(string, eventShowEndRequest);
            }
        });
    }

    public void pushAdxEvent(final Object object) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (TPDataManager.getInstance().isDebugMode()) {
                    LogUtil.ownShowForPushCenter(JSONHelper.toJSON(object), "Adx  : PUSHMESSAGEARRAY");
                }
                new EventAdxPushUtil().pushSingleEvent(object);
            }
        });
    }

    public boolean sendGroupMeesageToServer() {
        if (this.isEnable() && !TextUtils.isEmpty((CharSequence)TPDataManager.getInstance().getDtd())) {
            TPPushCenter tPPushCenter = this;
            LogUtil.ownShow("sendGroupMeesageToServer \u6b63\u5e38\u4e0a\u4f20");
            tPPushCenter.pushEvent();
            tPPushCenter.pushSimplifyEvent();
            tPPushCenter.pushCrossEvent();
            tPPushCenter.pushAdxEvent();
            tPPushCenter.pushTrackToServer();
        } else {
            LogUtil.ownShow("sendGroupMeesageToServer \u4e0d\u4e0a\u4f20");
        }
        return this.enableEvent;
    }

    public boolean pushTest() {
        TPPushCenter tPPushCenter = this;
        tPPushCenter.pushEvent();
        tPPushCenter.pushSimplifyEvent();
        tPPushCenter.pushCrossEvent();
        tPPushCenter.pushAdxEvent();
        tPPushCenter.pushTrackToServer();
        return tPPushCenter.enableEvent;
    }

    public void pushCrossEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                new EventCrossPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public void pushAdxEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                new EventAdxPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public void pushTrackToServer() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                TrackPushUtil.pushTrack(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public void pushEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                new EventPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public void pushSimplifyEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                new EventSimplifyPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public boolean isSimplify() {
        return this.isSimplify;
    }

    public void setSimplify(int n) {
        n = n == 0 ? 1 : 0;
        this.isSimplify = n;
    }

    public void setUnusedEids(ArrayList<Integer> arrayList) {
        this.unused_eids = arrayList;
    }
}

