/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event.push;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPDiskManager;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.event.push.LocalEventUtil;
import com.tradplus.ads.base.event.timer.TPEventTimer;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.response.BaseResponse;

public abstract class EventBasePushUtil {
    private String getEventUrl() {
        if (TextUtils.isEmpty((CharSequence)(object = ((EventBasePushUtil)object).getPushUrl()))) {
            Object object = TPURLManager.getInstance().getTPEventUrl();
        }
        return object;
    }

    private boolean isNetworkAvailable() {
        EventBasePushUtil eventBasePushUtil = GlobalTradPlus.getInstance().getContext();
        if (eventBasePushUtil == null) {
            return false;
        }
        return DeviceUtils.isNetworkAvailable((Context)eventBasePushUtil);
    }

    public abstract String getPushUrl();

    public abstract void removeEvent(String ... var1);

    public abstract void pushNextEvent();

    public abstract void saveEvent(Object var1);

    public abstract void setEventTime(Object var1);

    public abstract String getLogType();

    public abstract Pair<String[], String[]> getEvents(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushEvent(int n) {
        if (!this.isNetworkAvailable()) {
            TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
            return;
        }
        final Pair<String[], String[]> pair = this.getEvents(n);
        if (pair == null) return;
        Object object = pair.first;
        if (object == null) return;
        if (pair.second == null) return;
        try {
            EventBasePushUtil eventBasePushUtil = this;
            eventBasePushUtil.removeEvent((String[])object);
            PushCenterHttpUtils.pushMessageArray(eventBasePushUtil.getEventUrl(), (String[])pair.second, new Listener(){

                @Override
                public void onSuccess(BaseResponse baseResponse) {
                    1 v0 = this;
                    LogUtil.ownShow("push Event success", v0.EventBasePushUtil.this.getLogType());
                    v0.EventBasePushUtil.this.pushNextEvent();
                    LocalEventUtil.getInstance().removeEventList((String[])pair.first);
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                    TPEventTimer.getInstance().initUploadEventFailedNum();
                }

                @Override
                public void oError(int n, String string) {
                    LogUtil.ownShow("push failed", EventBasePushUtil.this.getLogType());
                    TPEventTimer.getInstance().setUploadEventFailedNum();
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                    LocalEventUtil.getInstance().saveEventToStore((String[])pair.first);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void pushSingleEvent(final Object object) {
        Listener listener;
        if (!this.isNetworkAvailable()) {
            TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
            this.saveEvent(object);
            return;
        }
        EventBasePushUtil eventBasePushUtil = this;
        eventBasePushUtil.setEventTime(object);
        Listener listener2 = listener;
        listener = new Listener(){

            @Override
            public void onSuccess(BaseResponse baseResponse) {
                TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                LogUtil.ownShow("push Single Event success", EventBasePushUtil.this.getLogType());
                TPEventTimer.getInstance().initUploadEventFailedNum();
            }

            @Override
            public void oError(int n, String string) {
                2 v0 = this;
                LogUtil.ownShow("push single failed", v0.EventBasePushUtil.this.getLogType());
                TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                v0.EventBasePushUtil.this.saveEvent(object);
            }
        };
        PushCenterHttpUtils.pushSingleMessage(eventBasePushUtil.getEventUrl(), object, listener2);
    }
}

