/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.filter;

import android.text.TextUtils;
import com.tradplus.ads.base.TPFilter;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AdSourceFilterManager {
    private List<String> mNetworkIdList;
    private List<Integer> mFilterType;
    private List<TPFilter> mFilterList;

    private AdSourceFilterManager() {
    }

    public static AdSourceFilterManager getInstance() {
        return AdSourceFilterManagerHolder.INSTANCE;
    }

    private boolean checkMultipleFilters(ConfigResponse.WaterfallBean waterfallBean, String list, Integer n) {
        for (TPFilter tPFilter : this.mFilterList) {
            List<String> list2;
            if (tPFilter == null || (list2 = tPFilter.getForbidNetworkId()) == null || !list2.contains(list)) continue;
            list = tPFilter.getFilterType();
            if (list != null && !list.isEmpty()) {
                return this.checkBidType(waterfallBean, list, n);
            }
            return false;
        }
        return true;
    }

    private boolean checkSingleFilter(ConfigResponse.WaterfallBean waterfallBean, String list, Integer n) {
        List<String> list2 = this.mNetworkIdList;
        if (list2 != null && list2.contains(list)) {
            list = this.mFilterType;
            if (list != null && !list.isEmpty()) {
                return this.checkBidType(waterfallBean, this.mFilterType, n);
            }
            return false;
        }
        return true;
    }

    private boolean checkBidType(ConfigResponse.WaterfallBean waterfallBean, List<Integer> list, Integer n) {
        if (waterfallBean.getNew_sort_type() != 9) {
            return list.contains(TPFilter.NORMAL) ^ true;
        }
        return list.contains(n) ^ true;
    }

    private void handleSingleFilter(TPFilter object) {
        LogUtil.testShow("putFilter \u5355\u4e00\u89c4\u5219\u9650\u5236");
        CopyOnWriteArrayList<Integer> copyOnWriteArrayList = ((TPFilter)object).getForbidNetworkId();
        if (copyOnWriteArrayList != null) {
            if (this.mNetworkIdList == null) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList2;
                CopyOnWriteArrayList<String> copyOnWriteArrayList3 = copyOnWriteArrayList2;
                copyOnWriteArrayList2 = new CopyOnWriteArrayList<String>();
                this.mNetworkIdList = copyOnWriteArrayList3;
            }
            this.mNetworkIdList.addAll(copyOnWriteArrayList);
        }
        if ((object = ((TPFilter)object).getFilterType()) != null && !object.isEmpty()) {
            if (this.mFilterType == null) {
                CopyOnWriteArrayList<Integer> copyOnWriteArrayList4;
                copyOnWriteArrayList = copyOnWriteArrayList4;
                copyOnWriteArrayList4 = new CopyOnWriteArrayList<Integer>();
                this.mFilterType = copyOnWriteArrayList;
            }
            this.mFilterType.addAll((Collection<Integer>)object);
        }
    }

    private void handleMultipleFilters(List<TPFilter> object) {
        Object object2;
        LogUtil.testShow("putFilter \u591a\u91cd\u89c4\u5219\u9650\u5236");
        if (this.mFilterList == null) {
            ArrayList<TPFilter> arrayList;
            object2 = arrayList;
            arrayList = new ArrayList<TPFilter>();
            this.mFilterList = object2;
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (TPFilter)object.next();
            if (object2 == null) continue;
            this.mFilterList.add((TPFilter)object2);
        }
    }

    public void setForbidNetworkIdList(List<String> list) {
        this.clearFilters();
        if (list != null && !list.isEmpty()) {
            if (this.mNetworkIdList == null) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList;
                CopyOnWriteArrayList<String> copyOnWriteArrayList2 = copyOnWriteArrayList;
                copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
                this.mNetworkIdList = copyOnWriteArrayList2;
            }
            this.mNetworkIdList.addAll(list);
            return;
        }
    }

    public boolean checkForbidNetworkId(ConfigResponse.WaterfallBean waterfallBean, Integer n) {
        if (waterfallBean == null) {
            return true;
        }
        String string = waterfallBean.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        List<TPFilter> list = this.mFilterList;
        if (list != null && !list.isEmpty()) {
            return this.checkMultipleFilters(waterfallBean, string, n);
        }
        return this.checkSingleFilter(waterfallBean, string, n);
    }

    public void putFilter(List<TPFilter> list) {
        this.clearFilters();
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1) {
                this.handleSingleFilter(list.get(0));
                return;
            }
            this.handleMultipleFilters(list);
            return;
        }
    }

    public void clearFilters() {
        List<Object> list = ((AdSourceFilterManager)this).mNetworkIdList;
        if (list != null) {
            list.clear();
        }
        if ((list = ((AdSourceFilterManager)this).mFilterType) != null) {
            list.clear();
        }
        if ((this = ((AdSourceFilterManager)this).mFilterList) != null) {
            this.clear();
        }
    }

    private static class AdSourceFilterManagerHolder {
        private static final AdSourceFilterManager INSTANCE = new AdSourceFilterManager();

        private AdSourceFilterManagerHolder() {
        }
    }
}

