/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.filter;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.TPPlatform;
import com.tradplus.ads.base.bean.frenquency.AdShareUnitFrenquency;
import com.tradplus.ads.base.db.MemoryCacheManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.db.TPFrequencyManager;
import com.tradplus.ads.base.filter.AdSourceTypeLoadFrenquency;
import com.tradplus.ads.base.filter.AdSourceTypeShowFrenquency;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.DateAndTime;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class NetWorkFrequencyUtils {
    private static NetWorkFrequencyUtils instance;
    private HashMap<String, Integer> serverLimits;
    private HashMap<String, Integer> localLimits;
    private ArrayList<String> adSourceIdTypeLimits;
    private ArrayList<String> adSourceIdTypeImpSpacLimits;
    private ArrayList<String> adSourceIdTypeImpDayLimits;
    private ArrayList<String> adSourceIdTypeImpHourLimits;

    public NetWorkFrequencyUtils() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        HashMap hashMap;
        HashMap hashMap2;
        Object object = hashMap2;
        hashMap2 = new HashMap();
        v1.serverLimits = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.localLimits = object;
        object = arrayList4;
        arrayList4 = new ArrayList();
        v1.adSourceIdTypeLimits = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        v1.adSourceIdTypeImpSpacLimits = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        v1.adSourceIdTypeImpDayLimits = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.adSourceIdTypeImpHourLimits = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetWorkFrequencyUtils getInstance() {
        if (instance == null) {
            Class<NetWorkFrequencyUtils> clazz = NetWorkFrequencyUtils.class;
            synchronized (NetWorkFrequencyUtils.class) {
                instance = new NetWorkFrequencyUtils();
            }
        }
        return instance;
    }

    private void checkServerPlatformLimit() {
        if (this.serverLimits.isEmpty()) {
            Object object = StoreManager.getLocalTPOpenResponse(true);
            if (object == null) {
                return;
            }
            if ((object = ((TPOpenResponse)object).getAdsourceImpConfig()) != null) {
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    Object object2 = (TPOpenResponse.AdsourceImpConfigBean)object.next();
                    if (object2 == null) continue;
                    TPOpenResponse.AdsourceImpConfigBean adsourceImpConfigBean = object2;
                    int n = adsourceImpConfigBean.getAdsource_id();
                    int n2 = adsourceImpConfigBean.getLimit();
                    object2 = String.valueOf(n);
                    this.serverLimits.put((String)object2, n2);
                }
            } else {
                this.serverLimits.put("0", 0);
            }
        }
    }

    private boolean checkPlatformLimit(String string, int n) {
        if (n > 0 && n <= TPFrequencyManager.checkNetworkIdFrequencyShowCount(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.NETWORK_FREQUENCYLIMIT, "\u9650\u5236\u5e7f\u544a\u5e73\u53f0ID\u662f\uff1a" + string);
            return false;
        }
        return true;
    }

    private String getFrequencyId(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean.getConfig() == null) {
            return waterfallBean.getAdsource_placement_id();
        }
        return waterfallBean.getAdsource_placement_id() + waterfallBean.getConfigBean().getPlacementId();
    }

    private void deleteAdSourceTypeFrequency(String string) {
        if (MemoryCacheManager.getInstance().getAdSourceTypeFrenquency(string) != null) {
            MemoryCacheManager.getInstance().deleteAdSourceTypeFrequency(string);
        }
    }

    private boolean checkAdSourceTypeFrequency(String string) {
        AdSourceTypeLoadFrenquency adSourceTypeLoadFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeFrenquency(string);
        if (adSourceTypeLoadFrenquency != null) {
            AdSourceTypeLoadFrenquency adSourceTypeLoadFrenquency2 = adSourceTypeLoadFrenquency;
            List<Long> list = adSourceTypeLoadFrenquency2.getLoadTimes();
            int n = adSourceTypeLoadFrenquency2.getSecond();
            int n2 = adSourceTypeLoadFrenquency.getLimit();
            if (n > 0 && n2 > 0 && list != null) {
                if (n2 > list.size()) {
                    return true;
                }
                List<Long> list2 = list = list.subList(0, n2);
                if ((System.currentTimeMillis() - list2.get(list2.size() - 1)) / 1000L < (long)n) {
                    adSourceTypeLoadFrenquency.setLoadTimes(list);
                    MemoryCacheManager.getInstance().saveAdSourceTypeFrequency(string, adSourceTypeLoadFrenquency);
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }

    private void deleteAdSourceTypeShowFrequency(String string) {
        if (MemoryCacheManager.getInstance().getAdSourceTypeSpacShowFrenquency(string) != null) {
            MemoryCacheManager.getInstance().deleteAdSourceTypeSpacShowFrequency(string);
        }
    }

    private boolean checkAdSourceTypeShowFrequency(String string) {
        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeSpacShowFrenquency(string);
        if (adSourceTypeShowFrenquency != null) {
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2 = adSourceTypeShowFrenquency;
            List<Long> list = adSourceTypeShowFrenquency2.getShowTimes();
            int n = adSourceTypeShowFrenquency2.getSecond();
            int n2 = adSourceTypeShowFrenquency.getLimit();
            if (n > 0 && n2 == 1 && list != null) {
                List<Long> list2 = list = list.subList(0, n2);
                if ((System.currentTimeMillis() - list2.get(list2.size() - 1)) / 1000L < (long)n) {
                    adSourceTypeShowFrenquency.setShowTimes(list);
                    MemoryCacheManager.getInstance().saveAdSourceTypeSpacShowFrequency(string, adSourceTypeShowFrenquency);
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }

    private void deleteAdSourceTypeDayShowFrequency(String string) {
        if (MemoryCacheManager.getInstance().getAdSourceTypeDayShowFrenquency(string) != null) {
            MemoryCacheManager.getInstance().deleteAdSourceTypeDayShowFrequency(string);
        }
    }

    private boolean checkAdSourceTypeDayShowFrequency(String string) {
        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeDayShowFrenquency(string);
        if (adSourceTypeShowFrenquency != null) {
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2 = adSourceTypeShowFrenquency;
            List<Long> list = adSourceTypeShowFrenquency2.getShowTimes();
            int n = adSourceTypeShowFrenquency2.getSecond();
            if (adSourceTypeShowFrenquency2.getCreateTime() == 0L) {
                adSourceTypeShowFrenquency.setCreateTime(System.currentTimeMillis());
            }
            long l = NetWorkFrequencyUtils.getTomorrowDateStamp(adSourceTypeShowFrenquency.getCreateTime());
            int n2 = list != null ? list.size() : 0;
            if (System.currentTimeMillis() > l) {
                AdSourceTypeShowFrenquency adSourceTypeShowFrenquency3 = adSourceTypeShowFrenquency;
                adSourceTypeShowFrenquency3.setSecond((int)((NetWorkFrequencyUtils.getTomorrowDateStamp(System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L));
                adSourceTypeShowFrenquency3.setShowTimes(new ArrayList<Long>());
                adSourceTypeShowFrenquency3.setCreateTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeDayShowFrequency(string, adSourceTypeShowFrenquency);
                return true;
            }
            int n3 = n;
            n = adSourceTypeShowFrenquency.getLimit();
            if (n3 > 0 && n > 0 && list != null) {
                if (n > n2) {
                    return true;
                }
                adSourceTypeShowFrenquency.setShowTimes(list.subList(0, n));
                MemoryCacheManager.getInstance().saveAdSourceTypeDayShowFrequency(string, adSourceTypeShowFrenquency);
                return false;
            }
            return true;
        }
        return true;
    }

    private static long getTomorrowDateStamp(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.add(5, 1);
        return calendar.getTime().getTime();
    }

    private void deleteAdSourceTypeHourShowFrequency(String string) {
        if (MemoryCacheManager.getInstance().getAdSourceTypeHourShowFrenquency(string) != null) {
            MemoryCacheManager.getInstance().deleteAdSourceTypeHourShowFrequency(string);
        }
    }

    private boolean checkAdSourceTypeHourShowFrequency(String string) {
        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeHourShowFrenquency(string);
        if (adSourceTypeShowFrenquency != null) {
            List<Long> list = adSourceTypeShowFrenquency.getShowTimes();
            if (list != null) {
                list.size();
            }
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2 = adSourceTypeShowFrenquency;
            int n = adSourceTypeShowFrenquency2.getSecond();
            if (adSourceTypeShowFrenquency2.getCreateTime() == 0L) {
                adSourceTypeShowFrenquency.setCreateTime(System.currentTimeMillis());
            }
            long l = NetWorkFrequencyUtils.getNextHourDateStamp(adSourceTypeShowFrenquency.getCreateTime());
            if (System.currentTimeMillis() > l) {
                AdSourceTypeShowFrenquency adSourceTypeShowFrenquency3 = adSourceTypeShowFrenquency;
                adSourceTypeShowFrenquency3.setSecond((int)((NetWorkFrequencyUtils.getNextHourDateStamp(System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L));
                adSourceTypeShowFrenquency3.setShowTimes(new ArrayList<Long>());
                adSourceTypeShowFrenquency3.setCreateTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeHourShowFrequency(string, adSourceTypeShowFrenquency);
                return true;
            }
            int n2 = n;
            n = adSourceTypeShowFrenquency.getLimit();
            if (n2 > 0 && n > 0 && list != null) {
                if (n > list.size()) {
                    return true;
                }
                adSourceTypeShowFrenquency.setShowTimes(list.subList(0, n));
                MemoryCacheManager.getInstance().saveAdSourceTypeHourShowFrequency(string, adSourceTypeShowFrenquency);
                return false;
            }
            return true;
        }
        return true;
    }

    private static long getNextHourDateStamp(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.add(11, 1);
        return calendar.getTime().getTime();
    }

    public void setUsePlatformLimit(ArrayList<TPPlatform> object) {
        if (object != null) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Object object2 = (TPPlatform)object.next();
                if (object2 == null) continue;
                TPPlatform tPPlatform = object2;
                object2 = tPPlatform.getPlatform();
                int n = tPPlatform.getNum();
                this.localLimits.put((String)object2, n);
            }
        } else if (!this.localLimits.isEmpty()) {
            this.localLimits.clear();
        }
    }

    public boolean checkAdSourceFilter(ConfigResponse.WaterfallBean object) {
        if (object == null) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)(object = ((ConfigResponse.WaterfallBean)object).getId()))) {
            return true;
        }
        if (!this.localLimits.isEmpty() && this.localLimits.containsKey(object)) {
            return this.checkPlatformLimit((String)object, this.localLimits.get(object));
        }
        NetWorkFrequencyUtils netWorkFrequencyUtils = this;
        netWorkFrequencyUtils.checkServerPlatformLimit();
        if (!netWorkFrequencyUtils.serverLimits.isEmpty() && this.serverLimits.containsKey(object)) {
            return this.checkPlatformLimit((String)object, this.serverLimits.get(object));
        }
        return true;
    }

    public void addAdSourceIdShowCount(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean == null) {
            return;
        }
        String string = waterfallBean.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        TPFrequencyManager.addNetworkIdFrequencyShowCount(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            block8: {
                if (serializable == null) {
                    return true;
                }
                bl3 = false;
                bl2 = false;
                bl = false;
                NetworkFrequencyBean networkFrequencyBean = TPFrequencyManager.getNetworkFrequency(this.getFrequencyId((ConfigResponse.WaterfallBean)serializable), false);
                if (networkFrequencyBean == null) {
                    NetworkFrequencyBean networkFrequencyBean2;
                    networkFrequencyBean = networkFrequencyBean2;
                    networkFrequencyBean2 = new NetworkFrequencyBean();
                }
                if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
                    return true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0)) || ((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > networkFrequencyBean.getDayCount()) {
                    bl3 = true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1)) || ((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > networkFrequencyBean.getHourCount()) {
                    bl2 = true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() <= 0) break block8;
                long l = System.currentTimeMillis();
                if (networkFrequencyBean.getShowTime() >= l || l - networkFrequencyBean.getShowTime() < (long)(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() * 60000)) break block9;
            }
            bl = true;
        }
        if (!bl3) return false;
        if (!bl2) return false;
        if (!bl) return false;
        return true;
    }

    public void saveNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        if (serializable == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(this = ((NetWorkFrequencyUtils)this).getFrequencyId((ConfigResponse.WaterfallBean)serializable)))) {
            return;
        }
        NetworkFrequencyBean networkFrequencyBean = TPFrequencyManager.getNetworkFrequency((String)this, false);
        if (networkFrequencyBean == null) {
            NetworkFrequencyBean networkFrequencyBean2;
            networkFrequencyBean = networkFrequencyBean2;
            networkFrequencyBean2 = new NetworkFrequencyBean();
        }
        if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
            return;
        }
        networkFrequencyBean.setCapping_day(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day());
        networkFrequencyBean.setCapping_hour(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour());
        networkFrequencyBean.setPacing_min(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min());
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                NetworkFrequencyBean networkFrequencyBean3 = networkFrequencyBean;
                networkFrequencyBean3.setDayCount(1);
                networkFrequencyBean3.setDayTime(DateAndTime.getDate(0));
            } else {
                NetworkFrequencyBean networkFrequencyBean4 = networkFrequencyBean;
                networkFrequencyBean4.setDayCount(networkFrequencyBean4.getDayCount() + 1);
            }
        } else {
            networkFrequencyBean.setDayCount(0);
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                NetworkFrequencyBean networkFrequencyBean5 = networkFrequencyBean;
                networkFrequencyBean5.setHourCount(1);
                networkFrequencyBean5.setHourTime(DateAndTime.getDate(1));
            } else {
                NetworkFrequencyBean networkFrequencyBean6 = networkFrequencyBean;
                networkFrequencyBean6.setHourCount(networkFrequencyBean6.getHourCount() + 1);
            }
        } else {
            networkFrequencyBean.setHourCount(0);
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() > 0) {
            networkFrequencyBean.setShowTime(System.currentTimeMillis());
        }
        TPFrequencyManager.saveNetworkFrequency((String)this, networkFrequencyBean);
    }

    public void saveGroupFrequency(ConfigResponse.FrequencyBean frequencyBean, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Object object = TPFrequencyManager.getGroupFrequency(string);
        if (object == null) {
            NetworkFrequencyBean networkFrequencyBean;
            object = networkFrequencyBean;
            networkFrequencyBean = new NetworkFrequencyBean();
        }
        if (frequencyBean == null) {
            Object object2 = object;
            ((NetworkFrequencyBean)object2).setCapping_day(0);
            ((NetworkFrequencyBean)object2).setDayCount(0);
            ((NetworkFrequencyBean)object2).setCapping_hour(0);
            ((NetworkFrequencyBean)object2).setHourCount(0);
            ((NetworkFrequencyBean)object2).setPacing_min(0);
            TPFrequencyManager.saveGroupFrequency(string, (NetworkFrequencyBean)object);
            return;
        }
        ((NetworkFrequencyBean)object).setCapping_day(frequencyBean.getCapping_day());
        ((NetworkFrequencyBean)object).setCapping_hour(frequencyBean.getCapping_hour());
        ((NetworkFrequencyBean)object).setPacing_min(frequencyBean.getPacing_min());
        if (frequencyBean.getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)((NetworkFrequencyBean)object).getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                Object object3 = object;
                ((NetworkFrequencyBean)object3).setDayCount(0);
                ((NetworkFrequencyBean)object3).setDayTime(DateAndTime.getDate(0));
            }
        } else {
            ((NetworkFrequencyBean)object).setDayCount(0);
        }
        if (frequencyBean.getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)((NetworkFrequencyBean)object).getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                Object object4 = object;
                ((NetworkFrequencyBean)object4).setHourCount(0);
                ((NetworkFrequencyBean)object4).setHourTime(DateAndTime.getDate(1));
            }
        } else {
            ((NetworkFrequencyBean)object).setHourCount(0);
        }
        TPFrequencyManager.saveGroupFrequency(string, (NetworkFrequencyBean)object);
    }

    public void addGroupFrequencyShowCount(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        NetworkFrequencyBean networkFrequencyBean = TPFrequencyManager.getGroupFrequency(string);
        if (networkFrequencyBean == null) {
            return;
        }
        if (networkFrequencyBean.getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                NetworkFrequencyBean networkFrequencyBean2 = networkFrequencyBean;
                networkFrequencyBean2.setDayCount(1);
                networkFrequencyBean2.setDayTime(DateAndTime.getDate(0));
            } else {
                NetworkFrequencyBean networkFrequencyBean3 = networkFrequencyBean;
                networkFrequencyBean3.setDayCount(networkFrequencyBean3.getDayCount() + 1);
            }
        }
        if (networkFrequencyBean.getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                Object object = networkFrequencyBean;
                ((NetworkFrequencyBean)object).setHourCount(1);
                ((NetworkFrequencyBean)object).setHourTime(DateAndTime.getDate(1));
            } else {
                NetworkFrequencyBean networkFrequencyBean4 = networkFrequencyBean;
                networkFrequencyBean4.setHourCount(networkFrequencyBean4.getHourCount() + 1);
            }
        }
        if (networkFrequencyBean.getPacing_min() > 0) {
            networkFrequencyBean.setShowTime(System.currentTimeMillis());
        }
        TPFrequencyManager.saveGroupFrequency(string, networkFrequencyBean);
    }

    public boolean checkGroupFrequency(String string) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block8: {
            block7: {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return true;
                }
                bl3 = false;
                bl2 = false;
                bl = false;
                NetworkFrequencyBean networkFrequencyBean = TPFrequencyManager.getGroupFrequency(string);
                if (networkFrequencyBean == null) {
                    return true;
                }
                int n = networkFrequencyBean.getCapping_day();
                if (n <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0)) || n > networkFrequencyBean.getDayCount()) {
                    bl3 = true;
                }
                if ((n = networkFrequencyBean.getCapping_hour()) <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1)) || n > networkFrequencyBean.getHourCount()) {
                    bl2 = true;
                }
                if ((n = networkFrequencyBean.getPacing_min()) <= 0) break block7;
                long l = System.currentTimeMillis();
                if (networkFrequencyBean.getShowTime() >= l || l - networkFrequencyBean.getShowTime() < (long)(n * 60000)) break block8;
            }
            bl = true;
        }
        return bl3 && bl2 && bl;
    }

    public void addAdSourceIdLoadCount(ConfigResponse.WaterfallBean object, int n) {
        if (object == null) {
            return;
        }
        if (!((NetWorkFrequencyUtils)this).adSourceIdTypeLimits.isEmpty() && !((NetWorkFrequencyUtils)this).adSourceIdTypeLimits.contains("0")) {
            AdSourceTypeLoadFrenquency adSourceTypeLoadFrenquency;
            object = ((ConfigResponse.WaterfallBean)object).getId();
            String string = (String)object + n;
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeLimits.contains(object = (String)object + "0") && (adSourceTypeLoadFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeFrenquency((String)object)) != null) {
                adSourceTypeLoadFrenquency.addLoadTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeFrequency((String)object, adSourceTypeLoadFrenquency);
            }
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeLimits.contains(string) && (this = MemoryCacheManager.getInstance().getAdSourceTypeFrenquency(string)) != null) {
                ((AdSourceTypeLoadFrenquency)this).addLoadTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeFrequency(string, (AdSourceTypeLoadFrenquency)this);
            }
            return;
        }
    }

    public boolean checkAdSourceLoadFilter(ConfigResponse.WaterfallBean object, int n) {
        if (object == null) {
            return true;
        }
        if (this.adSourceIdTypeLimits.contains("0")) {
            return true;
        }
        if (this.adSourceIdTypeLimits.isEmpty()) {
            Object object2 = StoreManager.getLocalTPOpenResponse(true);
            if (object2 == null) {
                return true;
            }
            if ((object2 = ((TPOpenResponse)object2).getAdsourceRequestConfig()) != null) {
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig = (TPOpenResponse.AdsourceRequestConfig)object2.next();
                    if (adsourceRequestConfig == null) continue;
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig2 = adsourceRequestConfig;
                    int n2 = adsourceRequestConfig2.getAdsource_id();
                    int n3 = adsourceRequestConfig2.getAd_type();
                    int n4 = adsourceRequestConfig2.getLimit();
                    int n5 = adsourceRequestConfig.getSecond();
                    if (n4 <= 0 || n5 <= 0) continue;
                    String string = String.valueOf(n2);
                    String string2 = String.valueOf(n3);
                    this.adSourceIdTypeLimits.add(string + string2);
                    AdSourceTypeLoadFrenquency adSourceTypeLoadFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeFrenquency(string + string2);
                    if (adSourceTypeLoadFrenquency == null) {
                        AdSourceTypeLoadFrenquency adSourceTypeLoadFrenquency2;
                        adSourceTypeLoadFrenquency = adSourceTypeLoadFrenquency2;
                        adSourceTypeLoadFrenquency2 = new AdSourceTypeLoadFrenquency();
                    }
                    if (adSourceTypeLoadFrenquency.getCreateTime() == 0L) {
                        adSourceTypeLoadFrenquency.setCreateTime(System.currentTimeMillis());
                        adSourceTypeLoadFrenquency.setAdsourceId(n2);
                        adSourceTypeLoadFrenquency.setAdType(n3);
                    }
                    adSourceTypeLoadFrenquency.setLimit(n4);
                    adSourceTypeLoadFrenquency.setSecond(n5);
                    MemoryCacheManager.getInstance().saveAdSourceTypeFrequency(string + string2, adSourceTypeLoadFrenquency);
                }
            } else {
                this.adSourceIdTypeLimits.add("0");
                return true;
            }
        }
        object = ((ConfigResponse.WaterfallBean)object).getId();
        String string = (String)object + n;
        if (!this.adSourceIdTypeLimits.contains(object = (String)object + "0")) {
            this.deleteAdSourceTypeFrequency((String)object);
        }
        if (!this.adSourceIdTypeLimits.contains(string)) {
            this.deleteAdSourceTypeFrequency(string);
        }
        if (this.adSourceIdTypeLimits.contains(object)) {
            return this.checkAdSourceTypeFrequency((String)object);
        }
        if (this.adSourceIdTypeLimits.contains(string)) {
            return this.checkAdSourceTypeFrequency(string);
        }
        return true;
    }

    public boolean checkAppShowFrequency(ConfigResponse.WaterfallBean waterfallBean, int n) {
        if (waterfallBean == null) {
            return true;
        }
        if (n == -1) {
            return true;
        }
        return this.checkAdSourceSpacShowFilter(waterfallBean, n) && this.checkAdSourceDayShowFilter(waterfallBean, n) && this.checkAdSourceHourShowFilter(waterfallBean, n);
    }

    public void addAdSourceIdShowCount(String string, int n) {
        if (n == -1) {
            return;
        }
        NetWorkFrequencyUtils netWorkFrequencyUtils = this;
        netWorkFrequencyUtils.addAdSourceIdImpSpacCount(string, n);
        netWorkFrequencyUtils.addAdSourceIdImpDayCount(string, n);
        netWorkFrequencyUtils.addAdSourceIdImpHourCount(string, n);
    }

    public void addAdSourceIdImpSpacCount(String string, int n) {
        if (string == null) {
            return;
        }
        if (!((NetWorkFrequencyUtils)this).adSourceIdTypeImpSpacLimits.isEmpty() && !((NetWorkFrequencyUtils)this).adSourceIdTypeImpSpacLimits.contains("0")) {
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency;
            String string2 = string + n;
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpSpacLimits.contains(string = string + "0") && (adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeSpacShowFrenquency(string)) != null) {
                adSourceTypeShowFrenquency.addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeSpacShowFrequency(string, adSourceTypeShowFrenquency);
            }
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpSpacLimits.contains(string2) && (this = MemoryCacheManager.getInstance().getAdSourceTypeSpacShowFrenquency(string2)) != null) {
                ((AdSourceTypeShowFrenquency)this).addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeSpacShowFrequency(string2, (AdSourceTypeShowFrenquency)this);
            }
            return;
        }
    }

    public boolean checkAdSourceSpacShowFilter(ConfigResponse.WaterfallBean object, int n) {
        if (object == null) {
            return true;
        }
        if (this.adSourceIdTypeImpSpacLimits.contains("0")) {
            return true;
        }
        if (this.adSourceIdTypeImpSpacLimits.isEmpty()) {
            Object object2 = StoreManager.getLocalTPOpenResponse(true);
            if (object2 == null) {
                return true;
            }
            if ((object2 = ((TPOpenResponse)object2).getAdsourceImpSpacConfig()) != null) {
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig = (TPOpenResponse.AdsourceRequestConfig)object2.next();
                    if (adsourceRequestConfig == null) continue;
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig2 = adsourceRequestConfig;
                    int n2 = adsourceRequestConfig2.getAdsource_id();
                    int n3 = adsourceRequestConfig2.getAd_type();
                    int n4 = 1;
                    int n5 = adsourceRequestConfig2.getSecond();
                    if (n5 <= 0) continue;
                    String string = String.valueOf(n2);
                    String string2 = String.valueOf(n3);
                    this.adSourceIdTypeImpSpacLimits.add(string + string2);
                    AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeSpacShowFrenquency(string + string2);
                    if (adSourceTypeShowFrenquency == null) {
                        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency = adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency2 = new AdSourceTypeShowFrenquency();
                    }
                    if (adSourceTypeShowFrenquency.getCreateTime() == 0L) {
                        adSourceTypeShowFrenquency.setCreateTime(System.currentTimeMillis());
                        adSourceTypeShowFrenquency.setAdsourceId(n2);
                        adSourceTypeShowFrenquency.setAdType(n3);
                    }
                    adSourceTypeShowFrenquency.setLimit(n4);
                    adSourceTypeShowFrenquency.setSecond(n5);
                    MemoryCacheManager.getInstance().saveAdSourceTypeSpacShowFrequency(string + string2, adSourceTypeShowFrenquency);
                }
            } else {
                this.adSourceIdTypeImpSpacLimits.add("0");
                return true;
            }
        }
        object = ((ConfigResponse.WaterfallBean)object).getId();
        String string = (String)object + n;
        if (!this.adSourceIdTypeImpSpacLimits.contains(object = (String)object + "0")) {
            this.deleteAdSourceTypeShowFrequency((String)object);
        }
        if (!this.adSourceIdTypeImpSpacLimits.contains(string)) {
            this.deleteAdSourceTypeShowFrequency(string);
        }
        if (this.adSourceIdTypeImpSpacLimits.contains(object)) {
            return this.checkAdSourceTypeShowFrequency((String)object);
        }
        if (this.adSourceIdTypeImpSpacLimits.contains(string)) {
            return this.checkAdSourceTypeShowFrequency(string);
        }
        return true;
    }

    public void addAdSourceIdImpDayCount(String string, int n) {
        if (string == null) {
            return;
        }
        if (!((NetWorkFrequencyUtils)this).adSourceIdTypeImpDayLimits.isEmpty() && !((NetWorkFrequencyUtils)this).adSourceIdTypeImpDayLimits.contains("0")) {
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency;
            String string2 = string + n;
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpDayLimits.contains(string = string + "0") && (adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeDayShowFrenquency(string)) != null) {
                adSourceTypeShowFrenquency.addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeDayShowFrequency(string, adSourceTypeShowFrenquency);
            }
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpDayLimits.contains(string2) && (this = MemoryCacheManager.getInstance().getAdSourceTypeDayShowFrenquency(string2)) != null) {
                ((AdSourceTypeShowFrenquency)this).addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeDayShowFrequency(string2, (AdSourceTypeShowFrenquency)this);
            }
            return;
        }
    }

    public boolean checkAdSourceDayShowFilter(ConfigResponse.WaterfallBean object, int n) {
        if (object == null) {
            return true;
        }
        if (this.adSourceIdTypeImpDayLimits.contains("0")) {
            return true;
        }
        if (this.adSourceIdTypeImpDayLimits.isEmpty()) {
            Object object2 = StoreManager.getLocalTPOpenResponse(true);
            if (object2 == null) {
                return true;
            }
            if ((object2 = ((TPOpenResponse)object2).getAdsourceImpDayConfig()) != null) {
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig = (TPOpenResponse.AdsourceRequestConfig)object2.next();
                    if (adsourceRequestConfig == null) continue;
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig2 = adsourceRequestConfig;
                    int n2 = adsourceRequestConfig2.getAdsource_id();
                    int n3 = adsourceRequestConfig2.getAd_type();
                    int n4 = adsourceRequestConfig2.getLimit();
                    if (n4 <= 0) continue;
                    String string = String.valueOf(n2);
                    String string2 = String.valueOf(n3);
                    this.adSourceIdTypeImpDayLimits.add(string + string2);
                    AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeDayShowFrenquency(string + string2);
                    if (adSourceTypeShowFrenquency == null) {
                        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency = adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency2 = new AdSourceTypeShowFrenquency();
                    }
                    if (adSourceTypeShowFrenquency.getCreateTime() == 0L) {
                        adSourceTypeShowFrenquency.setCreateTime(System.currentTimeMillis());
                        adSourceTypeShowFrenquency.setAdsourceId(n2);
                        adSourceTypeShowFrenquency.setAdType(n3);
                    }
                    AdSourceTypeShowFrenquency adSourceTypeShowFrenquency3 = adSourceTypeShowFrenquency;
                    adSourceTypeShowFrenquency3.setLimit(n4);
                    if ((long)adSourceTypeShowFrenquency3.getSecond() == 0L) {
                        adSourceTypeShowFrenquency.setSecond((int)((NetWorkFrequencyUtils.getTomorrowDateStamp(System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L));
                    }
                    MemoryCacheManager.getInstance().saveAdSourceTypeDayShowFrequency(string + string2, adSourceTypeShowFrenquency);
                }
            } else {
                this.adSourceIdTypeImpDayLimits.add("0");
                return true;
            }
        }
        object = ((ConfigResponse.WaterfallBean)object).getId();
        String string = (String)object + n;
        if (!this.adSourceIdTypeImpDayLimits.contains(object = (String)object + "0")) {
            this.deleteAdSourceTypeDayShowFrequency((String)object);
        }
        if (!this.adSourceIdTypeImpDayLimits.contains(string)) {
            this.deleteAdSourceTypeDayShowFrequency(string);
        }
        if (this.adSourceIdTypeImpDayLimits.contains(object)) {
            return this.checkAdSourceTypeDayShowFrequency((String)object);
        }
        if (this.adSourceIdTypeImpDayLimits.contains(string)) {
            return this.checkAdSourceTypeDayShowFrequency(string);
        }
        return true;
    }

    public void addAdSourceIdImpHourCount(String string, int n) {
        if (string == null) {
            return;
        }
        if (!((NetWorkFrequencyUtils)this).adSourceIdTypeImpHourLimits.isEmpty() && !((NetWorkFrequencyUtils)this).adSourceIdTypeImpHourLimits.contains("0")) {
            AdSourceTypeShowFrenquency adSourceTypeShowFrenquency;
            String string2 = string + n;
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpHourLimits.contains(string = string + "0") && (adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeHourShowFrenquency(string)) != null) {
                adSourceTypeShowFrenquency.addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeHourShowFrequency(string, adSourceTypeShowFrenquency);
            }
            if (((NetWorkFrequencyUtils)this).adSourceIdTypeImpHourLimits.contains(string2) && (this = MemoryCacheManager.getInstance().getAdSourceTypeHourShowFrenquency(string2)) != null) {
                ((AdSourceTypeShowFrenquency)this).addShowTime(System.currentTimeMillis());
                MemoryCacheManager.getInstance().saveAdSourceTypeHourShowFrequency(string2, (AdSourceTypeShowFrenquency)this);
            }
            return;
        }
    }

    public boolean checkAdSourceHourShowFilter(ConfigResponse.WaterfallBean object, int n) {
        if (object == null) {
            return true;
        }
        if (this.adSourceIdTypeImpHourLimits.contains("0")) {
            return true;
        }
        if (this.adSourceIdTypeImpHourLimits.isEmpty()) {
            Object object2 = StoreManager.getLocalTPOpenResponse(true);
            if (object2 == null) {
                return true;
            }
            if ((object2 = ((TPOpenResponse)object2).getAdsourceImpHourConfig()) != null) {
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig = (TPOpenResponse.AdsourceRequestConfig)object2.next();
                    if (adsourceRequestConfig == null) continue;
                    TPOpenResponse.AdsourceRequestConfig adsourceRequestConfig2 = adsourceRequestConfig;
                    int n2 = adsourceRequestConfig2.getAdsource_id();
                    int n3 = adsourceRequestConfig2.getAd_type();
                    int n4 = adsourceRequestConfig2.getLimit();
                    if (n4 <= 0) continue;
                    String string = String.valueOf(n2);
                    String string2 = String.valueOf(n3);
                    this.adSourceIdTypeImpHourLimits.add(string + string2);
                    AdSourceTypeShowFrenquency adSourceTypeShowFrenquency = MemoryCacheManager.getInstance().getAdSourceTypeHourShowFrenquency(string + string2);
                    if (adSourceTypeShowFrenquency == null) {
                        AdSourceTypeShowFrenquency adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency = adSourceTypeShowFrenquency2;
                        adSourceTypeShowFrenquency2 = new AdSourceTypeShowFrenquency();
                    }
                    if (adSourceTypeShowFrenquency.getCreateTime() == 0L) {
                        adSourceTypeShowFrenquency.setCreateTime(System.currentTimeMillis());
                        adSourceTypeShowFrenquency.setAdsourceId(n2);
                        adSourceTypeShowFrenquency.setAdType(n3);
                    }
                    AdSourceTypeShowFrenquency adSourceTypeShowFrenquency3 = adSourceTypeShowFrenquency;
                    adSourceTypeShowFrenquency3.setLimit(n4);
                    if ((long)adSourceTypeShowFrenquency3.getSecond() == 0L) {
                        adSourceTypeShowFrenquency.setSecond((int)((NetWorkFrequencyUtils.getNextHourDateStamp(System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L));
                    }
                    MemoryCacheManager.getInstance().saveAdSourceTypeHourShowFrequency(string + string2, adSourceTypeShowFrenquency);
                }
            } else {
                this.adSourceIdTypeImpHourLimits.add("0");
                return true;
            }
        }
        object = ((ConfigResponse.WaterfallBean)object).getId();
        String string = (String)object + n;
        if (!this.adSourceIdTypeImpHourLimits.contains(object = (String)object + "0")) {
            this.deleteAdSourceTypeHourShowFrequency((String)object);
        }
        if (!this.adSourceIdTypeImpHourLimits.contains(string)) {
            this.deleteAdSourceTypeHourShowFrequency(string);
        }
        if (this.adSourceIdTypeImpHourLimits.contains(object)) {
            return this.checkAdSourceTypeHourShowFrequency((String)object);
        }
        if (this.adSourceIdTypeImpHourLimits.contains(string)) {
            return this.checkAdSourceTypeHourShowFrequency(string);
        }
        return true;
    }

    public void saveServerConfigResponseLimit(ConfigResponse object, String string) {
        ConfigResponse.ShareAdunitRequestInfoBean shareAdunitRequestInfoBean = ((ConfigResponse)object).getAdunit_request_interval_config();
        if (shareAdunitRequestInfoBean != null) {
            if (shareAdunitRequestInfoBean.getRequest_interval_status() != 1) {
                MemoryCacheManager.getInstance().deleteShareAdUnitFrenquency(string);
                return;
            }
            object = MemoryCacheManager.getInstance().getShareAdUnitFrenquency(string);
            if (object == null) {
                AdShareUnitFrenquency adShareUnitFrenquency;
                object = adShareUnitFrenquency;
                adShareUnitFrenquency = new AdShareUnitFrenquency();
            }
            Object object2 = object;
            ((AdShareUnitFrenquency)object2).setLoadLimit(shareAdunitRequestInfoBean.getRequest_interval());
            ((AdShareUnitFrenquency)object2).setVersion_name("15.0.20.1");
            MemoryCacheManager.getInstance().saveShareAdUnitFrenquency(string, (AdShareUnitFrenquency)object);
        }
    }

    public boolean checkAdShareUnitFrenquency(String string) {
        Log.i((String)"checkAdShareUnit", (String)("checkAdShareUnitFrenquency:" + string));
        Object object = MemoryCacheManager.getInstance().getShareAdUnitFrenquency(string);
        if (object == null) {
            AdShareUnitFrenquency adShareUnitFrenquency;
            object = adShareUnitFrenquency;
            adShareUnitFrenquency = new AdShareUnitFrenquency();
        }
        Object object2 = object;
        long l = ((AdShareUnitFrenquency)object2).getLoadElapsedRealtime();
        if (((AdShareUnitFrenquency)object2).getLoadLimit() <= 0L) {
            return true;
        }
        long l2 = ((AdShareUnitFrenquency)object).getLoadLimit();
        long l3 = SystemClock.elapsedRealtime();
        if (l <= 0L) {
            l = l3 + l2;
            ((AdShareUnitFrenquency)object).setLoadElapsedRealtime(l);
            MemoryCacheManager.getInstance().saveShareAdUnitFrenquency(string, (AdShareUnitFrenquency)object);
            Log.w((String)"checkAdShareUnit", (String)(" adUnitId:" + string + "\uff0c\u9996\u6b21\uff0c\u786e\u8ba4\u4e0b\u4e00\u6b21\u65f6\u95f4:" + l));
            return true;
        }
        if (l3 >= l) {
            ((AdShareUnitFrenquency)object).setLoadElapsedRealtime(l3 + l2);
            MemoryCacheManager.getInstance().saveShareAdUnitFrenquency(string, (AdShareUnitFrenquency)object);
            Log.w((String)"checkAdShareUnit", (String)(" adUnitId:" + string + "\uff0c\u8fbe\u5230\u4e0b\u4e00\u6b21\u65f6\u95f4\u4e86:" + l));
            return true;
        }
        Log.i((String)"checkAdShareUnit", (String)(" adUnitId:" + string + "\uff0c\u6ca1\u8fbe\u5230\u65f6\u95f4\uff0c\u88ab\u9891\u9650:" + l));
        return false;
    }

    public static class NetworkFrequencyBean
    implements Serializable {
        private String dayTime;
        private String hourTime;
        private long showTime;
        private int dayCount;
        private int hourCount;
        private int capping_hour;
        private int capping_day;
        private int pacing_min;

        public String getDayTime() {
            return this.dayTime;
        }

        public void setDayTime(String string) {
            this.dayTime = string;
        }

        public String getHourTime() {
            return this.hourTime;
        }

        public void setHourTime(String string) {
            this.hourTime = string;
        }

        public long getShowTime() {
            return this.showTime;
        }

        public void setShowTime(long l) {
            this.showTime = l;
        }

        public int getDayCount() {
            return this.dayCount;
        }

        public void setDayCount(int n) {
            this.dayCount = n;
        }

        public int getHourCount() {
            return this.hourCount;
        }

        public void setHourCount(int n) {
            this.hourCount = n;
        }

        public int getCapping_hour() {
            return this.capping_hour;
        }

        public void setCapping_hour(int n) {
            this.capping_hour = n;
        }

        public int getCapping_day() {
            return this.capping_day;
        }

        public void setCapping_day(int n) {
            this.capping_day = n;
        }

        public int getPacing_min() {
            return this.pacing_min;
        }

        public void setPacing_min(int n) {
            this.pacing_min = n;
        }

        public String toString() {
            return "NetworkFrequencyBean{dayTime='" + this.dayTime + '\'' + ", hourTime='" + this.hourTime + '\'' + ", showTime=" + this.showTime + ", dayCount=" + this.dayCount + ", hourCount=" + this.hourCount + ", capping_hour=" + this.capping_hour + ", capping_day=" + this.capping_day + ", pacing_min=" + this.pacing_min + '}';
        }
    }
}

