/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.NetStateChangeObserver;
import com.tradplus.ads.base.network.NetworkChangeReceiver;
import com.tradplus.ads.base.util.PrivacyDataInfo;

public class NetworkChangeManager {
    private static NetworkChangeManager instance;
    private NetStateChangeObserver netStateChangeObserver;
    private boolean isStart;

    public static synchronized NetworkChangeManager getInstance() {
        if (instance == null) {
            instance = new NetworkChangeManager();
        }
        return instance;
    }

    public NetworkChangeManager() {
        NetworkChangeManager networkChangeManager = this;
        if (!networkChangeManager.checkHasChangeNetworkPermission()) {
            this.isStart = true;
        }
    }

    public boolean checkHasChangeNetworkPermission() {
        Object object;
        block4: {
            try {
                object = GlobalTradPlus.getInstance().getContext();
                if (object != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        PackageManager packageManager = object.getPackageManager();
        NetworkChangeManager networkChangeManager = object;
        object = "android.permission.CHANGE_NETWORK_STATE";
        boolean bl = packageManager.checkPermission((String)object, networkChangeManager.getPackageName()) == 0;
        return bl;
    }

    public void setCloseNetworkChangeReceiver(boolean bl) {
        this.isStart = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startConnectivityNetwork(Context context) {
        try {
            if (this.isStart) return;
            this.isStart = true;
            if (PrivacyDataInfo.getInstance().getOSVersion() >= 21) {
                ((ConnectivityManager)context.getSystemService("connectivity")).requestNetwork(new NetworkRequest.Builder().build(), new ConnectivityManager.NetworkCallback(){

                    public void onAvailable(Network network) {
                        1 v0 = this;
                        super.onAvailable(network);
                        TPDataManager.getInstance().updateDeviceCounByType(true);
                        if (v0.NetworkChangeManager.this.netStateChangeObserver != null) {
                            NetworkChangeManager.this.netStateChangeObserver.onConnect();
                        }
                    }

                    public void onLost(Network network) {
                        1 v0 = this;
                        super.onLost(network);
                        TPDataManager.getInstance().updateDeviceCounByType(true);
                        if (v0.NetworkChangeManager.this.netStateChangeObserver != null) {
                            NetworkChangeManager.this.netStateChangeObserver.onDisconnect();
                        }
                    }
                });
                return;
            }
            NetworkChangeReceiver.registerReceiver(context);
            NetworkChangeReceiver.registerObserver(this.netStateChangeObserver);
            return;
        }
        catch (Exception exception) {}
    }

    public void stopConnectivityNetwork(Context context) {
        if (PrivacyDataInfo.getInstance().getOSVersion() < 21) {
            NetworkChangeReceiver.unRegisterReceiver(context);
            NetworkChangeReceiver.unRegisterObserver(this.netStateChangeObserver);
        }
        this.setNetStateChangeObserver(null);
    }

    public void setNetStateChangeObserver(NetStateChangeObserver netStateChangeObserver) {
        this.netStateChangeObserver = netStateChangeObserver;
    }
}

