/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ImageLruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public ImageLruCache(int n) {
        if (n > 0) {
            LinkedHashMap linkedHashMap;
            ImageLruCache imageLruCache = linkedHashMap2;
            imageLruCache.maxSize = n;
            LinkedHashMap linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap(0, 0.75f, true);
            imageLruCache.map = linkedHashMap2;
            return;
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void trimToSize(int n) {
        IllegalStateException illegalStateException;
        while (true) {
            ImageLruCache imageLruCache = this;
            // MONITORENTER : imageLruCache
            if (imageLruCache.size < 0 || ((AbstractMap)this.map).isEmpty() && this.size != 0) break;
            if (this.size <= n) {
                // MONITOREXIT : this
                return;
            }
            if (this.map.entrySet().size() <= 0) return;
            Map.Entry<K, V> entry = this.map.entrySet().iterator().next();
            if (entry == null) {
                return;
            }
            ImageLruCache imageLruCache2 = this;
            ImageLruCache imageLruCache3 = imageLruCache2;
            ImageLruCache imageLruCache4 = imageLruCache2;
            ImageLruCache imageLruCache5 = imageLruCache2;
            ImageLruCache imageLruCache6 = imageLruCache2;
            ImageLruCache imageLruCache7 = imageLruCache2;
            ImageLruCache imageLruCache8 = imageLruCache2;
            Map.Entry<K, V> entry2 = entry;
            entry = entry2.getKey();
            V v = entry2.getValue();
            ((AbstractMap)imageLruCache2.map).remove(entry);
            int n2 = imageLruCache6.size - this.safeSizeOf(entry, v);
            imageLruCache7.size = n2;
            imageLruCache4.evictionCount = imageLruCache8.evictionCount + 1;
            // MONITOREXIT : imageLruCache5
            imageLruCache3.entryRemoved(true, entry, v, null);
            continue;
            break;
        }
        IllegalStateException illegalStateException2 = illegalStateException;
        IllegalStateException illegalStateException3 = illegalStateException;
        illegalStateException2(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
        throw illegalStateException3;
    }

    private int safeSizeOf(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n >= 0) {
            return n;
        }
        throw new IllegalStateException("Negative size: " + k + "=" + v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n) {
        if (n > 0) {
            ImageLruCache imageLruCache = this;
            synchronized (imageLruCache) {
                imageLruCache.maxSize = n;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : v52761
                imageLruCache.trimToSize(n);
                return;
            }
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final V get(K var1_1) {
        block16: {
            block15: {
                block13: {
                    if (var1_1 == null) break block16;
                    synchronized (this) {
                        var2_2 = this.map.get(var1_1);
                        if (var2_2 == null) ** GOTO lbl12
                        v0 = var2_2;
                        v1 = this.hitCount;
                        this.hitCount = v1 + 1;
                        return v0;
lbl12:
                        // 1 sources

                        v2 = this.missCount;
                        this.missCount = v2 + 1;
                        // MONITOREXIT @DISABLED, blocks:[3, 9] lbl16 : MonitorExitStatement: MONITOREXIT : this
                        var2_2 = this.create(var1_1);
                        if (var2_2 != null) break block13;
                    }
                    return null;
                }
                synchronized (this) {
                    block14: {
                        v3 = this.createCount;
                        this.createCount = v3 + 1;
                        var3_3 = this.map.put(var1_1, var2_2);
                        if (var3_3 == null) break block14;
                        this.map.put(var1_1, var3_3);
                        ** GOTO lbl36
                    }
                    v4 = this.size + this.safeSizeOf(var1_1, var2_2);
                    this.size = v4;
lbl36:
                    // 2 sources

                    // MONITOREXIT @DISABLED, blocks:[8, 10] lbl35 : MonitorExitStatement: MONITOREXIT : this
                    if (var3_3 == null) break block15;
                    this.entryRemoved(false, var1_1, var2_2, var3_3);
                }
                return var3_3;
            }
            this.trimToSize(this.maxSize);
            return var2_2;
            {
                catch (Throwable v5) {
                    throw v5;
                }
            }
            {
                catch (Throwable v6) {
                    throw v6;
                }
            }
        }
        throw new NullPointerException("key == null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K k, V v) {
        if (k != null && v != null) {
            ImageLruCache imageLruCache = this;
            synchronized (imageLruCache) {
                int n = imageLruCache.putCount;
                imageLruCache.putCount = n + 1;
                int n2 = imageLruCache.size + this.safeSizeOf(k, v);
                imageLruCache.size = n2;
                V v2 = ((AbstractMap)imageLruCache.map).put(k, v);
                // ** MonitorExit[this] (shouldn't be in output)
                if (v2 != null) {
                    this.entryRemoved(false, k, v2, v);
                }
                ImageLruCache imageLruCache2 = this;
                imageLruCache2.trimToSize(imageLruCache2.maxSize);
                return v2;
            }
        }
        throw new NullPointerException("key == null || value == null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final V remove(K k) {
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        ImageLruCache imageLruCache = this;
        synchronized (imageLruCache) {
            Object v;
            block7: {
                v = ((AbstractMap)imageLruCache.map).remove(k);
                if (v != null) {
                    ImageLruCache imageLruCache2 = this;
                    imageLruCache2.size = imageLruCache2.size - this.safeSizeOf(k, v);
                }
                // ** MonitorExit[this] (shouldn't be in output)
                if (v == null) break block7;
                this.entryRemoved(false, k, v, null);
            }
            return v;
        }
    }

    protected void entryRemoved(boolean bl, K k, V v, V v2) {
    }

    protected V create(K k) {
        return null;
    }

    protected int sizeOf(K k, V v) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int n = this.hitCount;
        int n2 = n + this.missCount;
        n = n2 != 0 ? n * 100 / n2 : 0;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.maxSize;
        objectArray2[1] = this.hitCount;
        objectArray2[2] = this.missCount;
        objectArray[3] = n;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", objectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void clear() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        // MONITORENTER : linkedHashMap
        while (true) {
            Map.Entry<K, V> entry;
            block14: {
                if (this.size < 0 || ((AbstractMap)this.map).isEmpty() && this.size != 0) break;
                if (this.size != 0 && (entry = this.map.entrySet().size() > 0 ? this.map.entrySet().iterator().next() : null) != null) break block14;
                // MONITOREXIT : this
                this.map.clear();
                // MONITOREXIT : linkedHashMap
                return;
            }
            Map.Entry<K, V> entry2 = entry;
            entry = entry2.getKey();
            V v = entry2.getValue();
            ((AbstractMap)this.map).remove(entry);
            int n = this.size - this.safeSizeOf(entry, v);
            this.size = n;
            ++this.evictionCount;
            // MONITOREXIT : this
            this.entryRemoved(true, entry, v, null);
            continue;
            break;
        }
        throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
    }
}

