/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.network.util.ResourceDiskCacheManager;
import com.tradplus.ads.base.network.util.ResourceDownloadBaseUrlLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.task.TPTaskManager;
import com.tradplus.ads.common.task.TPWorker;
import com.tradplus.ads.common.util.FileUtil;
import java.io.InputStream;
import java.util.Map;

public class ImageUrlLoader
extends ResourceDownloadBaseUrlLoader {
    ResourceEntry entry;
    HttpLoadListener listener;

    public ImageUrlLoader(ResourceEntry resourceEntry) {
        super(resourceEntry.resourceUrl);
        this.entry = resourceEntry;
    }

    public void setListener(HttpLoadListener httpLoadListener) {
        this.listener = httpLoadListener;
    }

    @Override
    protected Map<String, String> onPrepareHeaders() {
        return null;
    }

    @Override
    protected void onErrorAgent(String string, String string2) {
    }

    @Override
    protected boolean saveHttpResource(InputStream inputStream) {
        ResourceEntry resourceEntry = ((ImageUrlLoader)((Object)resourceEntry)).entry;
        return ResourceDiskCacheManager.getInstance(GlobalTradPlus.getInstance().getContext()).saveNetworkInputStreamToFile(resourceEntry.resourceType, FileUtil.hashKeyForDisk(resourceEntry.resourceUrl), inputStream);
    }

    @Override
    protected void startWorker(TPWorker tPWorker) {
        TPTaskManager.getInstance().run(tPWorker, 5);
    }

    @Override
    protected void onLoadFinishCallback() {
        HttpLoadListener httpLoadListener = this.listener;
        if (httpLoadListener != null) {
            httpLoadListener.onLoadSuccess(this.entry);
        }
    }

    @Override
    protected void onLoadFailedCallback(String object, String string) {
        object = this.listener;
        if (object != null) {
            object.onLoadFail(this.entry, string);
        }
    }

    public static interface HttpLoadListener {
        public void onLoadSuccess(ResourceEntry var1);

        public void onLoadFail(ResourceEntry var1, String var2);
    }
}

