/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPUseTimeManager;
import com.tradplus.ads.base.network.NetworkChangeManager;
import com.tradplus.ads.common.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class TPContextUtils {
    private static TPContextUtils instance;
    private List<Activity> activities;
    private boolean isApplicationContext;
    private Context mApplicationContext;
    private boolean isRefreshActivity;

    public static TPContextUtils getInstance(Context context) {
        if (instance == null) {
            instance = new TPContextUtils(context);
        }
        return instance;
    }

    public TPContextUtils(Context context) {
        TPContextUtils tPContextUtils = this;
        tPContextUtils.isRefreshActivity = false;
        tPContextUtils.init(context);
    }

    private void init(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.startTopActivity(context);
    }

    private void startTopActivity(Context context) {
        ArrayList<Activity> arrayList;
        ArrayList<Activity> arrayList2 = arrayList;
        this.activities = new ArrayList<Activity>();
        if (context instanceof Activity) {
            arrayList2.add((Activity)context);
        }
        if ((context = this.mApplicationContext) instanceof Application) {
            this.isApplicationContext = true;
            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle bundle) {
                    if (!TPContextUtils.this.activities.contains(activity)) {
                        TPContextUtils.this.activities.add(activity);
                    }
                    LogUtil.ownShow("onActivityCreated activity size = " + TPContextUtils.this.activities.size());
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (TPContextUtils.this.isRefreshActivity) {
                        GlobalTradPlus.getInstance().refreshContext((Context)activity);
                    }
                    TPUseTimeManager.getInstance().onResume();
                }

                public void onActivityPaused(Activity activity) {
                    TPUseTimeManager.getInstance().onPause();
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityDestroyed(Activity activity) {
                    1 v0 = this;
                    v0.TPContextUtils.this.activities.remove(activity);
                    LogUtil.ownShow("destroyed activity size = " + TPContextUtils.this.activities.size());
                    if (v0.TPContextUtils.this.activities.size() == 0) {
                        NetworkChangeManager.getInstance().stopConnectivityNetwork(TPContextUtils.this.mApplicationContext);
                    }
                }
            });
        }
    }

    public Context compareContext(Context object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Activity) {
            return object;
        }
        object = this.activities;
        if (object != null && object.size() > 0) {
            return (Context)this.activities.get(0);
        }
        return null;
    }

    public boolean isApplicationContext() {
        return this.isApplicationContext;
    }

    public void setApplicationContext(boolean bl) {
        this.isApplicationContext = bl;
    }

    public boolean compareContextWithApplication(Context context) {
        return context instanceof Application;
    }

    public void setRefreshActivity(boolean bl) {
        this.isRefreshActivity = bl;
    }
}

