/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Node getFirstMatchingChildNode(Node node, String string) {
        return XmlUtils.getFirstMatchingChildNode(node, string, null, null);
    }

    public static Node getFirstMatchingChildNode(Node object, String string, String string2, List<String> list) {
        if (object != null && string != null) {
            if ((object = XmlUtils.getMatchingChildNodes((Node)object, string, string2, list)) != null && !object.isEmpty()) {
                return (Node)object.get(0);
            }
            return null;
        }
        return null;
    }

    public static List<Node> getMatchingChildNodes(Node node, String string) {
        return XmlUtils.getMatchingChildNodes(node, string, null, null);
    }

    public static List<Node> getMatchingChildNodes(Node object, String string, String string2, List<String> list) {
        if (object != null && string != null) {
            ArrayList arrayList;
            Node node = object;
            object = arrayList;
            arrayList = new ArrayList();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(string) || !XmlUtils.nodeMatchesAttributeFilter(node2, string2, list)) continue;
                object.add(node2);
            }
            return object;
        }
        return null;
    }

    public static boolean nodeMatchesAttributeFilter(Node object, String string, List<String> list) {
        if (string != null && list != null) {
            return (object = object.getAttributes()) != null && (object = object.getNamedItem(string)) != null && list.contains(object.getNodeValue());
        }
        return true;
    }

    public static String getNodeValue(Node node) {
        if (node != null && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
            return node.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    public static Integer getAttributeValueAsInt(Node node, String string) {
        if (node != null && string != null) {
            try {
                return Integer.parseInt(XmlUtils.getAttributeValue(node, string));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static String getAttributeValue(Node node, String string) {
        if (node != null && string != null) {
            if ((node = node.getAttributes().getNamedItem(string)) != null) {
                return node.getNodeValue();
            }
            return null;
        }
        return null;
    }

    public static <T> List<T> getListFromDocument(Document object, String object2, String string, String string2, NodeProcessor<T> nodeProcessor) {
        ArrayList<Node> arrayList;
        ArrayList<Node> arrayList2 = arrayList;
        arrayList = new ArrayList<Node>();
        if (object == null) {
            return arrayList2;
        }
        if ((object = object.getElementsByTagName((String)object2)) == null) {
            return arrayList2;
        }
        object2 = string2 == null ? null : Arrays.asList(string2);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, string, (List<String>)object2) || (node = nodeProcessor.process(node)) == null) continue;
            arrayList2.add(node);
        }
        return arrayList2;
    }

    public static <T> T getFirstMatchFromDocument(Document object, String object2, String string, String string2, NodeProcessor<T> nodeProcessor) {
        if (object == null) {
            return null;
        }
        if ((object = object.getElementsByTagName((String)object2)) == null) {
            return null;
        }
        object2 = string2 == null ? null : Arrays.asList(string2);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, string, (List<String>)object2) || (node = nodeProcessor.process(node)) == null) continue;
            return (T)node;
        }
        return null;
    }

    public static String getFirstMatchingStringData(Document document, String string) {
        return XmlUtils.getFirstMatchingStringData(document, string, null, null);
    }

    public static String getFirstMatchingStringData(Document object, String string, String string2, String string3) {
        NodeProcessor<String> nodeProcessor;
        Document document = object;
        object = nodeProcessor;
        nodeProcessor = new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        };
        return (String)XmlUtils.getFirstMatchFromDocument(document, string, string2, string3, object);
    }

    public static List<String> getStringDataAsList(Document document, String string) {
        return XmlUtils.getStringDataAsList(document, string, null, null);
    }

    public static List<String> getStringDataAsList(Document object, String string, String string2, String string3) {
        NodeProcessor<String> nodeProcessor;
        Document document = object;
        object = nodeProcessor;
        nodeProcessor = new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        };
        return XmlUtils.getListFromDocument(document, string, string2, string3, object);
    }

    public static List<Node> getNodesWithElementAndAttribute(Document object, String string, String string2, String string3) {
        NodeProcessor<Node> nodeProcessor;
        Document document = object;
        object = nodeProcessor;
        nodeProcessor = new NodeProcessor<Node>(){

            @Override
            public Node process(Node node) {
                return node;
            }
        };
        return XmlUtils.getListFromDocument(document, string, string2, string3, object);
    }

    public static interface NodeProcessor<T> {
        public T process(Node var1);
    }
}

