/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tradplus.ads.common.TPBrowser;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.util.Drawables;
import com.tradplus.ads.common.util.LogUtil;
import java.util.EnumSet;

class BrowserWebViewClient
extends WebViewClient {
    private static final EnumSet<UrlAction> SUPPORTED_URL_ACTIONS = EnumSet.of(UrlAction.HANDLE_PHONE_SCHEME, new UrlAction[]{UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
    private TPBrowser mTPBrowser;

    public BrowserWebViewClient(TPBrowser tPBrowser) {
        this.mTPBrowser = tPBrowser;
    }

    public void onReceivedError(WebView webView, int n, String string, String string2) {
        LogUtil.show("TPBrowser error: " + string);
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return new UrlHandler.Builder().withSupportedUrlActions(SUPPORTED_URL_ACTIONS).withoutTPBrowser().withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(String string, UrlAction urlAction) {
                if (((Object)((Object)urlAction)).equals((Object)UrlAction.OPEN_IN_APP_BROWSER)) {
                    BrowserWebViewClient.this.mTPBrowser.getWebView().loadUrl(string);
                } else {
                    BrowserWebViewClient.this.mTPBrowser.finish();
                }
            }

            @Override
            public void urlHandlingFailed(String string, UrlAction urlAction) {
            }
        }).build().handleResolvedUrl(this.mTPBrowser.getApplicationContext(), string, true, null);
    }

    public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
        BrowserWebViewClient browserWebViewClient = this;
        super.onPageStarted(webView, string, bitmap);
        browserWebViewClient.mTPBrowser.getForwardButton().setImageDrawable(Drawables.UNRIGHT_ARROW.createDrawable((Context)this.mTPBrowser));
    }

    public void onPageFinished(WebView webView, String string) {
        super.onPageFinished(webView, string);
        string = webView.canGoBack() ? Drawables.LEFT_ARROW.createDrawable((Context)this.mTPBrowser) : Drawables.UNLEFT_ARROW.createDrawable((Context)this.mTPBrowser);
        this.mTPBrowser.getBackButton().setImageDrawable((Drawable)string);
        webView = webView.canGoForward() ? Drawables.RIGHT_ARROW.createDrawable((Context)this.mTPBrowser) : Drawables.UNRIGHT_ARROW.createDrawable((Context)this.mTPBrowser);
        this.mTPBrowser.getForwardButton().setImageDrawable((Drawable)webView);
    }
}

