/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import com.tradplus.ads.common.DiskLruCache;
import com.tradplus.ads.common.util.CMData;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Streams;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CacheService {
    static final String UNIQUE_CACHE_NAME = "flute-cache";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static final int DISK_CACHE_INDEX = 0;
    private static DiskLruCache sDiskLruCache;

    public static boolean initializeDiskCache(Context object) {
        if (object == null) {
            return false;
        }
        if (sDiskLruCache == null) {
            if ((object = CacheService.getDiskCacheDirectory(object)) == null) {
                return false;
            }
            Object object2 = object;
            long l = DeviceUtils.diskCacheSizeBytes((File)object2);
            try {
                sDiskLruCache = DiskLruCache.open((File)object2, 1, 1, l);
            }
            catch (IOException iOException) {
                LogUtil.show("Unable to create DiskLruCache", iOException);
                return false;
            }
        }
        return true;
    }

    public static void initialize(Context context) {
        CacheService.initializeDiskCache(context);
    }

    public static String createValidDiskCacheKey(String string) {
        return CMData.getS256(string);
    }

    public static File getDiskCacheDirectory(Context object) {
        if ((object = object.getCacheDir()) == null) {
            return null;
        }
        object = ((File)object).getPath();
        return new File((String)object + File.separator + UNIQUE_CACHE_NAME);
    }

    public static boolean containsKeyDiskCache(String string) {
        DiskLruCache diskLruCache = sDiskLruCache;
        if (diskLruCache == null) {
            return false;
        }
        try {
            return diskLruCache.get(CacheService.createValidDiskCacheKey(string)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFilePathDiskCache(String string) {
        if (sDiskLruCache == null) {
            return null;
        }
        return sDiskLruCache.getDirectory() + File.separator + CacheService.createValidDiskCacheKey(string) + "." + 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFromDiskCache(String var0) {
        block13: {
            var1_2 = CacheService.sDiskLruCache;
            if (var1_2 == null) {
                return null;
            }
            v0 = var1_2;
            v1 = var0;
            var0 = null;
            var1_2 = null;
            try {
                var1_2 = v0.get(CacheService.createValidDiskCacheKey(v1));
                if (var1_2 == null) {
                    var0 = null;
                    if (var1_2 == null) return var0;
                    var1_2.close();
                    return var0;
                }
            }
            catch (Exception var2_4) {
                try {}
                catch (Throwable var0_1) {}
                LogUtil.show("Unable to get from DiskLruCache", var2_4);
                if (var1_2 == null) return var0;
            }
            {
                var2_3 = var1_2.getInputStream(0);
                if (var2_3 == null) break block13;
            }
            {
                var0 = new byte[(int)var1_2.getLength(0)];
            }
            var3_5 = v2;
            {
                v3 = var0;
                var3_5(var2_3);
            }
            Streams.readStream(v2, (byte[])v3);
            {
                catch (Throwable v4) {
                    Streams.closeStream(var3_5);
                    throw v4;
                }
                Streams.closeStream(v2);
                break block13;
            }
            ** finally { 
        }
        var1_2.close();
        return var0;
    }

    public static void getFromDiskCacheAsync(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
        new DiskLruCacheGetTask(string, diskLruCacheGetListener).execute(new Void[0]);
    }

    public static boolean putToDiskCache(String string, byte[] byArray) {
        return CacheService.putToDiskCache(string, new ByteArrayInputStream(byArray));
    }

    public static boolean putToDiskCache(String object, InputStream inputStream) {
        block8: {
            DiskLruCache diskLruCache = sDiskLruCache;
            if (diskLruCache == null) {
                return false;
            }
            String string = object;
            object = null;
            try {
                object = diskLruCache.edit(CacheService.createValidDiskCacheKey(string));
                if (object != null) break block8;
                return false;
            }
            catch (Exception exception) {
                LogUtil.show("Unable to put to DiskLruCache", exception);
                if (object != null) {
                    try {
                        ((DiskLruCache.Editor)object).abort();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        Object object2 = object;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((DiskLruCache.Editor)object).newOutputStream(0));
        Streams.copyContent(inputStream, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        sDiskLruCache.flush();
        ((DiskLruCache.Editor)object2).commit();
        return true;
    }

    public static void putToDiskCacheAsync(String string, byte[] byArray) {
        new DiskLruCachePutTask(string, byArray).execute(new Void[0]);
    }

    @Deprecated
    public static void clearAndNullCaches() {
        DiskLruCache diskLruCache = sDiskLruCache;
        if (diskLruCache != null) {
            try {
                diskLruCache.delete();
                sDiskLruCache = null;
            }
            catch (IOException iOException) {
                sDiskLruCache = null;
            }
        }
    }

    @Deprecated
    public static DiskLruCache getDiskLruCache() {
        return sDiskLruCache;
    }

    private static class DiskLruCacheGetTask
    extends AsyncTask<Void, Void, byte[]> {
        private final DiskLruCacheGetListener mDiskLruCacheGetListener;
        private final String mKey;

        DiskLruCacheGetTask(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
            this.mDiskLruCacheGetListener = diskLruCacheGetListener;
            this.mKey = string;
        }

        protected byte[] doInBackground(Void ... voidArray) {
            return CacheService.getFromDiskCache(this.mKey);
        }

        protected void onPostExecute(byte[] byArray) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            DiskLruCacheGetListener diskLruCacheGetListener = this.mDiskLruCacheGetListener;
            if (diskLruCacheGetListener != null) {
                diskLruCacheGetListener.onComplete(this.mKey, byArray);
            }
        }

        protected void onCancelled() {
            DiskLruCacheGetListener diskLruCacheGetListener = this.mDiskLruCacheGetListener;
            if (diskLruCacheGetListener != null) {
                diskLruCacheGetListener.onComplete(this.mKey, null);
            }
        }
    }

    public static interface DiskLruCacheGetListener {
        public void onComplete(String var1, byte[] var2);
    }

    private static class DiskLruCachePutTask
    extends AsyncTask<Void, Void, Void> {
        private final String mKey;
        private final byte[] mContent;

        DiskLruCachePutTask(String string, byte[] byArray) {
            this.mKey = string;
            this.mContent = byArray;
        }

        protected Void doInBackground(Void ... voidArray) {
            CacheService.putToDiskCache(this.mKey, this.mContent);
            return null;
        }
    }
}

