/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import com.tradplus.ads.common.DiskLruCacheStrictLineReader;
import com.tradplus.ads.common.DiskLruCacheUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,64}");
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n) {
        }
    };
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private long nextSequenceNumber;
    final ThreadPoolExecutor executorService;
    private final Callable<Void> cleanupCallable;

    private DiskLruCache(File file, int n, int n2, long l) {
        File file2;
        File file3;
        File file4;
        Callable<Void> callable;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        LinkedHashMap linkedHashMap;
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap(0, 0.75f, true);
        ((DiskLruCache)object2).lruEntries = object;
        ((DiskLruCache)object2).nextSequenceNumber = 0L;
        object = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, timeUnit, linkedBlockingQueue2);
        ((DiskLruCache)object2).executorService = object;
        object = callable;
        callable = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                1 v0 = this;
                DiskLruCache diskLruCache = v0.DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (v0.DiskLruCache.this.journalWriter == null) {
                        return null;
                    }
                    1 v1 = this;
                    v1.DiskLruCache.this.trimToSize();
                    if (v1.DiskLruCache.this.journalRebuildRequired()) {
                        1 v2 = this;
                        v2.DiskLruCache.this.rebuildJournal();
                        DiskLruCache.access$402(v2.DiskLruCache.this, 0);
                    }
                    return null;
                }
            }
        };
        ((DiskLruCache)object2).cleanupCallable = object;
        ((DiskLruCache)object2).directory = file;
        ((DiskLruCache)object2).appVersion = n;
        Object object2 = file4;
        file4 = new File(file, JOURNAL_FILE);
        v5.journalFile = object2;
        object2 = file3;
        file3 = new File(file, JOURNAL_FILE_TEMP);
        v5.journalFileTmp = object2;
        object2 = file2;
        file2 = new File(file, JOURNAL_FILE_BACKUP);
        v5.journalFileBackup = object2;
        v5.valueCount = n2;
        v5.maxSize = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) {
        if (l > 0L) {
            if (n2 > 0) {
                DiskLruCache diskLruCache;
                File file2;
                Object object = file2;
                if (new File(file, JOURNAL_FILE_BACKUP).exists()) {
                    File file3;
                    File file4 = file3;
                    if (new File(file, JOURNAL_FILE).exists()) {
                        ((File)object).delete();
                    } else {
                        DiskLruCache.renameTo((File)object, file4, false);
                    }
                }
                object = diskLruCache;
                if (new DiskLruCache((File)file, (int)n, (int)n2, (long)l).journalFile.exists()) {
                    try {
                        Object object2 = object;
                        super.readJournal();
                        super.processJournal();
                        ((DiskLruCache)object2).journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(((DiskLruCache)object).journalFile, true), DiskLruCacheUtil.US_ASCII));
                        return object2;
                    }
                    catch (IOException iOException) {
                        ((DiskLruCache)object).delete();
                    }
                }
                file.mkdirs();
                DiskLruCache diskLruCache2 = new DiskLruCache(file, n, n2, l);
                diskLruCache2.rebuildJournal();
                return diskLruCache2;
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    /*
     * Loose catch block
     */
    private void readJournal() {
        String string;
        String string2;
        String string3;
        String string4;
        DiskLruCacheStrictLineReader diskLruCacheStrictLineReader;
        block17: {
            DiskLruCacheStrictLineReader diskLruCacheStrictLineReader2;
            diskLruCacheStrictLineReader = diskLruCacheStrictLineReader2;
            string4 = new DiskLruCacheStrictLineReader(new FileInputStream(this.journalFile), DiskLruCacheUtil.US_ASCII).readLine();
            string3 = diskLruCacheStrictLineReader.readLine();
            String string5 = diskLruCacheStrictLineReader.readLine();
            string2 = diskLruCacheStrictLineReader.readLine();
            string = diskLruCacheStrictLineReader.readLine();
            if (!MAGIC.equals(string4)) break block17;
            if (!VERSION_1.equals(string3)) break block17;
            if (!Integer.toString(this.appVersion).equals(string5)) break block17;
            if (!Integer.toString(this.valueCount).equals(string2)) break block17;
            if (!"".equals(string)) break block17;
            int n = 0;
            while (true) {
                try {
                    this.readJournalLine(diskLruCacheStrictLineReader.readLine());
                    ++n;
                }
                catch (EOFException eOFException) {
                    DiskLruCacheStrictLineReader diskLruCacheStrictLineReader3 = diskLruCacheStrictLineReader;
                    DiskLruCache diskLruCache = this;
                    int n2 = n - ((AbstractMap)this.lruEntries).size();
                    diskLruCache.redundantOpCount = n2;
                    DiskLruCacheUtil.closeQuietly(diskLruCacheStrictLineReader3);
                    return;
                }
            }
        }
        throw new IOException("unexpected journal header: [" + string4 + ", " + string3 + ", " + string2 + ", " + string + "]");
        {
            catch (Throwable throwable) {
                DiskLruCacheUtil.closeQuietly(diskLruCacheStrictLineReader);
                throw throwable;
            }
        }
    }

    private void readJournalLine(String object) {
        block8: {
            block12: {
                block10: {
                    int n;
                    int n2;
                    block11: {
                        Editor editor;
                        Entry entry;
                        block9: {
                            String string;
                            n2 = ((String)object).indexOf(32);
                            if (n2 == -1) break block8;
                            int n3 = n2 + 1;
                            n = ((String)object).indexOf(32, n3);
                            if (n == -1) {
                                string = ((String)object).substring(n3);
                                if (n2 == 6 && ((String)object).startsWith(REMOVE)) {
                                    ((AbstractMap)stringArray.lruEntries).remove(string);
                                    return;
                                }
                            } else {
                                string = ((String)object).substring(n3, n);
                            }
                            if ((entry = stringArray.lruEntries.get(string)) == null) {
                                Entry entry2;
                                entry = entry2;
                                entry2 = (DiskLruCache)stringArray.new Entry(string);
                                ((AbstractMap)stringArray.lruEntries).put(string, entry);
                            }
                            if (n == -1 || n2 != 5 || !((String)object).startsWith(CLEAN)) break block9;
                            Entry entry3 = entry;
                            String[] stringArray = ((String)object).substring(n + 1).split(" ");
                            Entry.access$602(entry3, true);
                            Entry.access$702(entry3, null);
                            entry3.setLengths(stringArray);
                            break block10;
                        }
                        if (n != -1 || n2 != 5 || !((String)object).startsWith(DIRTY)) break block11;
                        object = editor;
                        editor = (DiskLruCache)stringArray.new Editor(entry);
                        Entry.access$702(entry, (Editor)object);
                        break block10;
                    }
                    if (n != -1 || n2 != 4 || !((String)object).startsWith(READ)) break block12;
                }
                return;
            }
            throw new IOException("unexpected journal line: " + (String)object);
        }
        throw new IOException("unexpected journal line: " + (String)object);
    }

    private void processJournal() {
        DiskLruCache diskLruCache = this;
        DiskLruCache.deleteIfExists(diskLruCache.journalFileTmp);
        Iterator<Entry> iterator = diskLruCache.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n = 0; n < this.valueCount; ++n) {
                    this.size += entry.lengths[n];
                }
                continue;
            }
            Entry.access$702(entry, null);
            for (n = 0; n < this.valueCount; ++n) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n));
            }
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void rebuildJournal() {
        BufferedWriter bufferedWriter;
        Writer writer = this.journalWriter;
        if (writer != null) {
            writer.close();
        }
        Writer writer2 = writer = bufferedWriter;
        Writer writer3 = writer;
        ((BufferedWriter)writer3)(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), DiskLruCacheUtil.US_ASCII));
        try {
            writer3.write(MAGIC);
            writer3.write("\n");
            writer3.write(VERSION_1);
            writer3.write("\n");
            writer2.write(Integer.toString(this.appVersion));
            writer2.write("\n");
            bufferedWriter.write(Integer.toString(this.valueCount));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                String string;
                Writer writer4;
                if (entry.currentEditor != null) {
                    writer4 = writer;
                    string = "DIRTY " + entry.key + '\n';
                } else {
                    writer4 = writer;
                    string = "CLEAN " + entry.key + entry.getLengths() + '\n';
                }
                writer4.write(string);
            }
        }
        catch (Throwable throwable) {
            writer.close();
            throw throwable;
        }
        writer.close();
        if (this.journalFile.exists()) {
            DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        DiskLruCache diskLruCache = this;
        DiskLruCache.renameTo(diskLruCache.journalFileTmp, this.journalFile, false);
        diskLruCache.journalFileBackup.delete();
        diskLruCache.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), DiskLruCacheUtil.US_ASCII));
    }

    private static void deleteIfExists(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File file, File file2, boolean bl) {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (file.renameTo(file2)) {
            return;
        }
        throw new IOException();
    }

    private synchronized Editor edit(String string, long l) {
        Editor editor;
        DiskLruCache diskLruCache = this;
        this.checkNotClosed();
        diskLruCache.validateKey(string);
        Entry entry = diskLruCache.lruEntries.get(string);
        if (l != -1L && (entry == null || entry.sequenceNumber != l)) {
            return null;
        }
        if (entry == null) {
            Entry entry2;
            entry = entry2;
            entry2 = new Entry(string);
            ((AbstractMap)this.lruEntries).put(string, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor2 = editor;
        DiskLruCache diskLruCache2 = this;
        Editor editor3 = editor2;
        editor3(entry);
        Entry.access$702(entry, editor3);
        diskLruCache2.journalWriter.write("DIRTY " + string + '\n');
        diskLruCache2.journalWriter.flush();
        return editor;
    }

    private synchronized void completeEdit(Editor editor, boolean bl) {
        Entry entry = editor.entry;
        if (entry.currentEditor == editor) {
            if (bl && !entry.readable) {
                for (int i = 0; i < this.valueCount; ++i) {
                    if (editor.written[i]) {
                        if (entry.getDirtyFile(i).exists()) continue;
                        editor.abort();
                        return;
                    }
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
            }
            for (int i = 0; i < this.valueCount; ++i) {
                File file = entry.getDirtyFile(i);
                if (bl) {
                    long l;
                    if (!file.exists()) continue;
                    Entry entry2 = entry;
                    File file2 = entry2.getCleanFile(i);
                    file.renameTo(file2);
                    long l2 = entry.lengths[i];
                    ((Entry)entry2).lengths[i] = l = file2.length();
                    this.size = this.size - l2 + l;
                    continue;
                }
                DiskLruCache.deleteIfExists(file);
            }
            Entry entry3 = entry;
            ++this.redundantOpCount;
            Entry.access$702(entry3, null);
            if (entry3.readable | bl) {
                Entry.access$602(entry, true);
                this.journalWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
                if (bl) {
                    long l = this.nextSequenceNumber;
                    this.nextSequenceNumber = l + 1L;
                    Entry.access$1202(entry, l);
                }
            } else {
                DiskLruCache diskLruCache = this;
                ((AbstractMap)diskLruCache.lruEntries).remove(entry.key);
                diskLruCache.journalWriter.write("REMOVE " + entry.key + '\n');
            }
            DiskLruCache diskLruCache = this;
            diskLruCache.journalWriter.flush();
            if (diskLruCache.size > this.maxSize || this.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            return;
        }
        throw new IllegalStateException();
    }

    private boolean journalRebuildRequired() {
        int n = this.redundantOpCount;
        return n >= 2000 && n >= ((AbstractMap)this.lruEntries).size();
    }

    private void checkNotClosed() {
        if (this.journalWriter != null) {
            return;
        }
        throw new IllegalStateException("cache is closed");
    }

    private void trimToSize() {
        while (this.size > this.maxSize) {
            DiskLruCache diskLruCache = this;
            diskLruCache.remove(diskLruCache.lruEntries.entrySet().iterator().next().getKey());
        }
    }

    private void validateKey(String string) {
        if (LEGAL_KEY_PATTERN.matcher(string).matches()) {
            return;
        }
        throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + string + "\"");
    }

    private static String inputStreamToString(InputStream inputStream) {
        return DiskLruCacheUtil.readFully(new InputStreamReader(inputStream, DiskLruCacheUtil.UTF_8));
    }

    static /* synthetic */ int access$402(DiskLruCache diskLruCache, int n) {
        diskLruCache.redundantOpCount = n;
        return n;
    }

    static /* synthetic */ OutputStream access$2000() {
        return NULL_OUTPUT_STREAM;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Snapshot get(String string) {
        DiskLruCache diskLruCache = this;
        this.checkNotClosed();
        diskLruCache.validateKey(string);
        Object object = diskLruCache.lruEntries.get(string);
        if (object == null) {
            return null;
        }
        if (!((Entry)object).readable) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.valueCount];
        int n = 0;
        while (true) {
            FileInputStream fileInputStream;
            try {
                if (n >= this.valueCount) break;
                InputStream[] inputStreamArray2 = inputStreamArray;
                int n2 = n;
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (int i = 0; i < this.valueCount && (object = inputStreamArray[i]) != null; ++i) {
                    DiskLruCacheUtil.closeQuietly((Closeable)object);
                }
                return null;
            }
            FileInputStream fileInputStream2 = fileInputStream;
            {
                fileInputStream = new FileInputStream(((Entry)object).getCleanFile(n));
                inputStreamArray2[n2] = fileInputStream2;
                ++n;
                continue;
            }
            break;
        }
        DiskLruCache diskLruCache2 = this;
        ++diskLruCache2.redundantOpCount;
        diskLruCache2.journalWriter.append("READ " + string + '\n');
        if (diskLruCache2.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        Object object2 = object;
        long l = ((Entry)object2).sequenceNumber;
        object = ((Entry)object2).lengths;
        return new Snapshot(string, l, inputStreamArray, (long[])object);
    }

    public Editor edit(String string) {
        return this.edit(string, -1L);
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long l) {
        this.maxSize = l;
        this.executorService.submit(this.cleanupCallable);
    }

    public synchronized long size() {
        return this.size;
    }

    public synchronized boolean remove(String string) {
        DiskLruCache diskLruCache = this;
        this.checkNotClosed();
        diskLruCache.validateKey(string);
        Entry entry = diskLruCache.lruEntries.get(string);
        if (entry != null && entry.currentEditor == null) {
            for (int i = 0; i < this.valueCount; ++i) {
                File file = entry.getCleanFile(i);
                if (file.exists() && !file.delete()) {
                    throw new IOException("failed to delete " + file);
                }
                this.size -= entry.lengths[i];
                ((Entry)entry).lengths[i] = 0L;
            }
            DiskLruCache diskLruCache2 = this;
            ++diskLruCache2.redundantOpCount;
            diskLruCache2.journalWriter.append("REMOVE " + string + '\n');
            ((AbstractMap)diskLruCache2.lruEntries).remove(string);
            if (diskLruCache2.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    public synchronized void flush() {
        DiskLruCache diskLruCache = this;
        diskLruCache.checkNotClosed();
        diskLruCache.trimToSize();
        diskLruCache.journalWriter.flush();
    }

    @Override
    public synchronized void close() {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        DiskLruCache diskLruCache = this;
        diskLruCache.trimToSize();
        diskLruCache.journalWriter.close();
        diskLruCache.journalWriter = null;
    }

    public void delete() {
        DiskLruCache diskLruCache = this;
        diskLruCache.close();
        DiskLruCacheUtil.deleteContents(diskLruCache.directory);
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean hasErrors;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            DiskLruCache.this = entry.readable ? null : (Object)new boolean[((DiskLruCache)DiskLruCache.this).valueCount];
            this.written = (boolean[])DiskLruCache.this;
        }

        static /* synthetic */ boolean access$2302(Editor editor, boolean bl) {
            editor.hasErrors = bl;
            return bl;
        }

        /*
         * Exception decompiling
         */
        public InputStream newInputStream(int var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String getString(int n) {
            return (this = ((Editor)this).newInputStream(n)) != null ? DiskLruCache.inputStreamToString((InputStream)this) : null;
        }

        /*
         * Exception decompiling
         */
        public OutputStream newOutputStream(int var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void set(int n, String string) {
            Throwable throwable2;
            OutputStreamWriter outputStreamWriter;
            block5: {
                OutputStreamWriter outputStreamWriter2;
                outputStreamWriter = null;
                OutputStreamWriter outputStreamWriter3 = outputStreamWriter2;
                try {
                    outputStreamWriter2 = new OutputStreamWriter(this.newOutputStream(n), DiskLruCacheUtil.UTF_8);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                    break block5;
                }
                try {
                    outputStreamWriter2.write(string);
                }
                catch (Throwable throwable2) {
                    outputStreamWriter = outputStreamWriter3;
                    break block5;
                }
                DiskLruCacheUtil.closeQuietly(outputStreamWriter2);
                return;
            }
            DiskLruCacheUtil.closeQuietly(outputStreamWriter);
            throw throwable2;
        }

        public void commit() {
            if (this.hasErrors) {
                Editor editor = this;
                editor.DiskLruCache.this.completeEdit(this, false);
                editor.DiskLruCache.this.remove(this.entry.key);
            } else {
                DiskLruCache.this.completeEdit(this, true);
            }
            this.committed = true;
        }

        public void abort() {
            DiskLruCache.this.completeEdit(this, false);
        }

        public void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                }
                catch (IOException iOException) {}
            }
        }

        private class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.access$2302(Editor.this, true);
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.access$2302(Editor.this, true);
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.access$2302(Editor.this, true);
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.access$2302(Editor.this, true);
                }
            }
        }
    }

    private final class Entry {
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String string) {
            this.key = string;
            this.lengths = new long[DiskLruCache.this.valueCount];
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setLengths(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n = 0;
            try {
                while (true) {
                    if (n >= stringArray.length) {
                        return;
                    }
                    this.lengths[n] = Long.parseLong(stringArray[n]);
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        private IOException invalidLengths(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        static /* synthetic */ boolean access$602(Entry entry, boolean bl) {
            entry.readable = bl;
            return bl;
        }

        static /* synthetic */ Editor access$702(Entry entry, Editor editor) {
            entry.currentEditor = editor;
            return editor;
        }

        static /* synthetic */ long access$1202(Entry entry, long l) {
            entry.sequenceNumber = l;
            return l;
        }

        public String getLengths() {
            StringBuilder stringBuilder;
            Entry entry = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            long[] lArray = entry.lengths;
            int n = entry.lengths.length;
            for (int i = 0; i < n; ++i) {
                long l = lArray[i];
                stringBuilder2.append(' ').append(l);
            }
            return stringBuilder2.toString();
        }

        public File getCleanFile(int n) {
            return new File(DiskLruCache.this.directory, this.key + "." + n);
        }

        public File getDirtyFile(int n) {
            return new File(DiskLruCache.this.directory, this.key + "." + n + ".tmp");
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final InputStream[] ins;
        private final long[] lengths;

        private Snapshot(String string, long l, InputStream[] inputStreamArray, long[] lArray) {
            this.key = string;
            this.sequenceNumber = l;
            this.ins = inputStreamArray;
            this.lengths = lArray;
        }

        public Editor edit() {
            Snapshot snapshot = string;
            String string = snapshot.key;
            long l = snapshot.sequenceNumber;
            return ((Snapshot)((Object)string)).DiskLruCache.this.edit(string, l);
        }

        public InputStream getInputStream(int n) {
            return this.ins[n];
        }

        public String getString(int n) {
            return DiskLruCache.inputStreamToString(this.getInputStream(n));
        }

        public long getLength(int n) {
            return this.lengths[n];
        }

        @Override
        public void close() {
            InputStream[] inputStreamArray = inputStreamArray.ins;
            int n = inputStreamArray.ins.length;
            for (int i = 0; i < n; ++i) {
                DiskLruCacheUtil.closeQuietly(inputStreamArray[i]);
            }
        }
    }
}

