/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.SystemClock;
import com.tradplus.ads.base.util.PrivacyDataInfo;
import com.tradplus.ads.common.util.LogUtil;
import java.util.HashMap;

public class DoubleTimeTracker {
    private volatile State state;
    private long startedTimestamp;
    private long interval;
    private final Clock mClock;

    public DoubleTimeTracker() {
        SystemClockClock systemClockClock;
        DoubleTimeTracker doubleTimeTracker = systemClockClock2;
        SystemClockClock systemClockClock2 = systemClockClock;
        systemClockClock = new SystemClockClock();
        doubleTimeTracker(systemClockClock2);
    }

    public DoubleTimeTracker(Clock clock) {
        DoubleTimeTracker doubleTimeTracker = this;
        doubleTimeTracker.mClock = clock;
        doubleTimeTracker.state = State.PAUSED;
    }

    private synchronized long computeIntervalDiff() {
        if (this.state == State.PAUSED) {
            return 0L;
        }
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && hashMap.containsKey("elapsedreal_time")) {
            return 0L;
        }
        return this.mClock.elapsedRealTime() - this.startedTimestamp;
    }

    public synchronized void start() {
        Object object = State.STARTED;
        if (this.state == object) {
            LogUtil.show("DoubleTimeTracker already started.");
            return;
        }
        this.state = object;
        object = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        this.startedTimestamp = object != null && ((HashMap)object).containsKey("elapsedreal_time") ? 0L : this.mClock.elapsedRealTime();
    }

    public synchronized void pause() {
        State state = State.PAUSED;
        if (this.state == state) {
            LogUtil.show("DoubleTimeTracker already paused.");
            return;
        }
        this.interval += this.computeIntervalDiff();
        this.startedTimestamp = 0L;
        this.state = state;
    }

    public synchronized double getInterval() {
        return this.interval + this.computeIntervalDiff();
    }

    private static class SystemClockClock
    implements Clock {
        private SystemClockClock() {
        }

        @Override
        public long elapsedRealTime() {
            return SystemClock.elapsedRealtime();
        }
    }

    public static interface Clock {
        public long elapsedRealTime();
    }

    private static enum State {
        STARTED,
        PAUSED;

    }
}

