/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.Looper;
import com.tradplus.ads.common.util.LogUtil;
import java.util.IllegalFormatException;

public final class Preconditions {
    public static final String EMPTY_ARGUMENTS = "";

    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkArgumentInternal(bl, true, "Illegal argument.", objectArray2);
    }

    public static void checkArgument(boolean bl, String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkArgumentInternal(bl, true, string, objectArray2);
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        Preconditions.checkArgumentInternal(bl, true, string, objectArray);
    }

    public static void checkState(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkStateInternal(bl, true, "Illegal state.", objectArray2);
    }

    public static void checkState(boolean bl, String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkStateInternal(bl, true, string, objectArray2);
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        Preconditions.checkStateInternal(bl, true, string, objectArray);
    }

    public static void checkNotNull(Object objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = EMPTY_ARGUMENTS;
        Preconditions.checkNotNullInternal(objectArray2, true, "Object can not be null.", objectArray);
    }

    public static void checkNotNull(Object objectArray, String string) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = EMPTY_ARGUMENTS;
        Preconditions.checkNotNullInternal(objectArray2, true, string, objectArray);
    }

    public static void checkNotNull(Object object, String string, Object ... objectArray) {
        Preconditions.checkNotNullInternal(object, true, string, objectArray);
    }

    public static void checkUiThread() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkUiThreadInternal(true, "This method must be called from the UI thread.", objectArray2);
    }

    public static void checkUiThread(String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.checkUiThreadInternal(true, string, objectArray2);
    }

    public static void checkUiThread(String string, Object ... objectArray) {
        Preconditions.checkUiThreadInternal(true, string, objectArray);
    }

    private static boolean checkArgumentInternal(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.format(string, objectArray);
        if (!bl2) {
            LogUtil.show(string2);
            return false;
        }
        throw new IllegalArgumentException(string2);
    }

    private static boolean checkStateInternal(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.format(string, objectArray);
        if (!bl2) {
            LogUtil.show(string2);
            return false;
        }
        throw new IllegalStateException(string2);
    }

    private static boolean checkNotNullInternal(Object object, boolean bl, String string, Object ... objectArray) {
        if (object != null) {
            return true;
        }
        object = Preconditions.format(string, objectArray);
        if (!bl) {
            LogUtil.show((String)object);
            return false;
        }
        throw new NullPointerException((String)object);
    }

    private static boolean checkUiThreadInternal(boolean bl, String string, Object ... objectArray) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return true;
        }
        String string2 = Preconditions.format(string, objectArray);
        if (!bl) {
            LogUtil.show(string2);
            return false;
        }
        throw new IllegalStateException(string2);
    }

    private static String format(String string, Object ... objectArray) {
        string = String.valueOf(string);
        try {
            return String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            LogUtil.show("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
            return string;
        }
    }

    public static final class NoThrow {
        private static volatile boolean sStrictMode = false;

        public static void setStrictMode(boolean bl) {
            sStrictMode = bl;
        }

        public static boolean checkArgument(boolean bl) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, "Illegal argument", objectArray2);
        }

        public static boolean checkArgument(boolean bl, String string) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, string, objectArray2);
        }

        public static boolean checkArgument(boolean bl, String string, Object ... objectArray) {
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkState(boolean bl) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, "Illegal state.", objectArray2);
        }

        public static boolean checkState(boolean bl, String string) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, string, objectArray2);
        }

        public static boolean checkState(boolean bl, String string, Object ... objectArray) {
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkNotNull(Object objectArray) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkNotNullInternal(objectArray2, NoThrow.sStrictMode, "Object can not be null.", objectArray);
        }

        public static boolean checkNotNull(Object objectArray, String string) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkNotNullInternal(objectArray2, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkNotNull(Object object, String string, Object ... objectArray) {
            return Preconditions.checkNotNullInternal(object, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkUiThread() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, "This method must be called from the UI thread.", objectArray2);
        }

        public static boolean checkUiThread(String objectArray) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, (String)objectArray2, objectArray);
        }

        public static boolean checkUiThread(String string, Object ... objectArray) {
            return Preconditions.checkUiThreadInternal(false, string, objectArray);
        }
    }
}

