/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.net.Uri;
import android.os.AsyncTask;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.util.AsyncTasks;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class UrlResolutionTask
extends AsyncTask<String, Void, String> {
    private static final int REDIRECT_LIMIT = 10;
    private final UrlResolutionListener mListener;

    public static void getResolvedUrl(String string, UrlResolutionListener urlResolutionListener) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        try {
            stringArray[0] = string;
            AsyncTasks.safeExecuteOnExecutor(new UrlResolutionTask(urlResolutionListener), stringArray2);
        }
        catch (Exception exception) {
            urlResolutionListener.onFailure("Failed to resolve url", exception);
        }
    }

    UrlResolutionTask(UrlResolutionListener urlResolutionListener) {
        this.mListener = urlResolutionListener;
    }

    private String getRedirectLocation(String string) {
        Object object = null;
        try {
            object = (HttpURLConnection)new URL(string).openConnection();
        }
        catch (Throwable throwable) {
            if (object != null) {
                ((HttpURLConnection)object).disconnect();
            }
            throw throwable;
        }
        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
        String string2 = UrlResolutionTask.resolveRedirectLocation(string, (HttpURLConnection)object);
        ((HttpURLConnection)object).disconnect();
        return string2;
    }

    static String resolveRedirectLocation(String string, HttpURLConnection object) {
        URI uRI;
        URI uRI2 = uRI;
        uRI = new URI(string);
        int n = ((HttpURLConnection)object).getResponseCode();
        object = ((URLConnection)object).getHeaderField("Location");
        String string2 = null;
        if (n >= 300 && n < 400) {
            try {
                string2 = uRI2.resolve((String)object).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new URISyntaxException((String)object, "Unable to parse invalid URL");
            }
        }
        return string2;
    }

    protected String doInBackground(String ... stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            String[] stringArray2;
            Object object;
            String[] stringArray3 = stringArray;
            stringArray = null;
            try {
                object = stringArray3[0];
                stringArray2 = object;
                object = stringArray;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            stringArray = stringArray2;
            for (int i = 0; stringArray != null && i < 10; ++i) {
                block7: {
                    if (UrlAction.OPEN_IN_APP_BROWSER.shouldTryHandlingUrl(Uri.parse((String)stringArray))) break block7;
                    return stringArray;
                }
                object = this.getRedirectLocation((String)stringArray);
                Object object2 = object;
                object = stringArray;
                stringArray = object2;
            }
            return object;
        }
        return null;
    }

    protected void onPostExecute(String string) {
        UrlResolutionTask urlResolutionTask = this;
        super.onPostExecute((Object)string);
        if (!urlResolutionTask.isCancelled() && string != null) {
            this.mListener.onSuccess(string);
        } else {
            this.onCancelled();
        }
    }

    protected void onCancelled() {
        UrlResolutionTask urlResolutionTask = this;
        super.onCancelled();
        urlResolutionTask.mListener.onFailure("Task for resolving url was cancelled", null);
    }

    static interface UrlResolutionListener {
        public void onSuccess(String var1);

        public void onFailure(String var1, Throwable var2);
    }
}

