/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Views;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class VisibilityTracker {
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;
    static final int NUM_ACCESSES_BEFORE_TRIMMING = 50;
    private final ArrayList<View> mTrimmedViews;
    private long mAccessCounter;
    final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;
    WeakReference<ViewTreeObserver> mWeakViewTreeObserver;
    private final Map<View, TrackingInfo> mTrackedViews;
    private final VisibilityChecker mVisibilityChecker;
    private VisibilityTrackerListener mVisibilityTrackerListener;
    private final VisibilityRunnable mVisibilityRunnable;
    private final Handler mVisibilityHandler;
    private boolean mIsVisibilityScheduled;

    public VisibilityTracker(Context context) {
        Handler handler;
        VisibilityChecker visibilityChecker;
        WeakHashMap weakHashMap;
        VisibilityTracker visibilityTracker = weakHashMap2;
        WeakHashMap weakHashMap2 = weakHashMap;
        weakHashMap = new WeakHashMap(10);
        VisibilityChecker visibilityChecker2 = visibilityChecker;
        visibilityChecker = new VisibilityChecker();
        Handler handler2 = handler;
        handler = new Handler();
        visibilityTracker(context, weakHashMap2, visibilityChecker2, handler2);
    }

    VisibilityTracker(Context context, Map<View, TrackingInfo> object, VisibilityChecker visibilityChecker, Handler handler) {
        WeakReference<Object> weakReference;
        ViewTreeObserver.OnPreDrawListener onPreDrawListener;
        ArrayList arrayList;
        VisibilityRunnable visibilityRunnable;
        VisibilityTracker visibilityTracker = weakReference2;
        visibilityTracker.mAccessCounter = 0L;
        visibilityTracker.mTrackedViews = object;
        visibilityTracker.mVisibilityChecker = visibilityChecker;
        visibilityTracker.mVisibilityHandler = handler;
        object = visibilityRunnable;
        visibilityRunnable = (VisibilityTracker)((Object)weakReference2).new VisibilityRunnable();
        visibilityTracker.mVisibilityRunnable = object;
        object = arrayList;
        arrayList = new ArrayList(50);
        visibilityTracker.mTrimmedViews = object;
        object = onPreDrawListener;
        onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                VisibilityTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        visibilityTracker.mOnPreDrawListener = object;
        WeakReference<Object> weakReference2 = weakReference;
        weakReference = new WeakReference<Object>(null);
        visibilityTracker.mWeakViewTreeObserver = weakReference2;
        visibilityTracker.setViewTreeObserver(context, null);
    }

    private void setViewTreeObserver(Context context, View view) {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mWeakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            return;
        }
        if ((context = Views.getTopmostView(context, view)) == null) {
            LogUtil.show("Unable to set Visibility Tracker due to no available root view.");
            return;
        }
        if (!(context = context.getViewTreeObserver()).isAlive()) {
            LogUtil.show("Visibility Tracker was unable to track views because the root view tree observer was not alive");
            return;
        }
        this.mWeakViewTreeObserver = new WeakReference<Context>(context);
        context.addOnPreDrawListener(this.mOnPreDrawListener);
    }

    private void trimTrackedViews(long l) {
        for (Map.Entry<View, TrackingInfo> entry : this.mTrackedViews.entrySet()) {
            if (entry.getValue().mAccessOrder >= l) continue;
            this.mTrimmedViews.add(entry.getKey());
        }
        Iterator<View> iterator = this.mTrimmedViews.iterator();
        while (iterator.hasNext()) {
            this.removeView(iterator.next());
        }
        this.mTrimmedViews.clear();
    }

    static /* synthetic */ boolean access$002(VisibilityTracker visibilityTracker, boolean bl) {
        visibilityTracker.mIsVisibilityScheduled = bl;
        return bl;
    }

    public void setVisibilityTrackerListener(VisibilityTrackerListener visibilityTrackerListener) {
        this.mVisibilityTrackerListener = visibilityTrackerListener;
    }

    public void addView(View view, int n, Integer n2) {
        View view2 = view;
        this.addView(view2, view2, n, n2);
    }

    public void addView(View view, View view2, int n, Integer n2) {
        int n3 = n;
        this.addView(view, view2, n3, n3, n2);
    }

    public void addView(View view, View view2, int n, int n2, Integer n3) {
        VisibilityTracker visibilityTracker = this;
        visibilityTracker.setViewTreeObserver(view2.getContext(), view2);
        TrackingInfo trackingInfo = visibilityTracker.mTrackedViews.get(view2);
        if (trackingInfo == null) {
            TrackingInfo trackingInfo2;
            VisibilityTracker visibilityTracker2 = this;
            trackingInfo = trackingInfo2;
            trackingInfo2 = new TrackingInfo();
            visibilityTracker2.mTrackedViews.put(view2, trackingInfo);
            visibilityTracker2.scheduleVisibilityCheck();
        }
        TrackingInfo trackingInfo3 = trackingInfo;
        int n4 = Math.min(n2, n);
        trackingInfo.mRootView = view;
        trackingInfo3.mMinViewablePercent = n;
        trackingInfo3.mMaxInvisiblePercent = n4;
        long l = this.mAccessCounter;
        trackingInfo.mAccessOrder = l++;
        trackingInfo.mMinVisiblePx = n3;
        this.mAccessCounter = l;
        if (l % 50L == 0L) {
            this.trimTrackedViews(l - 50L);
        }
    }

    public void removeView(View view) {
        this.mTrackedViews.remove(view);
    }

    public void clear() {
        VisibilityTracker visibilityTracker = this;
        visibilityTracker.mTrackedViews.clear();
        visibilityTracker.mVisibilityHandler.removeMessages(0);
        visibilityTracker.mIsVisibilityScheduled = false;
    }

    public void destroy() {
        VisibilityTracker visibilityTracker = this;
        visibilityTracker.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)visibilityTracker.mWeakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mWeakViewTreeObserver.clear();
        this.mVisibilityTrackerListener = null;
    }

    public void scheduleVisibilityCheck() {
        if (this.mIsVisibilityScheduled) {
            return;
        }
        this.mIsVisibilityScheduled = true;
        this.mVisibilityHandler.postDelayed((Runnable)this.mVisibilityRunnable, 100L);
    }

    public static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }

    public static class VisibilityChecker {
        private final Rect mClipRect;

        public VisibilityChecker() {
            Rect rect;
            VisibilityChecker visibilityChecker = rect;
            rect = new Rect();
            v1.mClipRect = visibilityChecker;
        }

        public boolean hasRequiredTimeElapsed(long l, int n) {
            return SystemClock.uptimeMillis() - l >= (long)n;
        }

        public boolean isVisible(View view, View view2, int n, Integer n2) {
            if (view2 != null && view2.getVisibility() == 0 && view.getParent() != null) {
                if (!view2.getGlobalVisibleRect(this.mClipRect)) {
                    return false;
                }
                long l = (long)this.mClipRect.height() * (long)this.mClipRect.width();
                long l2 = (long)view2.getHeight() * (long)view2.getWidth();
                if (l2 <= 0L) {
                    return false;
                }
                if (n2 != null && n2 > 0) {
                    return l >= (long)n2.intValue();
                }
                return l * 100L >= (long)n * l2;
            }
            return false;
        }
    }

    class VisibilityRunnable
    implements Runnable {
        private final ArrayList<View> mVisibleViews;
        private final ArrayList<View> mInvisibleViews;

        VisibilityRunnable() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.mInvisibleViews = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.mVisibleViews = object;
        }

        @Override
        public void run() {
            VisibilityRunnable visibilityRunnable = this;
            VisibilityTracker.access$002(visibilityRunnable.VisibilityTracker.this, false);
            for (Map.Entry entry : visibilityRunnable.VisibilityTracker.this.mTrackedViews.entrySet()) {
                View view = (View)entry.getKey();
                int n = ((TrackingInfo)entry.getValue()).mMinViewablePercent;
                int n2 = ((TrackingInfo)entry.getValue()).mMaxInvisiblePercent;
                Integer n3 = ((TrackingInfo)entry.getValue()).mMinVisiblePx;
                View view2 = ((TrackingInfo)entry.getValue()).mRootView;
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(view2, view, n, n3)) {
                    this.mVisibleViews.add(view);
                    continue;
                }
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(view2, view, n2, null)) continue;
                this.mInvisibleViews.add(view);
            }
            if (VisibilityTracker.this.mVisibilityTrackerListener != null) {
                VisibilityRunnable visibilityRunnable2 = this;
                ArrayList<View> arrayList = visibilityRunnable2.mVisibleViews;
                VisibilityTracker.this.mVisibilityTrackerListener.onVisibilityChanged((List<View>)arrayList, visibilityRunnable2.mInvisibleViews);
            }
            VisibilityRunnable visibilityRunnable3 = this;
            visibilityRunnable3.mVisibleViews.clear();
            visibilityRunnable3.mInvisibleViews.clear();
        }
    }

    static class TrackingInfo {
        int mMinViewablePercent;
        int mMaxInvisiblePercent;
        long mAccessOrder;
        View mRootView;
        Integer mMinVisiblePx;

        TrackingInfo() {
        }
    }
}

