/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.common.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseEvent {
    private final ScribeCategory mScribeCategory;
    private final Name mName;
    private final Category mCategory;
    private final SdkProduct mSdkProduct;
    private final String mAdUnitId;
    private final String mAdCreativeId;
    private final String mAdType;
    private final String mAdNetworkType;
    private final Double mAdWidthPx;
    private final Double mAdHeightPx;
    private final String mDspCreativeId;
    private final Double mGeoLat;
    private final Double mGeoLon;
    private final Double mGeoAccuracy;
    private final String mIsoCountryCode;
    private final Double mPerformanceDurationMs;
    private final String mRequestId;
    private final Integer mRequestStatusCode;
    private final String mRequestUri;
    private final Integer mRequestRetries;
    private final long mTimestampUtcMs;
    private TPDataManager tpDataManager;
    private final double mSamplingRate;

    public BaseEvent(Builder object) {
        long l;
        double d;
        Preconditions.checkNotNull(object);
        this.mScribeCategory = ((Builder)object).mScribeCategory;
        this.mName = ((Builder)object).mName;
        this.mCategory = ((Builder)object).mCategory;
        this.mSdkProduct = ((Builder)object).mSdkProduct;
        this.mAdUnitId = ((Builder)object).mAdUnitId;
        this.mAdCreativeId = ((Builder)object).mAdCreativeId;
        this.mAdType = ((Builder)object).mAdType;
        this.mAdNetworkType = ((Builder)object).mAdNetworkType;
        this.mAdWidthPx = ((Builder)object).mAdWidthPx;
        this.mAdHeightPx = ((Builder)object).mAdHeightPx;
        this.mDspCreativeId = ((Builder)object).mDspCreativeId;
        this.mGeoLat = ((Builder)object).mGeoLat;
        this.mGeoLon = ((Builder)object).mGeoLon;
        this.mGeoAccuracy = ((Builder)object).mGeoAccuracy;
        this.mPerformanceDurationMs = ((Builder)object).mPerformanceDurationMs;
        this.mRequestId = ((Builder)object).mRequestId;
        this.mRequestStatusCode = ((Builder)object).mRequestStatusCode;
        this.mRequestUri = ((Builder)object).mRequestUri;
        this.mRequestRetries = ((Builder)object).mRequestRetries;
        this.mSamplingRate = d = ((Builder)object).mSamplingRate;
        this.mTimestampUtcMs = l = System.currentTimeMillis();
        this.tpDataManager = object = TPDataManager.getInstance();
        this.mIsoCountryCode = object != null ? ((TPDataManager)object).getIsoCountryCode() : null;
    }

    public ScribeCategory getScribeCategory() {
        return this.mScribeCategory;
    }

    public Name getName() {
        return this.mName;
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public SdkProduct getSdkProduct() {
        return this.mSdkProduct;
    }

    public String getSdkVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getSdkVersion();
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    public String getAdCreativeId() {
        return this.mAdCreativeId;
    }

    public String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    public String getAdType() {
        return this.mAdType;
    }

    public String getAdNetworkType() {
        return this.mAdNetworkType;
    }

    public Double getAdWidthPx() {
        return this.mAdWidthPx;
    }

    public Double getAdHeightPx() {
        return this.mAdHeightPx;
    }

    public AppPlatform getAppPlatform() {
        return AppPlatform.ANDROID;
    }

    public String getAppName() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppName();
    }

    public String getAppPackageName() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppPackageName();
    }

    public String getAppVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppVersion();
    }

    public String getObfuscatedClientAdvertisingId() {
        return "ifa:XXXX";
    }

    public String getDeviceOsVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getDeviceOsVersion();
    }

    public Double getGeoLat() {
        return this.mGeoLat;
    }

    public Double getGeoLon() {
        return this.mGeoLon;
    }

    public Double getGeoAccuracy() {
        return this.mGeoAccuracy;
    }

    public Double getPerformanceDurationMs() {
        return this.mPerformanceDurationMs;
    }

    public String getNetworkIsoCountryCode() {
        return this.mIsoCountryCode;
    }

    public String getRequestId() {
        return this.mRequestId;
    }

    public Integer getRequestStatusCode() {
        return this.mRequestStatusCode;
    }

    public String getRequestUri() {
        return this.mRequestUri;
    }

    public Integer getRequestRetries() {
        return this.mRequestRetries;
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public Long getTimestampUtcMs() {
        return this.mTimestampUtcMs;
    }

    public String toString() {
        return "BaseEvent\nScribeCategory: " + (Object)((Object)this.getScribeCategory()) + "\nName: " + (Object)((Object)this.getName()) + "\nCategory: " + (Object)((Object)this.getCategory()) + "\nSdkProduct: " + (Object)((Object)this.getSdkProduct()) + "\nSdkVersion: " + this.getSdkVersion() + "\nAdUnitId: " + this.getAdUnitId() + "\nAdCreativeId: " + this.getAdCreativeId() + "\nAdType: " + this.getAdType() + "\nAdNetworkType: " + this.getAdNetworkType() + "\nAdWidthPx: " + this.getAdWidthPx() + "\nAdHeightPx: " + this.getAdHeightPx() + "\nDspCreativeId: " + this.getDspCreativeId() + "\nAppPlatform: " + (Object)((Object)this.getAppPlatform()) + "\nAppName: " + this.getAppName() + "\nAppPackageName: " + this.getAppPackageName() + "\nAppVersion: " + this.getAppVersion() + "\nDeviceOsVersion: " + this.getDeviceOsVersion() + "\nGeoLat: " + this.getGeoLat() + "\nGeoLon: " + this.getGeoLon() + "\nGeoAccuracy: " + this.getGeoAccuracy() + "\nPerformanceDurationMs: " + this.getPerformanceDurationMs() + "\nNetworkIsoCountryCode: " + this.getNetworkIsoCountryCode() + "\nRequestId: " + this.getRequestId() + "\nRequestStatusCode: " + this.getRequestStatusCode() + "\nRequestUri: " + this.getRequestUri() + "\nRequestRetries: " + this.getRequestRetries() + "\nSamplingRate: " + this.getSamplingRate() + "\nTimestampUtcMs: " + new SimpleDateFormat().format(new Date(this.getTimestampUtcMs())) + "\n";
    }

    public static abstract class Builder {
        private ScribeCategory mScribeCategory;
        private Name mName;
        private Category mCategory;
        private SdkProduct mSdkProduct;
        private String mAdUnitId;
        private String mAdCreativeId;
        private String mAdType;
        private String mAdNetworkType;
        private Double mAdWidthPx;
        private Double mAdHeightPx;
        private String mDspCreativeId;
        private Double mGeoLat;
        private Double mGeoLon;
        private Double mGeoAccuracy;
        private Double mPerformanceDurationMs;
        private String mRequestId;
        private Integer mRequestStatusCode;
        private String mRequestUri;
        private Integer mRequestRetries;
        private double mSamplingRate;

        public Builder(ScribeCategory scribeCategory, Name name, Category category, double d) {
            Preconditions.checkNotNull((Object)scribeCategory);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)category);
            Preconditions.checkArgument(d >= 0.0 && d <= 1.0);
            Builder builder = this;
            builder.mScribeCategory = scribeCategory;
            builder.mName = name;
            builder.mCategory = category;
            builder.mSamplingRate = d;
        }

        public Builder withSdkProduct(SdkProduct sdkProduct) {
            this.mSdkProduct = sdkProduct;
            return this;
        }

        public Builder withAdUnitId(String string) {
            this.mAdUnitId = string;
            return this;
        }

        public Builder withAdCreativeId(String string) {
            this.mAdCreativeId = string;
            return this;
        }

        public Builder withAdType(String string) {
            this.mAdType = string;
            return this;
        }

        public Builder withAdNetworkType(String string) {
            this.mAdNetworkType = string;
            return this;
        }

        public Builder withAdWidthPx(Double d) {
            this.mAdWidthPx = d;
            return this;
        }

        public Builder withAdHeightPx(Double d) {
            this.mAdHeightPx = d;
            return this;
        }

        public Builder withDspCreativeId(String string) {
            this.mDspCreativeId = string;
            return this;
        }

        public Builder withGeoLat(Double d) {
            this.mGeoLat = d;
            return this;
        }

        public Builder withGeoLon(Double d) {
            this.mGeoLon = d;
            return this;
        }

        public Builder withGeoAccuracy(Double d) {
            this.mGeoAccuracy = d;
            return this;
        }

        public Builder withPerformanceDurationMs(Double d) {
            this.mPerformanceDurationMs = d;
            return this;
        }

        public Builder withRequestId(String string) {
            this.mRequestId = string;
            return this;
        }

        public Builder withRequestStatusCode(Integer n) {
            this.mRequestStatusCode = n;
            return this;
        }

        public Builder withRequestUri(String string) {
            this.mRequestUri = string;
            return this;
        }

        public Builder withRequestRetries(Integer n) {
            this.mRequestRetries = n;
            return this;
        }

        public abstract BaseEvent build();
    }

    public static enum ScribeCategory {
        EXCHANGE_CLIENT_EVENT("exchange_client_event"),
        EXCHANGE_CLIENT_ERROR("exchange_client_error");

        private final String mScribeCategory;

        private ScribeCategory(String string2) {
            this.mScribeCategory = string2;
        }

        public String getCategory() {
            return this.mScribeCategory;
        }
    }

    public static enum Name {
        AD_REQUEST("ad_request"),
        REQ_REQUEST("req_request"),
        IMPRESSION_REQUEST("impression_request"),
        CLICK_REQUEST("click_request"),
        VIDEOFIN_REQUEST("videoFin_request"),
        DOWNLOAD_START("download_start"),
        DOWNLOAD_VIDEO_READY("download_video_ready"),
        DOWNLOAD_BUFFERING("download_video_buffering"),
        DOWNLOAD_FINISHED("download_finished"),
        ERROR_DURING_PLAYBACK("error_during_playback"),
        ERROR_FAILED_TO_PLAY("error_failed_to_play"),
        AD_DWELL_TIME("clickthrough_dwell_time");

        private final String mName;

        private Name(String string2) {
            this.mName = string2;
        }

        public String getName() {
            return this.mName;
        }
    }

    public static enum Category {
        REQUESTS("requests"),
        NATIVE_VIDEO("native_video"),
        AD_INTERACTIONS("ad_interactions");

        private final String mCategory;

        private Category(String string2) {
            this.mCategory = string2;
        }

        public String getCategory() {
            return this.mCategory;
        }
    }

    public static enum SdkProduct {
        NONE(0),
        WEB_VIEW(1),
        NATIVE(2);

        private final int mType;

        private SdkProduct(int n2) {
            this.mType = n2;
        }

        public int getType() {
            return this.mType;
        }
    }

    public static enum AppPlatform {
        NONE(0),
        IOS(1),
        ANDROID(2),
        MOBILE_WEB(3);

        private final int mType;

        private AppPlatform(int n2) {
            this.mType = n2;
        }

        public int getType() {
            return this.mType;
        }
    }

    public static enum SamplingRate {
        AD_REQUEST(0.1),
        NATIVE_VIDEO(0.1),
        AD_INTERACTIONS(0.1);

        private final double mSamplingRate;

        private SamplingRate(double d) {
            this.mSamplingRate = d;
        }

        public double getSamplingRate() {
            return this.mSamplingRate;
        }
    }
}

